/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModelKt;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.ide.projectView.actions.MarkLibraryRootAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.FormBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLibraryFromFilesAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(CreateLibraryFromFilesAction.class);
    AnAction myDelegate = new MarkLibraryRootAction();

    public CreateLibraryFromFilesAction() {
        super("Add As Library...");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        if (!ProjectSystemUtil.requiresAndroidModel(project)) {
            this.myDelegate.actionPerformed(e);
            return;
        }
        List<VirtualFile> jars = CreateLibraryFromFilesAction.getRoots(e);
        if (jars.isEmpty()) {
            return;
        }
        List roots = RootDetectionUtil.detectRoots(jars, null, (Project)project, (LibraryRootsComponentDescriptor)new DefaultLibraryRootsComponentDescriptor());
        new CreateGradleLibraryFromFilesDialog(project, roots).show();
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e);
        boolean visible = false;
        if (project != null && ModuleManager.getInstance((Project)project).getModules().length > 0) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (VirtualFile root : CreateLibraryFromFilesAction.getRoots(e)) {
                if (root.isInLocalFileSystem() || !FileUtilRt.extensionEquals((String)root.getName(), (String)"jar") || fileIndex.isInLibraryClasses(root)) continue;
                visible = true;
                break;
            }
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(visible);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    private static List<VirtualFile> getRoots(@NotNull AnActionEvent e) {
        Project project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e);
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null || files2 == null || files2.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (VirtualFile file : files2) {
            VirtualFile root = JarFileSystem.getInstance().getJarRootForLocalFile(file);
            if (root == null) continue;
            roots.add(root);
        }
        return roots;
    }

    @NotNull
    private static List<Module> getAndroidModules(@NotNull Project project) {
        return Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(module -> {
            GradleModuleModel gradleModuleModel = GradleModuleModelKt.getGradleModuleModel(module);
            return gradleModuleModel != null && gradleModuleModel.getBuildFilePath() != null;
        }).collect(Collectors.toList());
    }

    private static class CreateGradleLibraryFromFilesDialog
    extends DialogWrapper {
        public static final String COMMAND_TITLE = "Create Library";
        private final ModulesComboBox myModulesComboBox;
        private final Project myProject;
        private final JPanel myPanel;
        private final List<OrderRoot> myRoots;

        private CreateGradleLibraryFromFilesDialog(@NotNull Project project, @NotNull List<OrderRoot> roots) {
            super(project, true);
            this.setTitle(COMMAND_TITLE);
            this.myProject = project;
            this.myRoots = roots;
            FormBuilder builder = LibraryNameAndLevelPanel.createFormBuilder();
            this.myModulesComboBox = new ModulesComboBox();
            List<Module> androidModules = CreateLibraryFromFilesAction.getAndroidModules(project);
            Module initialSelection = this.findModule(roots);
            this.myModulesComboBox.setModules(androidModules);
            if (!androidModules.contains(initialSelection) && !androidModules.isEmpty()) {
                initialSelection = androidModules.get(0);
            }
            this.myModulesComboBox.setSelectedModule(initialSelection);
            builder.addLabeledComponent("&Add to module:", (JComponent)this.myModulesComboBox);
            this.myPanel = builder.getPanel();
            this.init();
        }

        @Nullable
        private Module findModule(List<OrderRoot> roots) {
            for (OrderRoot root : roots) {
                Module module = null;
                VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(root.getFile());
                if (local != null) {
                    module = ModuleUtilCore.findModuleForFile((VirtualFile)local, (Project)this.myProject);
                }
                if (module == null) {
                    module = ModuleUtilCore.findModuleForFile((VirtualFile)root.getFile(), (Project)this.myProject);
                }
                if (module == null) continue;
                return module;
            }
            return null;
        }

        protected void doOKAction() {
            Module module = this.myModulesComboBox.getSelectedModule();
            if (module == null) {
                this.showErrorDialog("Could not find module, please add the dependency manually");
                return;
            }
            ProgressWindow progress2 = new ProgressWindow(false, this.myProject);
            Runnable process2 = () -> {
                ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
                GradleBuildModel gradleBuildModel = projectBuildModel.getModuleBuildModel(module);
                if (gradleBuildModel == null) {
                    this.showErrorDialog("Could not understand build file for module '" + module.getName() + "' please add the dependency manually.");
                    return;
                }
                HashSet<String> addedRoots = new HashSet<String>();
                String scope = "implementation";
                for (OrderRoot root : this.myRoots) {
                    VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(root.getFile());
                    if (local == null) {
                        LOG.warn("Couldn't find JAR for " + root.getFile().getPath());
                        continue;
                    }
                    if (addedRoots.contains(local.getPath())) continue;
                    VirtualFile parent = gradleBuildModel.getVirtualFile().getParent();
                    String path = VfsUtilCore.findRelativePath((VirtualFile)parent, (VirtualFile)local, (char)File.separatorChar);
                    if (path == null) {
                        path = local.getPath();
                    }
                    addedRoots.add(local.getPath());
                    gradleBuildModel.dependencies().addFile(scope, path);
                }
                if (!gradleBuildModel.isModified()) {
                    this.showErrorDialog("Failed to find any files to add, please add the dependency manually");
                    return;
                }
                ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)"Add Library from Files", null, () -> projectBuildModel.applyChanges(), (PsiFile[])new PsiFile[0]));
                ApplicationManager.getApplication().invokeLater(() -> ProjectSystemUtil.getProjectSystem(this.myProject).getSyncManager().requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED));
            };
            progress2.setTitle("Adding Dependencies to Gradle build file");
            ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)progress2));
            super.doOKAction();
        }

        private void showErrorDialog(@NotNull String error) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)error, (String)"Create Library Action"));
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }
    }
}

