/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.actions.AndroidOpenFileActionUtils;
import com.android.tools.idea.actions.OpenProjectFileChooserDescriptorWithAsyncIcon;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralLocalSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidOpenFileAction
extends DumbAwareAction {
    public AndroidOpenFileAction() {
        this("Open...");
    }

    public AndroidOpenFileAction(@NotNull String text2) {
        super(text2, null, AllIcons.Actions.MenuOpen);
        this.getTemplatePresentation().setApplicationScope(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.Open);
            e.getPresentation().setSelectedIcon(AllIcons.Welcome.OpenSelected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Disposable disposable = Disposer.newDisposable();
        try {
            VirtualFile explicitPreferredDirectory;
            Project project = e.getProject();
            boolean showFiles = project != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
            OpenProjectFileChooserDescriptorWithAsyncIcon descriptor2 = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
            descriptor2.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, showFiles);
            Disposer.register((Disposable)disposable, (Disposable)descriptor2);
            VirtualFile virtualFile = explicitPreferredDirectory = project != null && !project.isDefault() ? project.getBaseDir() : null;
            if (explicitPreferredDirectory == null) {
                String defaultProjectDirectory = GeneralLocalSettings.getInstance().getDefaultProjectDirectory();
                explicitPreferredDirectory = StringUtil.isNotEmpty((String)defaultProjectDirectory) ? VfsUtil.findFileByIoFile((File)new File(defaultProjectDirectory), (boolean)true) : VfsUtil.getUserHomeDir();
            }
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)explicitPreferredDirectory, files2 -> {
                ValidationIssue issue2 = AndroidOpenFileAction.validateFiles(files2, (FileChooserDescriptor)descriptor2);
                if (issue2.result.getSeverity() != Validator.Severity.OK) {
                    boolean isError = issue2.result.getSeverity() == Validator.Severity.ERROR;
                    String title2 = isError ? IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]) : "Warning Opening Project";
                    Messages.showInfoMessage((Project)project, (String)issue2.result.getMessage(), (String)title2);
                    if (isError) {
                        return;
                    }
                }
                AndroidOpenFileAction.doOpenFile(e, files2);
            });
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    @VisibleForTesting
    @NotNull
    static ValidationIssue validateFiles(List<VirtualFile> files2, FileChooserDescriptor descriptor2) {
        for (VirtualFile file : files2) {
            if (descriptor2.isFileSelectable(file)) continue;
            Validator.Result result2 = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("title.cannot.open.file", file.getPresentableUrl()));
            return new ValidationIssue(result2, file);
        }
        return new ValidationIssue(Validator.Result.OK, null);
    }

    private static void doOpenFile(@NotNull AnActionEvent e, @NotNull List<VirtualFile> result2) {
        Project project = e.getProject();
        for (VirtualFile file : result2) {
            if (file.isDirectory()) {
                if (project != null && !project.isDefault() && file.equals(project.getBaseDir())) {
                    ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
                    continue;
                }
                if (ProjectAttachProcessor.canAttachToProject()) {
                    Project openedProject = AndroidOpenFileActionUtils.doOpenProject(file, project);
                    FileChooserUtil.setLastOpenedFile((Project)openedProject, (Path)file.toNioPath());
                    continue;
                }
                AndroidOpenFileAction.openOrImportProject(file, project);
                continue;
            }
            if ((project == null || !file.equals(project.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile((VirtualFile)file) && AndroidOpenFileAction.openOrImportProject(file, project) || AndroidOpenFileAction.getKnownFileTypeOrAssociate(file) == null) continue;
            if (project != null) {
                OpenFileAction.openFile((VirtualFile)file, (Project)project);
                continue;
            }
            PlatformProjectOpenProcessor processor = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor == null) continue;
            processor.doOpenProject(file, null, false);
        }
    }

    @Nullable
    private static FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file) {
        FileType type = file.getFileType();
        if (type != FileTypes.UNKNOWN) {
            return type;
        }
        String fileName = file.getName();
        type = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (type != FileTypes.UNKNOWN) {
            return type;
        }
        return FileTypeChooser.associateFileType((String)fileName);
    }

    private static boolean openOrImportProject(@NotNull VirtualFile file, @Nullable Project project) {
        Project opened = ProjectUtil.openOrImport((String)file.getPath(), (Project)project, (boolean)false);
        if (opened != null) {
            FileChooserUtil.setLastOpenedFile((Project)opened, (Path)file.toNioPath());
            return true;
        }
        return false;
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptorWithAsyncIcon {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        public ProjectOrFileChooserDescriptor() {
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            return file.isDirectory() ? super.isFileVisible(file, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file, showHiddenFiles);
        }

        public boolean isFileSelectable(@Nullable VirtualFile file) {
            if (file == null) {
                return false;
            }
            return file.isDirectory() ? super.isFileSelectable(file) : this.myStandardDescriptor.isFileSelectable(file);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptorWithAsyncIcon {
        public ProjectOnlyFileChooserDescriptor() {
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }

    @VisibleForTesting
    static final class ValidationIssue {
        @NotNull
        Validator.Result result;
        @Nullable
        VirtualFile file;

        public ValidationIssue(@NotNull Validator.Result result2, @Nullable VirtualFile file) {
            this.result = result2;
            this.file = file;
        }
    }
}

