/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.tools.idea.actions.AnnotateTask;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.DependencyType;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleModuleSystem;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.module.AndroidModuleInfo;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

public class AndroidInferNullityAnnotationAction
extends InferNullityAnnotationsAction {
    private static final Logger LOG = Logger.getInstance(AndroidInferNullityAnnotationAction.class);
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    private static final String ADD_DEPENDENCY = "Add Support Dependency";
    private static final int MIN_SDK_WITH_NULLABLE = 19;

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        AndroidInferNullityAnnotationAction.setUpNullityAnnotationDefaults(project);
        if (!(ProjectSystemUtil.getProjectSystem(project) instanceof GradleProjectSystem)) {
            super.analyze(project, scope);
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageInfo[] usageInfos = this.findUsages(project, scope, scope.getFileCount());
        if (usageInfos == null) {
            return;
        }
        Map<Module, PsiFile> modules = AndroidInferNullityAnnotationAction.findModulesFromUsage(usageInfos);
        if (!this.checkModules(project, scope, modules)) {
            return;
        }
        if (usageInfos.length < 5) {
            if (ApplicationUtilsKt.isUnitTestMode()) {
                AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> usageInfos)).run();
            } else {
                DumbService.getInstance((Project)project).smartInvokeLater(AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> usageInfos)));
            }
        } else {
            AndroidInferNullityAnnotationAction.showUsageView(project, usageInfos, scope, this);
        }
    }

    private static void setUpNullityAnnotationDefaults(@NotNull Project project) {
        NullableNotNullManager nullityManager = NullableNotNullManager.getInstance((Project)project);
        if (Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).anyMatch(module -> DependencyManagementUtil.dependsOnAndroidx(module))) {
            nullityManager.setDefaultNotNull("androidx.annotation.NonNull");
            nullityManager.setDefaultNullable("androidx.annotation.Nullable");
        } else {
            nullityManager.setDefaultNotNull("android.support.annotation.NonNull");
            nullityManager.setDefaultNullable("android.support.annotation.Nullable");
        }
    }

    private static Map<Module, PsiFile> findModulesFromUsage(UsageInfo[] infos) {
        HashMap<Module, PsiFile> modules = new HashMap<Module, PsiFile>();
        for (UsageInfo info : infos) {
            PsiElement element = info.getElement();
            assert (element != null);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            PsiFile file = element.getContainingFile();
            modules.put(module, file);
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkModules(@NotNull Project project, @NotNull AnalysisScope scope, @NotNull Map<Module, PsiFile> modules) {
        HashSet<Module> modulesWithoutAnnotations = new HashSet<Module>();
        HashSet<Module> modulesWithLowVersion = new HashSet<Module>();
        for (Module module : modules.keySet()) {
            ProjectBuildModel projectModel;
            GradleBuildModel buildModel;
            AndroidModuleInfo info = StudioAndroidModuleInfo.getInstance(module);
            if (info != null && info.getBuildSdkVersion() != null && info.getBuildSdkVersion().getFeatureLevel() < 19) {
                modulesWithLowVersion.add(module);
            }
            if ((buildModel = (projectModel = ProjectBuildModel.get(module.getProject())).getModuleBuildModel(module)) == null) {
                LOG.warn("Unable to find Gradle build model for module " + module.getName());
                continue;
            }
            boolean dependencyFound = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (ArtifactDependencyModel dependency : dependenciesModel.artifacts("implementation")) {
                String notation = dependency.compactNotation();
                if (!notation.startsWith(GoogleMavenArtifactId.SUPPORT_APPCOMPAT_V7.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_APPCOMPAT.toString()) && !notation.startsWith(GoogleMavenArtifactId.SUPPORT_V4.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_LEGACY_SUPPORT_V4.toString()) && !notation.startsWith(GoogleMavenArtifactId.SUPPORT_ANNOTATIONS.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_ANNOTATION.toString())) continue;
                dependencyFound = true;
                break;
            }
            if (dependencyFound) continue;
            modulesWithoutAnnotations.add(module);
        }
        if (!modulesWithLowVersion.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)String.format(Locale.US, "Infer Nullity Annotations requires the project sdk level be set to %1$d or greater.", 19), (String)INFER_NULLITY_ANNOTATIONS);
            return false;
        }
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String moduleNames = StringUtil.join(modulesWithoutAnnotations, Module::getName, (String)", ");
        int count = modulesWithoutAnnotations.size();
        String message = String.format("The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android nullity annotations. \n\nWould you like to add the %5$s now?", StringUtil.pluralize((String)"module", (int)count), moduleNames, count > 1 ? "do" : "does", GoogleMavenArtifactId.SUPPORT_ANNOTATIONS.getMavenArtifactId(), StringUtil.pluralize((String)"dependency", (int)count));
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(ADD_DEPENDENCY);
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> {
                    GoogleMavenArtifactId annotation;
                    RepositoryUrlManager manager = RepositoryUrlManager.get();
                    Version annotationsVersion = manager.findVersion((annotation = MigrateToAndroidxUtil.isAndroidx(project) ? GoogleMavenArtifactId.ANDROIDX_ANNOTATION : GoogleMavenArtifactId.SUPPORT_ANNOTATIONS).getGroupId(), annotation.getArtifactId(), null, true, FileSystems.getDefault());
                    if (annotationsVersion != null) {
                        for (Module module : modulesWithoutAnnotations) {
                            AndroidInferNullityAnnotationAction.addDependency(module, annotation.getDependency(annotationsVersion.toString()));
                        }
                    }
                    this.syncAndRestartAnalysis(project, scope);
                });
            }
            finally {
                action2.finish();
            }
        }
        return false;
    }

    protected void syncAndRestartAnalysis(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

            public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                if (syncResult != null && syncResult.isSuccessful()) {
                    AndroidInferNullityAnnotationAction.this.restartAnalysis(project, scope);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                if (!(t instanceof CancellationException)) {
                    LOG.warn(t);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    protected static Runnable applyRunnable(Project project, Computable<UsageInfo[]> computable) {
        return () -> {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(INFER_NULLITY_ANNOTATIONS);
            try {
                ReadAction.run(() -> {
                    UsageInfo[] infos = (UsageInfo[])computable.compute();
                    if (infos.length > 0) {
                        Runnable command = () -> {
                            Set files2 = (Set)StreamEx.of((Object[])infos).map(UsageInfo::getElement).nonNull().map(PsiElement::getContainingFile).nonNull().map(PsiFile::getVirtualFile).nonNull().toCollection(LinkedHashSet::new);
                            if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project, (Collection)files2)) {
                                return;
                            }
                            SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, INFER_NULLITY_ANNOTATIONS);
                            progressTask.setMinIterationTime(200L);
                            progressTask.setTask((SequentialTask)new AnnotateTask(project, progressTask, infos));
                            ProgressManager.getInstance().run((Task)progressTask);
                        };
                        CommandProcessor.getInstance().executeCommand(project, command, INFER_NULLITY_ANNOTATIONS, null);
                    } else {
                        NullityInferrer.nothingFoundMessage((Project)project);
                    }
                });
            }
            finally {
                action2.finish();
            }
        };
    }

    private static void showUsageView(@NotNull Project project, UsageInfo[] usageInfos, @NotNull AnalysisScope scope, AndroidInferNullityAnnotationAction action2) {
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), "Preprocess Usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, AndroidInferNullityAnnotationAction.rerunFactory(project, scope, action2));
        Runnable refactoringRunnable = AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> {
            Set infos = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
            return infos.toArray(UsageInfo.EMPTY_ARRAY);
        }));
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable, INFER_NULLITY_ANNOTATIONS, canNotMakeString, INFER_NULLITY_ANNOTATIONS, false);
    }

    @NotNull
    private static Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope, final AndroidInferNullityAnnotationAction action2) {
        return () -> new UsageInfoSearcherAdapter(){

            protected UsageInfo[] findUsages() {
                return action2.findUsages(project, scope, scope.getFileCount());
            }

            public void generate(@NotNull Processor<? super Usage> processor) {
                this.processUsages(processor, project);
            }
        };
    }

    private static void addDependency(@NotNull Module module, @NotNull Dependency dependency) {
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
        if (moduleSystem instanceof GradleModuleSystem) {
            GradleModuleSystem gradleModuleSystem = (GradleModuleSystem)moduleSystem;
            gradleModuleSystem.registerDependency(dependency, DependencyType.IMPLEMENTATION);
        }
    }

    protected JComponent getAdditionalActionSettings(@NotNull Project project, BaseAnalysisActionDialog dialog2) {
        JComponent panel2 = super.getAdditionalActionSettings(project, dialog2);
        if (panel2 != null && ProjectSystemUtil.getProjectSystem(project) instanceof GradleProjectSystem) {
            panel2.setVisible(false);
        }
        return panel2;
    }
}

