/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidStudioUpdateStrategyCustomization
extends UpdateStrategyCustomization {
    public boolean forceEapUpdateChannelForEapBuilds() {
        return false;
    }

    public boolean isChannelActive(@NotNull ChannelStatus channel) {
        return true;
    }

    public boolean haveSameMajorVersion(@NotNull BuildNumber build1, @NotNull BuildNumber build2) {
        return AndroidStudioUpdateStrategyCustomization.androidStudioVersion(build1) == AndroidStudioUpdateStrategyCustomization.androidStudioVersion(build2);
    }

    public boolean isNewerVersion(@NotNull BuildNumber candidateBuild, @NotNull BuildNumber currentBuild) {
        if (AndroidStudioUpdateStrategyCustomization.androidStudioVersion(candidateBuild) == AndroidStudioUpdateStrategyCustomization.androidStudioVersion(currentBuild)) {
            return super.isNewerVersion(candidateBuild, currentBuild);
        }
        return AndroidStudioUpdateStrategyCustomization.androidStudioVersion(candidateBuild) > AndroidStudioUpdateStrategyCustomization.androidStudioVersion(currentBuild);
    }

    @NotNull
    public ChannelStatus changeDefaultChannel(@NotNull ChannelStatus currentChannel) {
        String versionName2 = ApplicationInfo.getInstance().getFullVersion();
        return this.versionNameToChannelStatus(versionName2);
    }

    public boolean isChannelApplicableForUpdates(@NotNull UpdateChannel updateChannel, @NotNull ChannelStatus selectedChannel) {
        return updateChannel.getStatus().equals((Object)selectedChannel);
    }

    public boolean canBeUsedForIntermediatePatches(@NotNull UpdateChannel updateChannel, @NotNull ChannelStatus selectedChannel) {
        return updateChannel.getStatus().equals((Object)selectedChannel);
    }

    @NlsContexts.DetailedDescription
    @Nullable
    public String getChannelSelectionLockedMessage() {
        return AndroidBundle.message("updates.settings.channel.locked", new Object[0]);
    }

    private static int androidStudioVersion(BuildNumber buildNumber) {
        return buildNumber.getComponents()[3];
    }

    private boolean versionNameContainsChannel(String versionName2, String channel) {
        return Pattern.compile("\\b" + channel + "\\b", 2).matcher(versionName2).find();
    }

    protected ChannelStatus versionNameToChannelStatus(String versionName2) {
        if (this.versionNameContainsChannel(versionName2, "nightly") || this.versionNameContainsChannel(versionName2, "dev")) {
            return ChannelStatus.MILESTONE;
        }
        if (this.versionNameContainsChannel(versionName2, "canary")) {
            return ChannelStatus.EAP;
        }
        if (this.versionNameContainsChannel(versionName2, "rc") || this.versionNameContainsChannel(versionName2, "beta")) {
            return ChannelStatus.BETA;
        }
        return ChannelStatus.RELEASE;
    }
}

