/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.componenttree.treetable.TreeTableImpl;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0010H\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020$H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020$H\u0002J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010-\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0006H\u0002J(\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u0002022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\t2\u0006\u00101\u001a\u000202H\u0002J\b\u00108\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\u00020\u0012*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\u00020\u0012*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0018\u00105\u001a\u000202*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u00069"}, d2={"Lcom/android/tools/componenttree/treetable/TreeTableDropTargetHandler;", "Lcom/intellij/ide/dnd/DnDDropHandler$WithResult;", "Lcom/intellij/ide/dnd/DnDTargetChecker;", "table", "Lcom/android/tools/componenttree/treetable/TreeTableImpl;", "deleteOriginOfInternalMove", "", "draggedItems", "", "", "<init>", "(Lcom/android/tools/componenttree/treetable/TreeTableImpl;ZLjava/util/List;)V", "lineColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "dashedStroke", "Ljava/awt/Stroke;", "insertionRow", "", "insertionDepth", "insertionBounds", "Ljava/awt/Rectangle;", "receiverRow", "receiverBounds", "lastDropWasPossible", "tryDrop", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "updateUI", "", "reset", "paintDropTargetPosition", "g", "Ljava/awt/Graphics;", "createDashStroke", "paintReceiverRectangle", "Ljava/awt/Graphics2D;", "paintColumnLine", "bottom", "getBottom", "(Ljava/awt/Rectangle;)I", "right", "getRight", "paintInsertionLine", "update", "dropPossible", "possible", "findReceiver", "isMove", "data", "Ljava/awt/datatransfer/Transferable;", "canDropInto", "receiver", "transferable", "getTransferable", "(Lcom/intellij/ide/dnd/DnDEvent;)Ljava/awt/datatransfer/Transferable;", "clearInsertionPoint", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nTreeTableDropTargetHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeTableDropTargetHandler.kt\ncom/android/tools/componenttree/treetable/TreeTableDropTargetHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,267:1\n1#2:268\n2275#3,2:269\n2275#3:278\n2276#3:282\n1761#4,3:271\n1761#4,3:279\n37#5:274\n36#5,3:275\n*S KotlinDebug\n*F\n+ 1 TreeTableDropTargetHandler.kt\ncom/android/tools/componenttree/treetable/TreeTableDropTargetHandler\n*L\n224#1:269,2\n248#1:278\n248#1:282\n229#1:271,3\n248#1:279,3\n238#1:274\n238#1:275,3\n*E\n"})
public final class TreeTableDropTargetHandler
implements DnDDropHandler.WithResult,
DnDTargetChecker {
    @NotNull
    private final TreeTableImpl table;
    private final boolean deleteOriginOfInternalMove;
    @NotNull
    private final List<Object> draggedItems;
    @NotNull
    private Color lineColor;
    @NotNull
    private Stroke dashedStroke;
    private int insertionRow;
    private int insertionDepth;
    @Nullable
    private Rectangle insertionBounds;
    private int receiverRow;
    @Nullable
    private Rectangle receiverBounds;
    private boolean lastDropWasPossible;

    public TreeTableDropTargetHandler(@NotNull TreeTableImpl table2, boolean deleteOriginOfInternalMove, @NotNull List<Object> draggedItems) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter(draggedItems, (String)"draggedItems");
        this.table = table2;
        this.deleteOriginOfInternalMove = deleteOriginOfInternalMove;
        this.draggedItems = draggedItems;
        Color color = ColorUtil.brighter((Color)UIUtil.getTreeSelectionBackground((boolean)true), (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(...)");
        this.lineColor = color;
        this.dashedStroke = this.createDashStroke();
        this.insertionRow = -1;
        this.insertionDepth = -1;
        this.receiverRow = -1;
    }

    public boolean tryDrop(@NotNull DnDEvent event) {
        boolean isMove;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean dropped = false;
        boolean bl = isMove = event.getAction() == DnDAction.MOVE;
        if (!this.update(event)) {
            Object receiver2 = this.table.getValueAt(this.receiverRow, 0);
            Object before = this.table.getValueAt(this.insertionRow, 0);
            if (before != null && this.table.getTableModel().parent(before) != receiver2) {
                before = null;
            }
            dropped = this.table.getTableModel().insert(receiver2, this.getTransferable(event), before, isMove, this.draggedItems);
        }
        if (isMove && !this.deleteOriginOfInternalMove) {
            this.draggedItems.clear();
        }
        this.clearInsertionPoint();
        return dropped;
    }

    public final void updateUI() {
        Color color = ColorUtil.brighter((Color)UIUtil.getTreeSelectionBackground((boolean)true), (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(...)");
        this.lineColor = color;
        this.dashedStroke = this.createDashStroke();
    }

    public final void reset() {
        this.clearInsertionPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintDropTargetPosition(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.insertionRow >= 0) {
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2 = (Graphics2D)graphics;
            try {
                g2.setColor(this.lineColor);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.paintReceiverRectangle(g2);
                this.paintInsertionLine(g2);
                this.paintColumnLine(g2);
            }
            finally {
                g2.dispose();
            }
        }
    }

    private final Stroke createDashStroke() {
        float[] fArray = new float[]{JBUIScale.scale((float)4.0f), JBUIScale.scale((float)4.0f)};
        return new BasicStroke(JBUIScale.scale((float)1.0f), 2, 0, JBUIScale.scale((float)10.0f), fArray, 0.0f);
    }

    private final void paintReceiverRectangle(Graphics2D g) {
        block0: {
            Rectangle rectangle = this.receiverBounds;
            if (rectangle == null) break block0;
            Rectangle it = rectangle;
            boolean bl = false;
            int x = Math.max(0, it.x - JBUIScale.scale((int)2));
            int maxWidth = this.table.getColumnModel().getColumn(0).getWidth();
            int width = Math.min(maxWidth - x, it.width + JBUIScale.scale((int)2));
            g.drawRect(x, it.y, width, it.height);
        }
    }

    private final void paintColumnLine(Graphics2D g) {
        Rectangle rectangle = this.receiverBounds;
        int x = (rectangle != null ? rectangle.x : 0) + JBUIScale.scale((int)7);
        Rectangle rectangle2 = this.receiverBounds;
        int y = rectangle2 != null ? this.getBottom(rectangle2) : 0;
        g.setStroke(this.dashedStroke);
        Rectangle rectangle3 = this.insertionBounds;
        g.drawLine(x, y, x, rectangle3 != null ? this.getBottom(rectangle3) : y);
    }

    private final int getBottom(Rectangle $this$bottom) {
        return $this$bottom.y + $this$bottom.height;
    }

    private final int getRight(Rectangle $this$right) {
        return $this$right.x + $this$right.width;
    }

    private final void paintInsertionLine(Graphics2D g) {
        Polygon triangle = new Polygon();
        int indicatorSize = JBUIScale.scale((int)6);
        Rectangle rectangle = this.receiverBounds;
        int x = (rectangle != null ? rectangle.x : 0) + JBUIScale.scale((int)6);
        Rectangle rectangle2 = this.insertionBounds;
        int y = rectangle2 != null ? this.getBottom(rectangle2) : 0;
        triangle.addPoint(x + indicatorSize, y);
        triangle.addPoint(x, y + indicatorSize / 2);
        triangle.addPoint(x, y - indicatorSize / 2);
        Rectangle rectangle3 = this.insertionBounds;
        g.drawLine(x, y, rectangle3 != null ? this.getRight(rectangle3) : x, y);
        g.drawPolygon(triangle);
        g.fillPolygon(triangle);
    }

    public boolean update(@NotNull DnDEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Point point = new Point(event.getPoint().x, event.getPoint().y + this.table.getRowHeight() / 2);
        int column2 = this.table.columnAtPoint(point);
        if (column2 != 0) {
            return this.dropPossible(event, false);
        }
        int newInsertionDepth = this.table.findDepthFromOffset(point.x);
        Integer n = this.table.rowAtPoint(point);
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = it >= 0 ? n : null;
        int newInsertionRow = n2 != null ? n2.intValue() : this.table.getRowCount();
        if (this.insertionRow == newInsertionRow && this.insertionDepth == newInsertionDepth) {
            bl = this.dropPossible(event, this.lastDropWasPossible);
        } else if (!this.findReceiver(event.getAction() == DnDAction.MOVE, this.getTransferable(event), newInsertionRow, newInsertionDepth)) {
            bl = this.dropPossible(event, false);
        } else {
            this.insertionRow = newInsertionRow;
            this.insertionDepth = newInsertionDepth;
            this.insertionBounds = !this.table.isEmpty() ? this.table.getTree().getRowBounds(Math.max(0, this.insertionRow - 1)) : new Rectangle(0, 0, this.table.getColumnModel().getColumn(0).getWidth(), 0);
            this.table.repaint();
            bl = this.dropPossible(event, true);
        }
        return bl;
    }

    private final boolean dropPossible(DnDEvent event, boolean possible) {
        if (this.lastDropWasPossible && !possible) {
            this.clearInsertionPoint();
        }
        this.lastDropWasPossible = possible;
        event.setDropPossible(possible);
        return !possible;
    }

    private final boolean findReceiver(boolean isMove, Transferable data2, int insertionRow, int insertionDepth) {
        Object object;
        this.receiverRow = -1;
        this.receiverBounds = null;
        Object item = null;
        Object object2 = this.table.getModel().getValueAt(insertionRow - 1, 0);
        if (object2 == null) {
            return false;
        }
        Object it = object = (item = object2);
        boolean bl = false;
        Object receiver2 = this.canDropInto(item, data2) ? object : null;
        int index = 0;
        while (index + 1 >= this.table.getTableModel().getChildCount(item) && (receiver2 == null || insertionDepth < this.table.getTableModel().computeDepth(item)) && this.table.getTableModel().parent(item) != null) {
            Object object3;
            Object parent;
            index = this.table.getTableModel().getIndexOfChild(parent, item);
            Object it2 = object3 = (item = parent);
            boolean bl2 = false;
            Object object4 = this.canDropInto(item, data2) ? object3 : null;
            if (object4 == null) {
                object4 = receiver2;
            }
            receiver2 = object4;
        }
        if (receiver2 == null) {
            return false;
        }
        Object before = this.table.getModel().getValueAt(insertionRow, 0);
        if (before != null) {
            boolean bl3;
            Object it3;
            Object element$iv;
            Iterator bl2;
            Object parentOfBefore;
            block12: {
                parentOfBefore = this.table.getTableModel().parent(before);
                Sequence $this$none$iv = SequencesKt.generateSequence((Object)receiver2, arg_0 -> TreeTableDropTargetHandler.findReceiver$lambda$2(this, arg_0));
                boolean $i$f$none = false;
                bl2 = $this$none$iv.iterator();
                while (bl2.hasNext()) {
                    it3 = element$iv = bl2.next();
                    boolean bl4 = false;
                    if (!(it3 == parentOfBefore)) continue;
                    bl3 = false;
                    break block12;
                }
                bl3 = true;
            }
            if (bl3) {
                return false;
            }
            if (isMove && parentOfBefore == receiver2) {
                boolean bl5;
                block13: {
                    Iterable $this$any$iv = this.draggedItems;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        bl2 = $this$any$iv.iterator();
                        while (bl2.hasNext()) {
                            it3 = element$iv = bl2.next();
                            boolean bl6 = false;
                            if (!(before == it3)) continue;
                            bl5 = true;
                            break block13;
                        }
                        bl5 = false;
                    }
                }
                if (bl5) {
                    return false;
                }
            }
        }
        Collection $this$toTypedArray$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)item, arg_0 -> TreeTableDropTargetHandler.findReceiver$lambda$5(this, arg_0))));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TreePath path = new TreePath(thisCollection$iv.toArray(new Object[0]));
        this.receiverRow = this.table.getTree().getRowForPath(path);
        this.receiverBounds = this.table.getTree().getPathBounds(path);
        return true;
    }

    private final boolean canDropInto(Object receiver2, Transferable data2) {
        boolean bl;
        block5: {
            Sequence $this$none$iv = SequencesKt.generateSequence((Object)receiver2, arg_0 -> TreeTableDropTargetHandler.canDropInto$lambda$0(this, arg_0));
            boolean $i$f$none = false;
            Iterator iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                block4: {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl3 = false;
                    Iterable $this$any$iv = this.draggedItems;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        Iterator iterator3 = $this$any$iv.iterator();
                        while (iterator3.hasNext()) {
                            Object element$iv2;
                            Object dragged = element$iv2 = iterator3.next();
                            boolean bl4 = false;
                            if (!(dragged == it)) continue;
                            bl2 = true;
                            break block4;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        return bl && this.table.getTableModel().canInsert(receiver2, data2);
    }

    private final Transferable getTransferable(DnDEvent $this$transferable) {
        Object object = $this$transferable.getAttachedObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ide.dnd.DnDNativeTarget.EventInfo");
        Transferable transferable = ((DnDNativeTarget.EventInfo)object).getTransferable();
        Intrinsics.checkNotNullExpressionValue((Object)transferable, (String)"getTransferable(...)");
        return transferable;
    }

    private final void clearInsertionPoint() {
        this.lastDropWasPossible = false;
        boolean repaint = this.insertionRow >= 0;
        this.insertionRow = -1;
        this.insertionDepth = -1;
        this.insertionBounds = null;
        this.receiverRow = -1;
        this.receiverBounds = null;
        if (repaint) {
            this.table.repaint();
        }
    }

    private static final Object findReceiver$lambda$2(TreeTableDropTargetHandler this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.table.getTableModel().parent(it);
    }

    private static final Object findReceiver$lambda$5(TreeTableDropTargetHandler this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.table.getTableModel().parent(it);
    }

    private static final Object canDropInto$lambda$0(TreeTableDropTargetHandler this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.table.getTableModel().parent(it);
    }
}

