/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.HistogramUtil;
import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.google.wireless.android.sdk.stats.EditorHighlightingStats;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/analytics/HighlightingStats;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "startRecording", "", "dispose", "latencyRecorders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/wireless/android/sdk/stats/EditorFileType;", "Lorg/HdrHistogram/Recorder;", "recordHighlightingLatency", "document", "Lcom/intellij/openapi/editor/Document;", "latencyMs", "", "reportHighlightingStats", "convertFileType", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCMakeFileByName", "", "", "Companion", "analytics"})
@SourceDebugExtension(value={"SMAP\nHighlightingStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightingStats.kt\ncom/android/tools/analytics/HighlightingStats\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,153:1\n24#2:154\n*S KotlinDebug\n*F\n+ 1 HighlightingStats.kt\ncom/android/tools/analytics/HighlightingStats\n*L\n80#1:154\n*E\n"})
public final class HighlightingStats
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<EditorFileType, Recorder> latencyRecorders = new ConcurrentHashMap();
    private static final int MAX_LATENCY_MS = 600000;

    public final void startRecording() {
        boolean callbackInstalled = ReflectionUtil.setField(GeneralHighlightingPass.class, null, BiConsumer.class, (String)"latencyCallbackForAndroidStudio", this::recordHighlightingLatency);
        if (callbackInstalled) {
            JobScheduler.getScheduler().scheduleWithFixedDelay(this::reportHighlightingStats, 1L, 1L, TimeUnit.HOURS);
        } else {
            HighlightingStats $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(HighlightingStats.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to install hook for measuring highlighting latency");
        }
    }

    public void dispose() {
        this.reportHighlightingStats();
    }

    public final void recordHighlightingLatency(@NotNull Document document, long latencyMs) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (latencyMs < 0L || latencyMs > 600000L) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        EditorFileType fileType = this.convertFileType(file);
        Recorder recorder = this.latencyRecorders.computeIfAbsent(fileType, arg_0 -> HighlightingStats.recordHighlightingLatency$lambda$1(HighlightingStats::recordHighlightingLatency$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)recorder, (String)"computeIfAbsent(...)");
        Recorder recorder2 = recorder;
        recorder2.recordValue(latencyMs);
    }

    public final void reportHighlightingStats() {
        AndroidStudioEvent.Builder builder;
        EditorHighlightingStats.Builder allStats = EditorHighlightingStats.newBuilder();
        for (Map.Entry builder2 : ((Map)this.latencyRecorders).entrySet()) {
            EditorHighlightingStats.Stats.Builder builder3;
            EditorFileType fileType = (EditorFileType)builder2.getKey();
            Recorder recorder = (Recorder)builder2.getValue();
            Histogram histogram = recorder.getIntervalHistogram();
            if (histogram.getTotalCount() == 0L) continue;
            EditorHighlightingStats.Stats.Builder it = builder3 = EditorHighlightingStats.Stats.newBuilder();
            boolean bl = false;
            it.setFileType(fileType);
            Intrinsics.checkNotNull((Object)histogram);
            it.setHistogram(HistogramUtil.toProto(histogram));
            EditorHighlightingStats.Stats.Builder record = builder3;
            allStats.addByFileType(record.build());
        }
        if (allStats.getByFileTypeCount() == 0) {
            return;
        }
        AndroidStudioEvent.Builder $this$reportHighlightingStats_u24lambda_u241 = builder = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$reportHighlightingStats_u24lambda_u241.setKind(AndroidStudioEvent.EventKind.EDITOR_HIGHLIGHTING_STATS);
        $this$reportHighlightingStats_u24lambda_u241.setEditorHighlightingStats(allStats.build());
        AndroidStudioEvent.Builder builder4 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"apply(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    private final EditorFileType convertFileType(VirtualFile file) {
        String string = file.getFileType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (this.isCMakeFileByName(string)) {
            return EditorFileType.CMAKE;
        }
        return switch (file.getFileType().getName()) {
            case "JAVA" -> EditorFileType.JAVA;
            case "Kotlin" -> {
                if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"kts")) {
                    yield EditorFileType.KOTLIN_SCRIPT;
                }
                yield EditorFileType.KOTLIN;
            }
            case "XML" -> EditorFileType.XML;
            case "Groovy" -> EditorFileType.GROOVY;
            case "Properties" -> EditorFileType.PROPERTIES;
            case "JSON" -> EditorFileType.JSON;
            case "ObjectiveC" -> EditorFileType.NATIVE;
            default -> EditorFileType.UNKNOWN;
        };
    }

    private final boolean isCMakeFileByName(String $this$isCMakeFileByName) {
        return Intrinsics.areEqual((Object)$this$isCMakeFileByName, (Object)"CMakeLists.txt") || StringUtil.endsWithIgnoreCase((String)$this$isCMakeFileByName, (String)".cmake");
    }

    private static final Recorder recordHighlightingLatency$lambda$0(EditorFileType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Recorder(1);
    }

    private static final Recorder recordHighlightingLatency$lambda$1(Function1 $tmp0, Object p0) {
        return (Recorder)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final HighlightingStats getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/analytics/HighlightingStats$Companion;", "", "<init>", "()V", "MAX_LATENCY_MS", "", "getInstance", "Lcom/android/tools/analytics/HighlightingStats;", "analytics"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HighlightingStats getInstance() {
            Object object = ApplicationManager.getApplication().getService(HighlightingStats.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (HighlightingStats)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

