/*
 * Decompiled with CFR 0.152.
 */
package com.android.flags;

import com.android.flags.BooleanFlag;
import com.android.flags.CustomTypeFlag;
import com.android.flags.DebugFlag;
import com.android.flags.EnumFlag;
import com.android.flags.FlagDefault;
import com.android.flags.FlagGroup;
import com.android.flags.IntFlag;
import com.android.flags.LongFlag;
import com.android.flags.MendelFlag;
import com.android.flags.StringFlag;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 **\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002)*BU\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u001f\u001a\u00020 J\u000b\u0010!\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u0006\u0010%\u001a\u00020 R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0012\u0010\u001a\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\u001c\u001a\u00028\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010(\u0082\u0001\b+,-./012\u00a8\u00063"}, d2={"Lcom/android/flags/Flag;", "T", "", "group", "Lcom/android/flags/FlagGroup;", "name", "", "displayName", "description", "default", "Lcom/android/flags/FlagDefault;", "valueConverter", "Lcom/android/flags/Flag$ValueConverter;", "examples", "", "<init>", "(Lcom/android/flags/FlagGroup;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/flags/FlagDefault;Lcom/android/flags/Flag$ValueConverter;Ljava/util/List;)V", "getGroup", "()Lcom/android/flags/FlagGroup;", "getDisplayName", "()Ljava/lang/String;", "getDescription", "getDefault", "()Lcom/android/flags/FlagDefault;", "id", "getId", "_defaultValue", "Ljava/lang/Object;", "defaultValue", "getDefaultValue", "()Ljava/lang/Object;", "validate", "", "get", "override", "overrideValue", "(Ljava/lang/Object;)V", "clearOverride", "isUserOverridden", "", "()Z", "ValueConverter", "Companion", "Lcom/android/flags/BooleanFlag;", "Lcom/android/flags/CustomTypeFlag;", "Lcom/android/flags/DebugFlag;", "Lcom/android/flags/EnumFlag;", "Lcom/android/flags/IntFlag;", "Lcom/android/flags/LongFlag;", "Lcom/android/flags/MendelFlag;", "Lcom/android/flags/StringFlag;", "android.sdktools.flags"})
@SourceDebugExtension(value={"SMAP\nFlag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Flag.kt\ncom/android/flags/Flag\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
public abstract sealed class Flag<T>
permits BooleanFlag, CustomTypeFlag, DebugFlag, EnumFlag, IntFlag, LongFlag, MendelFlag, StringFlag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FlagGroup group;
    @NotNull
    private final String displayName;
    @NotNull
    private final String description;
    @NotNull
    private final FlagDefault<T> default;
    @NotNull
    private final ValueConverter<T> valueConverter;
    @NotNull
    private final List<T> examples;
    @NotNull
    private final String id;
    @Nullable
    private T _defaultValue;

    private Flag(FlagGroup group2, String name2, String displayName, String description2, FlagDefault<T> flagDefault, ValueConverter<T> valueConverter, List<? extends T> examples) {
        this.group = group2;
        this.displayName = displayName;
        this.description = description2;
        this.default = flagDefault;
        this.valueConverter = valueConverter;
        this.examples = examples;
        this.id = this.group.getName() + "." + name2;
        this.group.getFlags().register(this);
    }

    public /* synthetic */ Flag(FlagGroup flagGroup, String string, String string2, String string3, FlagDefault flagDefault, ValueConverter valueConverter, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(flagGroup, string, string2, string3, flagDefault, valueConverter, list2, null);
    }

    @NotNull
    public final FlagGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final FlagDefault<T> getDefault() {
        return this.default;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    private final T getDefaultValue() {
        T t = this._defaultValue;
        if (t == null) {
            Object t2;
            Object it = t2 = this.default.get();
            boolean bl = false;
            this._defaultValue = it;
            t = t2;
        }
        return t;
    }

    public final void validate() {
        this.group.validate();
        Flag.Companion.verifyRoundTrip("Default", this.getDefaultValue(), this.valueConverter);
        for (T t : this.examples) {
            Flag.Companion.verifyRoundTrip("Example", this.getDefaultValue(), this.valueConverter);
        }
        Companion.verifyFlagIdFormat(this.id);
        Companion.verifyDisplayTextFormat(this.displayName);
        Companion.verifyDisplayTextFormat(this.description);
    }

    public final T get() {
        T t;
        String string = this.group.getFlags().getValue(this);
        if (string == null) {
            return this.getDefaultValue();
        }
        String strValue = string;
        try {
            t = this.valueConverter.deserialize(strValue);
        }
        catch (Exception exception) {
            t = this.getDefaultValue();
        }
        return t;
    }

    public final void override(T overrideValue) {
        this.group.getFlags().getUserOverrides().put(this, this.valueConverter.serialize(overrideValue));
    }

    public final void clearOverride() {
        this.group.getFlags().getUserOverrides().remove(this);
    }

    public final boolean isUserOverridden() {
        return this.group.getFlags().getUserOverrides().get(this) != null;
    }

    @JvmStatic
    public static final void verifyFlagIdFormat(@NotNull String id2) {
        Companion.verifyFlagIdFormat(id2);
    }

    @JvmStatic
    public static final void verifyDisplayTextFormat(@NotNull String name2) {
        Companion.verifyDisplayTextFormat(name2);
    }

    public /* synthetic */ Flag(FlagGroup group2, String name2, String displayName, String description2, FlagDefault flagDefault, ValueConverter valueConverter, List examples, DefaultConstructorMarker $constructor_marker) {
        this(group2, name2, displayName, description2, flagDefault, valueConverter, examples);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J1\u0010\n\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u0002H\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/android/flags/Flag$Companion;", "", "<init>", "()V", "verifyFlagIdFormat", "", "id", "", "verifyDisplayTextFormat", "name", "verifyRoundTrip", "T", "descriptiveName", "value", "converter", "Lcom/android/flags/Flag$ValueConverter;", "(Ljava/lang/String;Ljava/lang/Object;Lcom/android/flags/Flag$ValueConverter;)V", "android.sdktools.flags"})
    @SourceDebugExtension(value={"SMAP\nFlag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Flag.kt\ncom/android/flags/Flag$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void verifyFlagIdFormat(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            CharSequence charSequence = id2;
            if (!new Regex("[a-z][a-z0-9]*(\\.[a-z0-9]+)*").matches(charSequence)) {
                boolean bl = false;
                String string = "Invalid id: " + id2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        @JvmStatic
        public final void verifyDisplayTextFormat(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (!(((CharSequence)name2).length() > 0 && name2.charAt(0) != ' ' && name2.charAt(name2.length() - 1) != ' ')) {
                boolean bl = false;
                String string = "Invalid name: " + name2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final <T> void verifyRoundTrip(String descriptiveName, T value2, ValueConverter<T> converter) {
            T t;
            String string;
            try {
                string = converter.serialize(value2);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(descriptiveName + " value '" + value2 + "' cannot be serialized", e);
            }
            String serialized = string;
            try {
                t = converter.deserialize(serialized);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(descriptiveName + " value '" + value2 + "' cannot be deserialized.");
            }
            T deserialized = t;
            if (!Intrinsics.areEqual(deserialized, value2)) {
                boolean bl = false;
                String string2 = descriptiveName;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                String string4 = "Deserialized value '" + deserialized + "' does not match original " + string3 + " value '" + value2 + "'.";
                throw new IllegalArgumentException(string4.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bd\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00012\u0006\u0010\b\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/android/flags/Flag$ValueConverter;", "T", "", "serialize", "", "value", "(Ljava/lang/Object;)Ljava/lang/String;", "deserialize", "strValue", "(Ljava/lang/String;)Ljava/lang/Object;", "android.sdktools.flags"})
    protected static interface ValueConverter<T> {
        @NotNull
        public String serialize(T var1);

        public T deserialize(@NotNull String var1);
    }
}

