/*
 * Decompiled with CFR 0.152.
 */
package com.android.declarative.intellij.focus.ui;

import com.android.declarative.intellij.focus.services.FocusGradleSettings;
import com.android.declarative.intellij.focus.services.ModuleInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FocusCenterPanel
extends JPanel {
    private final JBList<String> modulesList;
    private final JBCheckBox includeIncoming;
    private final DefaultListModel<String> listModel = new DefaultListModel();

    FocusCenterPanel() {
        this.setLayout(new BorderLayout());
        Border border = BorderFactory.createEmptyBorder(5, 0, 5, 0);
        JPanel marginPanel = new JPanel();
        marginPanel.setLayout(new BorderLayout());
        JLabel topLabel = new JLabel();
        topLabel.setText("Select modules to focus on");
        topLabel.setBorder(border);
        marginPanel.add((Component)topLabel, "North");
        this.modulesList = new JBList(this.listModel);
        JBScrollPane scrollPane2 = new JBScrollPane();
        scrollPane2.setViewportView((Component)this.modulesList);
        scrollPane2.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1));
        this.modulesList.setLayoutOrientation(0);
        this.modulesList.setSelectionMode(2);
        marginPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        marginPanel.add((Component)scrollPane2, "Center");
        this.add((Component)marginPanel, "Center");
        this.includeIncoming = new JBCheckBox("Include incoming references");
        this.includeIncoming.setBorder(border);
        this.add((Component)this.includeIncoming, "South");
    }

    public void fillModulesList(FocusGradleSettings settings) {
        settings.getAllModules().stream().map(ModuleInfo::getPath).forEach(this.listModel::addElement);
        this.includeIncoming.addActionListener(e -> settings.getIncludeIncomingReferences().set(this.includeIncoming.isSelected()));
    }

    public List<String> getSelectedModulesList() {
        return Arrays.stream(this.modulesList.getSelectedIndices()).mapToObj(index -> this.listModel.get(index)).collect(Collectors.toList());
    }
}

