/*
 * Decompiled with CFR 0.152.
 */
package com.android.declarative.intellij.focus.services;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0014J\u001e\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00180\u0017J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u0018*\u0004\u0018\u00010\u0001H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/android/declarative/intellij/focus/services/FocusStorage;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "allModulesName", "", "focusName", "storageFile", "Ljava/io/File;", "getStorageFile", "()Ljava/io/File;", "storageExists", "", "storeFocusData", "", "allModules", "", "focused", "getFocusData", "Lkotlin/Pair;", "", "deserializeList", "declarative-gradle.focus-plugin"})
public final class FocusStorage {
    @NotNull
    private final Project project;
    @NotNull
    private final String allModulesName;
    @NotNull
    private final String focusName;
    @NotNull
    private final File storageFile;

    public FocusStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.allModulesName = "allModules";
        this.focusName = "focus";
        Object object = ProjectUtil.guessProjectDir((Project)this.project);
        if (object == null || (object = object.getPath()) == null) {
            object = "./";
        }
        this.storageFile = new File((String)object, "focus.properties");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getStorageFile() {
        return this.storageFile;
    }

    public final boolean storageExists() {
        return this.storageFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeFocusData(@NotNull Set<String> allModules, @NotNull Set<String> focused) {
        Intrinsics.checkNotNullParameter(allModules, (String)"allModules");
        Intrinsics.checkNotNullParameter(focused, (String)"focused");
        Properties properties = new Properties();
        properties.setProperty(this.allModulesName, CollectionsKt.joinToString$default((Iterable)allModules, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        properties.setProperty(this.focusName, CollectionsKt.joinToString$default((Iterable)focused, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        Closeable closeable = new FileOutputStream(this.storageFile);
        Throwable throwable = null;
        try {
            FileOutputStream output = (FileOutputStream)closeable;
            boolean bl = false;
            properties.store(output, "");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<List<String>, List<String>> getFocusData() {
        Properties properties = new Properties();
        Closeable closeable = new FileInputStream(this.storageFile);
        Throwable throwable = null;
        try {
            FileInputStream input2 = (FileInputStream)closeable;
            boolean bl = false;
            properties.load(input2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new Pair(this.deserializeList(properties.get(this.allModulesName)), this.deserializeList(properties.get(this.focusName)));
    }

    private final List<String> deserializeList(Object $this$deserializeList) {
        String[] stringArray = new String[]{","};
        return CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)String.valueOf($this$deserializeList), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }
}

