/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.output;

import com.android.annotations.concurrency.UiThread;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.output.DownloadRequestItem;
import com.android.build.output.DownloadRequestKey;
import com.android.build.output.LongDownloadsNotifier;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000bJ\b\u0010\u001b\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\u000fH\u0007J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u001fH\u0007J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u001fH\u0007J\u0016\u0010$\u001a\u00020\u000f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/build/output/DownloadInfoDataModel;", "", "buildFinishedDisposable", "Lcom/intellij/openapi/Disposable;", "longDownloadsNotifier", "Lcom/android/build/output/LongDownloadsNotifier;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/build/output/LongDownloadsNotifier;)V", "updatesMap", "", "Lcom/android/build/output/DownloadRequestKey;", "Lcom/android/build/output/DownloadRequestItem;", "immediateUpdateScheduled", "", "downloadStarted", "", "startTimestamp", "", "url", "", "repository", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "downloadFinished", "downloadResult", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "onNewItemUpdate", "downloadRequest", "scheduleImmediateUpdateIfNecessary", "processedEvents", "subscribedModels", "", "Lcom/android/build/output/DownloadInfoDataModel$Listener;", "processUpdates", "subscribeUiModel", "modelListener", "unsubscribeUiModel", "notifyListenersOnUpdate", "updatedItems", "", "Listener", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nDownloadInfoDataModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadInfoDataModel.kt\ncom/android/build/output/DownloadInfoDataModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1#2:136\n1869#3,2:137\n*S KotlinDebug\n*F\n+ 1 DownloadInfoDataModel.kt\ncom/android/build/output/DownloadInfoDataModel\n*L\n128#1:137,2\n*E\n"})
public final class DownloadInfoDataModel {
    @Nullable
    private final LongDownloadsNotifier longDownloadsNotifier;
    @NotNull
    private final Map<DownloadRequestKey, DownloadRequestItem> updatesMap;
    private volatile boolean immediateUpdateScheduled;
    @NotNull
    private final Map<DownloadRequestKey, DownloadRequestItem> processedEvents;
    @NotNull
    private final List<Listener> subscribedModels;

    public DownloadInfoDataModel(@NotNull Disposable buildFinishedDisposable, @Nullable LongDownloadsNotifier longDownloadsNotifier) {
        Intrinsics.checkNotNullParameter((Object)buildFinishedDisposable, (String)"buildFinishedDisposable");
        this.longDownloadsNotifier = longDownloadsNotifier;
        this.updatesMap = new LinkedHashMap();
        Disposer.register((Disposable)buildFinishedDisposable, () -> DownloadInfoDataModel._init_$lambda$0(this));
        this.processedEvents = new LinkedHashMap();
        this.subscribedModels = new ArrayList();
    }

    public /* synthetic */ DownloadInfoDataModel(Disposable disposable, LongDownloadsNotifier longDownloadsNotifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            longDownloadsNotifier = null;
        }
        this(disposable, longDownloadsNotifier);
    }

    public final void downloadStarted(long startTimestamp, @NotNull String url, @NotNull DownloadsAnalyzer.Repository repository2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        DownloadRequestKey requestKey = new DownloadRequestKey(startTimestamp, url);
        DownloadRequestItem requestItem = new DownloadRequestItem(requestKey, repository2, false, 0L, 0L, null);
        this.onNewItemUpdate(requestItem);
    }

    public final void downloadFinished(@NotNull DownloadsAnalyzer.DownloadResult downloadResult) {
        Intrinsics.checkNotNullParameter((Object)downloadResult, (String)"downloadResult");
        DownloadRequestKey downloadRequestKey = new DownloadRequestKey(downloadResult.getTimestamp(), downloadResult.getUrl());
        DownloadsAnalyzer.Repository repository2 = downloadResult.getRepository();
        long l = downloadResult.getBytes();
        long l2 = downloadResult.getDuration();
        DownloadRequestItem requestItem = new DownloadRequestItem(downloadRequestKey, repository2, true, l, l2, switch (WhenMappings.$EnumSwitchMapping$0[downloadResult.getStatus().ordinal()]) {
            case 1 -> null;
            case 2 -> "Not Found";
            case 3 -> downloadResult.getFailureMessage();
            default -> throw new NoWhenBranchMatchedException();
        });
        this.onNewItemUpdate(requestItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNewItemUpdate(@NotNull DownloadRequestItem downloadRequest) {
        Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
        Map<DownloadRequestKey, DownloadRequestItem> map2 = this.updatesMap;
        synchronized (map2) {
            boolean bl = false;
            this.updatesMap.put(downloadRequest.getRequestKey(), downloadRequest);
            Unit unit = Unit.INSTANCE;
        }
        LongDownloadsNotifier longDownloadsNotifier = this.longDownloadsNotifier;
        if (longDownloadsNotifier != null) {
            longDownloadsNotifier.updateDownloadRequest(downloadRequest);
        }
        this.scheduleImmediateUpdateIfNecessary();
    }

    private final void scheduleImmediateUpdateIfNecessary() {
        if (!this.immediateUpdateScheduled) {
            this.immediateUpdateScheduled = true;
            ActionsKt.invokeLater$default(null, () -> DownloadInfoDataModel.scheduleImmediateUpdateIfNecessary$lambda$0(this), (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void processUpdates() {
        ArrayList<DownloadRequestItem> arrayList;
        Map<DownloadRequestKey, DownloadRequestItem> map2 = this.updatesMap;
        synchronized (map2) {
            ArrayList<DownloadRequestItem> arrayList2;
            boolean bl = false;
            ArrayList<DownloadRequestItem> it = arrayList2 = new ArrayList<DownloadRequestItem>(this.updatesMap.values());
            boolean bl2 = false;
            this.updatesMap.clear();
            arrayList = arrayList2;
        }
        ArrayList<DownloadRequestItem> newUpdates = arrayList;
        Iterator<DownloadRequestItem> iterator2 = newUpdates.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<DownloadRequestItem> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            DownloadRequestItem requestItem = iterator3.next();
            this.processedEvents.put(requestItem.getRequestKey(), requestItem);
        }
        this.notifyListenersOnUpdate((List<DownloadRequestItem>)newUpdates);
    }

    @UiThread
    public final void subscribeUiModel(@NotNull Listener modelListener2) {
        Intrinsics.checkNotNullParameter((Object)modelListener2, (String)"modelListener");
        this.subscribedModels.add(modelListener2);
        modelListener2.updateDownloadRequests(CollectionsKt.toList((Iterable)this.processedEvents.values()));
    }

    @UiThread
    public final void unsubscribeUiModel(@NotNull Listener modelListener2) {
        Intrinsics.checkNotNullParameter((Object)modelListener2, (String)"modelListener");
        this.subscribedModels.remove(modelListener2);
    }

    @UiThread
    public final void notifyListenersOnUpdate(@NotNull List<DownloadRequestItem> updatedItems) {
        Intrinsics.checkNotNullParameter(updatedItems, (String)"updatedItems");
        Iterable $this$forEach$iv = this.subscribedModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.updateDownloadRequests(updatedItems);
        }
    }

    private static final void _init_$lambda$0(DownloadInfoDataModel this$0) {
        ActionsKt.invokeLater$default(null, () -> DownloadInfoDataModel.lambda$0$0(this$0), (int)1, null);
    }

    private static final Unit lambda$0$0(DownloadInfoDataModel this$0) {
        this$0.processUpdates();
        return Unit.INSTANCE;
    }

    private static final Unit scheduleImmediateUpdateIfNecessary$lambda$0(DownloadInfoDataModel this$0) {
        this$0.immediateUpdateScheduled = false;
        this$0.processUpdates();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/build/output/DownloadInfoDataModel$Listener;", "", "updateDownloadRequests", "", "downloadRequests", "", "Lcom/android/build/output/DownloadRequestItem;", "intellij.android.build-attribution"})
    public static interface Listener {
        public void updateDownloadRequests(@NotNull List<DownloadRequestItem> var1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DownloadsAnalyzer.DownloadStatus.values().length];
            try {
                nArray[DownloadsAnalyzer.DownloadStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DownloadsAnalyzer.DownloadStatus.MISSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DownloadsAnalyzer.DownloadStatus.FAILURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

