/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view;

import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.data.BuildSummary;
import com.android.build.attribution.ui.data.DownloadsSummaryUIData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.model.BuildOverviewPageModel;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.WarningsDataPageModelKt;
import com.android.build.attribution.ui.view.BuildAnalyzerDataPageView;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.tools.adtui.TabularLayout;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/android/build/attribution/ui/view/BuildOverviewPageView;", "Lcom/android/build/attribution/ui/view/BuildAnalyzerDataPageView;", "model", "Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "<init>", "(Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;Lcom/android/build/attribution/ui/view/ViewActionHandlers;)V", "getModel", "()Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "getActionHandlers", "()Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "linksHandler", "Lcom/android/build/attribution/ui/HtmlLinksHandler;", "getLinksHandler", "()Lcom/android/build/attribution/ui/HtmlLinksHandler;", "buildInformationPanel", "Ljavax/swing/JPanel;", "generateInfoPanelHtml", "", "optionalDownloadsOverviewSection", "downloadsData", "Lcom/android/build/attribution/ui/data/DownloadsSummaryUIData;", "linksPanel", "garbageCollectionIssuePanel", "component", "getComponent", "()Ljavax/swing/JPanel;", "additionalControls", "getAdditionalControls", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildOverviewPageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildOverviewPageView.kt\ncom/android/build/attribution/ui/view/BuildOverviewPageView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class BuildOverviewPageView
implements BuildAnalyzerDataPageView {
    @NotNull
    private final BuildOverviewPageModel model;
    @NotNull
    private final ViewActionHandlers actionHandlers;
    @NotNull
    private final HtmlLinksHandler linksHandler;
    @NotNull
    private final JPanel buildInformationPanel;
    @NotNull
    private final JPanel linksPanel;
    @NotNull
    private final JPanel garbageCollectionIssuePanel;
    @NotNull
    private final JPanel component;
    @NotNull
    private final JPanel additionalControls;

    /*
     * WARNING - void declaration
     */
    public BuildOverviewPageView(@NotNull BuildOverviewPageModel model, @NotNull ViewActionHandlers actionHandlers) {
        void $this$additionalControls_u24lambda_u240;
        JPanel $this$component_u24lambda_u240;
        void $this$garbageCollectionIssuePanel_u24lambda_u240_u243_u240;
        JLabel jLabel;
        void $this$garbageCollectionIssuePanel_u24lambda_u240_u243;
        JPanel jPanel;
        Icon icon;
        JPanel $this$garbageCollectionIssuePanel_u24lambda_u240;
        void $this$linksPanel_u24lambda_u240_u243;
        Object $this$linksPanel_u24lambda_u240_u242;
        Object $this$linksPanel_u24lambda_u240_u241;
        Object $this$linksPanel_u24lambda_u240_u240;
        JPanel $this$linksPanel_u24lambda_u240;
        JPanel $this$buildInformationPanel_u24lambda_u240;
        JPanel jPanel2;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        this.model = model;
        this.actionHandlers = actionHandlers;
        this.linksHandler = new HtmlLinksHandler(this.actionHandlers);
        JPanel jPanel3 = jPanel2 = new JPanel();
        BuildOverviewPageView buildOverviewPageView = this;
        boolean bl = false;
        $this$buildInformationPanel_u24lambda_u240.setName("info");
        $this$buildInformationPanel_u24lambda_u240.setLayout((LayoutManager)new VerticalLayout(0, 2));
        Object infoPanelHtml = this.generateInfoPanelHtml();
        $this$buildInformationPanel_u24lambda_u240.add(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines((String)infoPanelHtml, this.linksHandler));
        buildOverviewPageView.buildInformationPanel = jPanel2;
        $this$buildInformationPanel_u24lambda_u240 = jPanel2 = new JPanel();
        buildOverviewPageView = this;
        boolean bl2 = false;
        $this$linksPanel_u24lambda_u240.setName("links");
        $this$linksPanel_u24lambda_u240.setLayout((LayoutManager)new VerticalLayout(10, 2));
        Object object = infoPanelHtml = BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines$default("<b>Common views into this build</b>", null, 2, null);
        StringBuilder stringBuilder = $this$linksPanel_u24lambda_u240;
        boolean bl3 = false;
        ((JComponent)$this$linksPanel_u24lambda_u240_u240).setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        ((Container)((Object)stringBuilder)).add((Component)infoPanelHtml);
        $this$linksPanel_u24lambda_u240_u240 = infoPanelHtml = new HyperlinkLabel("Tasks impacting build duration");
        stringBuilder = $this$linksPanel_u24lambda_u240;
        boolean bl4 = false;
        $this$linksPanel_u24lambda_u240_u241.addHyperlinkListener(arg_0 -> BuildOverviewPageView.linksPanel$lambda$0$1$0(this, arg_0));
        ((Container)((Object)stringBuilder)).add((Component)infoPanelHtml);
        $this$linksPanel_u24lambda_u240_u241 = infoPanelHtml = new HyperlinkLabel("Plugins with tasks impacting build duration");
        stringBuilder = $this$linksPanel_u24lambda_u240;
        boolean bl5 = false;
        $this$linksPanel_u24lambda_u240_u242.addHyperlinkListener(arg_0 -> BuildOverviewPageView.linksPanel$lambda$0$2$0(this, arg_0));
        ((Container)((Object)stringBuilder)).add((Component)infoPanelHtml);
        $this$linksPanel_u24lambda_u240_u242 = infoPanelHtml = new HyperlinkLabel("All warnings");
        stringBuilder = $this$linksPanel_u24lambda_u240;
        boolean bl6 = false;
        $this$linksPanel_u24lambda_u240_u243.addHyperlinkListener(arg_0 -> BuildOverviewPageView.linksPanel$lambda$0$3$0(this, arg_0));
        ((Container)((Object)stringBuilder)).add((Component)infoPanelHtml);
        buildOverviewPageView.linksPanel = jPanel2;
        $this$linksPanel_u24lambda_u240 = jPanel2 = new JPanel();
        buildOverviewPageView = this;
        boolean bl7 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u240.setName("memory");
        $this$garbageCollectionIssuePanel_u24lambda_u240.setLayout((LayoutManager)new VerticalLayout(5));
        Object gcTime = this.model.getReportUiData().getBuildSummary().getGarbageCollectionTime();
        String panelHeader = "<b>Gradle Daemon Memory Utilization</b>";
        StringBuilder $this$garbageCollectionIssuePanel_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl8 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u240_u240.append(BuildAttributionUIUtilKt.percentageStringHtml((TimeWithPercentage)gcTime) + " (" + BuildAttributionUIUtilKt.durationStringHtml((TimeWithPercentage)gcTime) + ") of your build\u2019s time was dedicated to garbage collection during this build.<br/>");
        if (this.model.getShouldWarnAboutGC()) {
            $this$garbageCollectionIssuePanel_u24lambda_u240_u240.append("To reduce the amount of time spent on garbage collection, please consider increasing the Gradle daemon heap size.<br/>");
        }
        $this$garbageCollectionIssuePanel_u24lambda_u240_u240.append("You can change the Gradle daemon heap size on the memory settings page.");
        String descriptionText = stringBuilder.toString();
        AbstractAction action2 = new AbstractAction(this){
            final /* synthetic */ BuildOverviewPageView this$0;
            {
                this.this$0 = $receiver;
                super("Edit memory settings");
            }

            public void actionPerformed(ActionEvent e) {
                this.this$0.getActionHandlers().openMemorySettings();
            }
        };
        JPanel $this$garbageCollectionIssuePanel_u24lambda_u240_u241 = bl8 = new JPanel();
        boolean bl9 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u240_u241.setLayout((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        $this$garbageCollectionIssuePanel_u24lambda_u240_u241.add((Component)new JButton(action2), "LEFT");
        JPanel controlsPanel = bl8;
        if (this.model.getShouldWarnAboutGC()) {
            icon = BuildAttributionUIUtilKt.warningIcon();
        } else {
            Icon icon2 = AllIcons.General.Information;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Information");
        }
        Icon icon3 = icon;
        JEditorPane defaultGCUsageWarning = BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines("", this.linksHandler);
        String fineTuneYourJvmLink = this.linksHandler.externalLink("Fine tune your JVM", BuildAnalyzerBrowserLinks.CONFIGURE_GC);
        String dontShowThisAgainLink = this.linksHandler.actionLink("Don't show this again", "suppress", () -> BuildOverviewPageView.garbageCollectionIssuePanel$lambda$0$2(this, defaultGCUsageWarning));
        String htmlContent = StringsKt.trimMargin$default((String)("\n      |The default garbage collector was used in this build running with JDK " + this.model.getReportUiData().getBuildSummary().getJavaVersionUsed() + ".<br/>\n      |Note that the default GC was changed starting with JDK 9. This could impact your build performance by as much as 10%.<br/>\n      |<b>Recommendation:</b> " + fineTuneYourJvmLink + ".<br/>\n      |" + dontShowThisAgainLink + ".\n    "), null, (int)1, null);
        SwingHelper.setHtml((JEditorPane)defaultGCUsageWarning, (String)htmlContent, null);
        defaultGCUsageWarning.setName("no-gc-setting-warning");
        $this$garbageCollectionIssuePanel_u24lambda_u240.add(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines$default(panelHeader, null, 2, null));
        JPanel jPanel4 = jPanel = new JPanel();
        void var18_25 = $this$garbageCollectionIssuePanel_u24lambda_u240;
        boolean bl10 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u240_u243.setLayout(new BorderLayout(5, 5));
        JLabel jLabel2 = jLabel = new JLabel(icon3);
        void var22_29 = $this$garbageCollectionIssuePanel_u24lambda_u240_u243;
        boolean bl11 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u240_u243_u240.setVerticalAlignment(1);
        var22_29.add((Component)jLabel, "West");
        $this$garbageCollectionIssuePanel_u24lambda_u240_u243.add((Component)BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines$default(descriptionText, null, 2, null), "Center");
        var18_25.add(jPanel);
        $this$garbageCollectionIssuePanel_u24lambda_u240.add(controlsPanel);
        if (this.model.getShouldWarnAboutNoGCSetting()) {
            $this$garbageCollectionIssuePanel_u24lambda_u240.add(defaultGCUsageWarning);
        }
        buildOverviewPageView.garbageCollectionIssuePanel = jPanel2;
        $this$garbageCollectionIssuePanel_u24lambda_u240 = jPanel2 = new JPanel();
        buildOverviewPageView = this;
        boolean bl12 = false;
        $this$component_u24lambda_u240.setName("build-overview");
        $this$component_u24lambda_u240.setLayout(new BorderLayout());
        Object $this$component_u24lambda_u240_u240 = gcTime = new JPanel();
        boolean bl13 = false;
        ((JComponent)$this$component_u24lambda_u240_u240).setBorder(JBUI.Borders.empty((int)20));
        ((Container)$this$component_u24lambda_u240_u240).setLayout((LayoutManager)new TabularLayout("Fit,50px,Fit,50px,Fit"));
        ((Container)$this$component_u24lambda_u240_u240).add((Component)this.buildInformationPanel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        ((Container)$this$component_u24lambda_u240_u240).add((Component)this.linksPanel, new TabularLayout.Constraint(0, 2, 0, 4, null));
        ((Container)$this$component_u24lambda_u240_u240).add((Component)this.garbageCollectionIssuePanel, new TabularLayout.Constraint(0, 4, 0, 4, null));
        Object content2 = gcTime;
        Object $this$component_u24lambda_u240_u241 = object = new JBScrollPane();
        boolean bl14 = false;
        $this$component_u24lambda_u240_u241.setBorder((Border)JBUI.Borders.empty());
        $this$component_u24lambda_u240_u241.setViewportView((Component)content2);
        Object scrollPane2 = object;
        $this$component_u24lambda_u240.add((Component)scrollPane2, "Center");
        buildOverviewPageView.component = jPanel2;
        $this$component_u24lambda_u240 = jPanel2 = new JPanel();
        buildOverviewPageView = this;
        boolean bl15 = false;
        $this$additionalControls_u24lambda_u240.setName("build-overview-additional-controls");
        buildOverviewPageView.additionalControls = jPanel2;
    }

    @NotNull
    public final BuildOverviewPageModel getModel() {
        return this.model;
    }

    @NotNull
    public final ViewActionHandlers getActionHandlers() {
        return this.actionHandlers;
    }

    @NotNull
    public final HtmlLinksHandler getLinksHandler() {
        return this.linksHandler;
    }

    @NotNull
    public final String generateInfoPanelHtml() {
        Object object;
        BuildSummary buildSummary = this.model.getReportUiData().getBuildSummary();
        String string = DateFormatUtil.formatDateTime((long)buildSummary.getBuildFinishedTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String buildFinishedTime = string;
        if (WarningsDataPageModelKt.shouldShowWarning(this.model.getReportUiData().getConfCachingData())) {
            String it = this.linksHandler.actionLink("Optimize this", "configuration-cache", () -> BuildOverviewPageView.generateInfoPanelHtml$lambda$0(this));
            boolean bl = false;
            object = " - " + it;
        } else {
            object = "";
        }
        String optionalConfigurationCacheLink = object;
        return ((Object)StringsKt.trim((CharSequence)("\n<b>Build finished on " + buildFinishedTime + "</b><br/>\nTotal build duration was " + BuildAttributionUIUtilKt.durationStringHtml(buildSummary.getTotalBuildDuration()) + "<br/>\n<br/>\nIncludes:<br/>\nBuild configuration: " + BuildAttributionUIUtilKt.durationStringHtml(buildSummary.getConfigurationDuration()) + optionalConfigurationCacheLink + "<br/>\nCritical path tasks execution: " + BuildAttributionUIUtilKt.durationStringHtml(buildSummary.getCriticalPathDuration()) + "<br/>\n" + this.optionalDownloadsOverviewSection(this.model.getDownloadsSummaryUiData()) + "\n    "))).toString();
    }

    private final String optionalDownloadsOverviewSection(DownloadsSummaryUIData downloadsData) {
        if (downloadsData == null || downloadsData.isEmpty()) {
            return "";
        }
        String string = StringUtil.escapeXmlEntities((String)((Object)StringsKt.trim((CharSequence)("\n<html>\nThis build had " + downloadsData.getSumOfRequests() + " network " + StringUtil.pluralize((String)"request", (int)downloadsData.getSumOfRequests()) + ",<br/>\ndownloaded in total " + Formats.formatFileSize((long)downloadsData.getSumOfDataBytes()) + " in " + BuildAttributionUIUtilKt.durationStringHtml(downloadsData.getSumOfTimeMs()) + ".\n</html>\n    "))).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        String tooltipDetails = string;
        String filesDownloadLink = this.linksHandler.actionLink("Files download", "downloads-view", () -> BuildOverviewPageView.optionalDownloadsOverviewSection$lambda$0(this));
        return filesDownloadLink + ": " + BuildAttributionUIUtilKt.durationStringHtml(downloadsData.getSumOfTimeMs()) + " " + BuildAttributionUIUtilKt.helpIcon(tooltipDetails) + "<br/>";
    }

    @Override
    @NotNull
    public JPanel getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public JPanel getAdditionalControls() {
        return this.additionalControls;
    }

    private static final void generateInfoPanelHtml$lambda$0(BuildOverviewPageView this$0) {
        this$0.actionHandlers.openConfigurationCacheWarnings();
    }

    private static final void optionalDownloadsOverviewSection$lambda$0(BuildOverviewPageView this$0) {
        this$0.actionHandlers.changeViewToDownloadsLinkClicked();
    }

    private static final void linksPanel$lambda$0$1$0(BuildOverviewPageView this$0, HyperlinkEvent it) {
        this$0.actionHandlers.changeViewToTasksLinkClicked(null);
    }

    private static final void linksPanel$lambda$0$2$0(BuildOverviewPageView this$0, HyperlinkEvent it) {
        this$0.actionHandlers.changeViewToTasksLinkClicked(TasksDataPageModel.Grouping.BY_PLUGIN);
    }

    private static final void linksPanel$lambda$0$3$0(BuildOverviewPageView this$0, HyperlinkEvent it) {
        this$0.actionHandlers.changeViewToWarningsLinkClicked();
    }

    private static final void garbageCollectionIssuePanel$lambda$0$2(BuildOverviewPageView this$0, JEditorPane $defaultGCUsageWarning) {
        int confirmationResult = Messages.showOkCancelDialog((String)"Click OK to hide this warning in future builds.", (String)"Confirm Warning Suppression", (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getInformationIcon());
        if (confirmationResult == 0) {
            this$0.actionHandlers.dontShowAgainNoGCSettingWarningClicked();
            $defaultGCUsageWarning.setVisible(false);
        }
    }
}

