/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.model.WarningsDataPageModel;
import com.android.build.attribution.ui.model.WarningsDataPageModelKt;
import com.android.build.attribution.ui.model.WarningsFilter;
import com.android.build.attribution.ui.model.WarningsPageId;
import com.android.build.attribution.ui.model.WarningsTreeNode;
import com.android.build.attribution.ui.model.WarningsTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.model.WarningsTreeStructure;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u00104\u001a\u00020\r2\b\u00105\u001a\u0004\u0018\u000100H\u0016J\u0010\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020+H\u0016J$\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bH\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020+H\u0016J\b\u0010?\u001a\u00020\rH\u0002J\b\u0010@\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0006\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020+@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b-\u0010.R\u0016\u0010/\u001a\u0004\u0018\u0001008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010!\u00a8\u0006A"}, d2={"Lcom/android/build/attribution/ui/model/WarningsDataPageModelImpl;", "Lcom/android/build/attribution/ui/model/WarningsDataPageModel;", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "<init>", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;)V", "modelUpdatedListeners", "", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "treeStructureChanged", "", "listenersCount", "", "getListenersCount$annotations", "()V", "getListenersCount", "()I", "treeHeaderText", "", "getTreeHeaderText", "()Ljava/lang/String;", "value", "Lcom/android/build/attribution/ui/model/WarningsFilter;", "filter", "getFilter", "()Lcom/android/build/attribution/ui/model/WarningsFilter;", "setFilter", "(Lcom/android/build/attribution/ui/model/WarningsFilter;)V", "groupByPlugin", "getGroupByPlugin", "()Z", "setGroupByPlugin", "(Z)V", "treeStructure", "Lcom/android/build/attribution/ui/model/WarningsTreeStructure;", "treeRoot", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getTreeRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "modelChanged", "Lcom/android/build/attribution/ui/model/WarningsPageId;", "selectedPageId", "setSelectedPageId", "(Lcom/android/build/attribution/ui/model/WarningsPageId;)V", "selectedNode", "Lcom/android/build/attribution/ui/model/WarningsTreeNode;", "getSelectedNode", "()Lcom/android/build/attribution/ui/model/WarningsTreeNode;", "isEmpty", "selectNode", "warningsTreeNode", "selectPageById", "warningsPageId", "addModelUpdatedListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "getNodeDescriptorById", "Lcom/android/build/attribution/ui/model/WarningsTreePresentableNodeDescriptor;", "pageId", "dropSelectionIfMissing", "notifyModelChanges", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nWarningsDataPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WarningsDataPageModel.kt\ncom/android/build/attribution/ui/model/WarningsDataPageModelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,597:1\n1#2:598\n1869#3,2:599\n*S KotlinDebug\n*F\n+ 1 WarningsDataPageModel.kt\ncom/android/build/attribution/ui/model/WarningsDataPageModelImpl\n*L\n181#1:599,2\n*E\n"})
public final class WarningsDataPageModelImpl
implements WarningsDataPageModel {
    @NotNull
    private final BuildAttributionReportUiData reportData;
    @NotNull
    private final List<Function1<Boolean, Unit>> modelUpdatedListeners;
    @NotNull
    private WarningsFilter filter;
    private boolean groupByPlugin;
    @NotNull
    private final WarningsTreeStructure treeStructure;
    private boolean modelChanged;
    private boolean treeStructureChanged;
    @NotNull
    private WarningsPageId selectedPageId;

    /*
     * WARNING - void declaration
     */
    public WarningsDataPageModelImpl(@NotNull BuildAttributionReportUiData reportData) {
        void $this$treeStructure_u24lambda_u240;
        WarningsTreeStructure warningsTreeStructure;
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        this.reportData = reportData;
        this.modelUpdatedListeners = new CopyOnWriteArrayList();
        this.filter = WarningsFilter.Companion.getDEFAULT();
        WarningsTreeStructure warningsTreeStructure2 = warningsTreeStructure = new WarningsTreeStructure(this.reportData);
        WarningsDataPageModelImpl warningsDataPageModelImpl = this;
        boolean bl = false;
        $this$treeStructure_u24lambda_u240.updateStructure(this.getGroupByPlugin(), this.getFilter());
        warningsDataPageModelImpl.treeStructure = warningsTreeStructure;
        this.selectedPageId = this.reportData.getJetifierData().getCheckJetifierBuild() ? WarningsPageId.Companion.getJetifierUsageWarningRoot() : WarningsPageId.Companion.getEmptySelection();
    }

    public final int getListenersCount() {
        return this.modelUpdatedListeners.size();
    }

    @VisibleForTesting
    public static /* synthetic */ void getListenersCount$annotations() {
    }

    @Override
    @NotNull
    public String getTreeHeaderText() {
        WarningsTreeStructure.TreeStats treeStats = this.treeStructure.getTreeStats();
        boolean bl = false;
        return "Warnings - Total: " + treeStats.getTotalWarningsCount() + ", Filtered: " + treeStats.getFilteredWarningsCount();
    }

    @Override
    @NotNull
    public WarningsFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(@NotNull WarningsFilter value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.filter = value2;
        this.treeStructure.updateStructure(this.getGroupByPlugin(), value2);
        this.dropSelectionIfMissing();
        this.treeStructureChanged = true;
        this.modelChanged = true;
        this.notifyModelChanges();
    }

    @Override
    public boolean getGroupByPlugin() {
        return this.groupByPlugin;
    }

    @Override
    public void setGroupByPlugin(boolean value2) {
        this.groupByPlugin = value2;
        this.treeStructure.updateStructure(value2, this.getFilter());
        this.dropSelectionIfMissing();
        this.treeStructureChanged = true;
        this.modelChanged = true;
        this.notifyModelChanges();
    }

    @Override
    @NotNull
    public DefaultMutableTreeNode getTreeRoot() {
        return this.treeStructure.getTreeRoot();
    }

    private final void setSelectedPageId(WarningsPageId value2) {
        if (!Intrinsics.areEqual((Object)value2, (Object)this.selectedPageId)) {
            this.selectedPageId = value2;
            this.modelChanged = true;
        }
    }

    @Override
    @Nullable
    public WarningsTreeNode getSelectedNode() {
        return this.treeStructure.getPageIdToNode().get(this.selectedPageId);
    }

    @Override
    public boolean isEmpty() {
        return WarningsDataPageModelKt.countTotalWarnings(this.reportData) == 0;
    }

    @Override
    public void selectNode(@Nullable WarningsTreeNode warningsTreeNode) {
        Object object = warningsTreeNode;
        if (object == null || (object = ((WarningsTreeNode)object).getDescriptor()) == null || (object = ((WarningsTreePresentableNodeDescriptor)object).getPageId()) == null) {
            object = WarningsPageId.Companion.getEmptySelection();
        }
        this.setSelectedPageId((WarningsPageId)object);
        this.notifyModelChanges();
    }

    @Override
    public void selectPageById(@NotNull WarningsPageId warningsPageId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)warningsPageId, (String)"warningsPageId");
            WarningsTreeNode warningsTreeNode = this.treeStructure.getPageIdToNode().get(warningsPageId);
            if (warningsTreeNode == null) break block0;
            WarningsTreeNode it = warningsTreeNode;
            boolean bl = false;
            this.selectNode(it);
        }
    }

    @Override
    public void addModelUpdatedListener(@NotNull Disposable disposable, @NotNull Function1<? super Boolean, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.modelUpdatedListeners.add(listener2);
        Disposer.register((Disposable)disposable, () -> WarningsDataPageModelImpl.addModelUpdatedListener$lambda$0(this, listener2));
    }

    @Override
    @Nullable
    public WarningsTreePresentableNodeDescriptor getNodeDescriptorById(@NotNull WarningsPageId pageId) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        WarningsTreeNode warningsTreeNode = this.treeStructure.getPageIdToNode().get(pageId);
        return warningsTreeNode != null ? warningsTreeNode.getDescriptor() : null;
    }

    private final void dropSelectionIfMissing() {
        if (!this.treeStructure.getPageIdToNode().containsKey(this.selectedPageId)) {
            this.setSelectedPageId(WarningsPageId.Companion.getEmptySelection());
        }
    }

    private final void notifyModelChanges() {
        if (this.modelChanged) {
            Iterable $this$forEach$iv = this.modelUpdatedListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)this.treeStructureChanged);
            }
            this.modelChanged = false;
            this.treeStructureChanged = false;
        }
    }

    private static final void addModelUpdatedListener$lambda$0(WarningsDataPageModelImpl this$0, Function1 $listener) {
        this$0.modelUpdatedListeners.remove($listener);
    }
}

