/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.model.BuildAnalyzerFiltersKt;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/android/build/attribution/ui/model/TasksFilter;", "", "showTaskSourceTypes", "", "Lcom/android/build/attribution/ui/data/PluginSourceType;", "showTasksWithoutWarnings", "", "<init>", "(Ljava/util/Set;Z)V", "getShowTaskSourceTypes", "()Ljava/util/Set;", "getShowTasksWithoutWarnings", "()Z", "acceptTask", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "currentGrouping", "Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "toUiText", "", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nbuildAnalyzerFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildAnalyzerFilters.kt\ncom/android/build/attribution/ui/model/TasksFilter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,419:1\n3829#2:420\n4344#2,2:421\n*S KotlinDebug\n*F\n+ 1 buildAnalyzerFilters.kt\ncom/android/build/attribution/ui/model/TasksFilter\n*L\n233#1:420\n233#1:421,2\n*E\n"})
public final class TasksFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<PluginSourceType> showTaskSourceTypes;
    private final boolean showTasksWithoutWarnings;
    @NotNull
    private static final TasksFilter DEFAULT;

    public TasksFilter(@NotNull Set<? extends PluginSourceType> showTaskSourceTypes, boolean showTasksWithoutWarnings) {
        Intrinsics.checkNotNullParameter(showTaskSourceTypes, (String)"showTaskSourceTypes");
        this.showTaskSourceTypes = showTaskSourceTypes;
        this.showTasksWithoutWarnings = showTasksWithoutWarnings;
    }

    @NotNull
    public final Set<PluginSourceType> getShowTaskSourceTypes() {
        return this.showTaskSourceTypes;
    }

    public final boolean getShowTasksWithoutWarnings() {
        return this.showTasksWithoutWarnings;
    }

    public final boolean acceptTask(@NotNull TaskUiData taskData, @NotNull TasksDataPageModel.Grouping currentGrouping) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Intrinsics.checkNotNullParameter((Object)((Object)currentGrouping), (String)"currentGrouping");
        return (this.showTasksWithoutWarnings || taskData.getHasWarning() || currentGrouping == TasksDataPageModel.Grouping.BY_TASK_CATEGORY && !((Collection)taskData.getRelatedTaskCategoryIssues()).isEmpty()) && this.showTaskSourceTypes.contains((Object)taskData.getSourceType());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toUiText() {
        String string;
        if (this.showTaskSourceTypes.isEmpty()) {
            return "No task types selected";
        }
        if (this.showTaskSourceTypes.containsAll(ArraysKt.asList((Object[])PluginSourceType.values()))) {
            string = "All tasks";
        } else {
            void $this$filterTo$iv$iv;
            PluginSourceType[] $this$filter$iv = PluginSourceType.values();
            boolean $i$f$filter = false;
            PluginSourceType[] pluginSourceTypeArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!this.showTaskSourceTypes.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, (CharSequence)" tasks", (int)0, null, TasksFilter::toUiText$lambda$1, (int)26, null);
        }
        String taskTypesPart = string;
        return this.showTasksWithoutWarnings ? taskTypesPart : taskTypesPart + " with warnings";
    }

    @NotNull
    public final Set<PluginSourceType> component1() {
        return this.showTaskSourceTypes;
    }

    public final boolean component2() {
        return this.showTasksWithoutWarnings;
    }

    @NotNull
    public final TasksFilter copy(@NotNull Set<? extends PluginSourceType> showTaskSourceTypes, boolean showTasksWithoutWarnings) {
        Intrinsics.checkNotNullParameter(showTaskSourceTypes, (String)"showTaskSourceTypes");
        return new TasksFilter(showTaskSourceTypes, showTasksWithoutWarnings);
    }

    public static /* synthetic */ TasksFilter copy$default(TasksFilter tasksFilter, Set set2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set2 = tasksFilter.showTaskSourceTypes;
        }
        if ((n & 2) != 0) {
            bl = tasksFilter.showTasksWithoutWarnings;
        }
        return tasksFilter.copy(set2, bl);
    }

    @NotNull
    public String toString() {
        return "TasksFilter(showTaskSourceTypes=" + this.showTaskSourceTypes + ", showTasksWithoutWarnings=" + this.showTasksWithoutWarnings + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.showTaskSourceTypes).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.showTasksWithoutWarnings);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TasksFilter)) {
            return false;
        }
        TasksFilter tasksFilter = (TasksFilter)other;
        if (!Intrinsics.areEqual(this.showTaskSourceTypes, tasksFilter.showTaskSourceTypes)) {
            return false;
        }
        return this.showTasksWithoutWarnings == tasksFilter.showTasksWithoutWarnings;
    }

    private static final CharSequence toUiText$lambda$1(PluginSourceType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return BuildAnalyzerFiltersKt.access$toFilterUiShortName(it);
    }

    static {
        PluginSourceType[] pluginSourceTypeArray = new PluginSourceType[]{PluginSourceType.ANDROID_PLUGIN, PluginSourceType.THIRD_PARTY, PluginSourceType.BUILD_SCRIPT};
        DEFAULT = new TasksFilter(SetsKt.setOf((Object[])pluginSourceTypeArray), true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/attribution/ui/model/TasksFilter$Companion;", "", "<init>", "()V", "DEFAULT", "Lcom/android/build/attribution/ui/model/TasksFilter;", "getDEFAULT", "()Lcom/android/build/attribution/ui/model/TasksFilter;", "intellij.android.build-attribution"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TasksFilter getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

