/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.builder.TaskIssueUiDataContainer;
import com.android.build.attribution.ui.model.WarningsDataPageModelKt;
import com.android.build.attribution.ui.model.WarningsPageId;
import com.android.build.attribution.ui.model.WarningsTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.view.BuildAnalyzerTreeNodePresentation;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/android/build/attribution/ui/model/TaskWarningDetailsNodeDescriptor;", "Lcom/android/build/attribution/ui/model/WarningsTreePresentableNodeDescriptor;", "issueData", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "<init>", "(Lcom/android/build/attribution/ui/data/TaskIssueUiData;)V", "getIssueData", "()Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "pageId", "Lcom/android/build/attribution/ui/model/WarningsPageId;", "getPageId", "()Lcom/android/build/attribution/ui/model/WarningsPageId;", "analyticsPageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getAnalyticsPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "presentation", "Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "getPresentation", "()Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "executionTimeMs", "", "getExecutionTimeMs", "()Ljava/lang/Long;", "intellij.android.build-attribution"})
public final class TaskWarningDetailsNodeDescriptor
extends WarningsTreePresentableNodeDescriptor {
    @NotNull
    private final TaskIssueUiData issueData;
    @NotNull
    private final WarningsPageId pageId;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType analyticsPageType;
    private final long executionTimeMs;

    public TaskWarningDetailsNodeDescriptor(@NotNull TaskIssueUiData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        super(null);
        this.issueData = issueData;
        this.pageId = WarningsPageId.Companion.warning(this.issueData);
        TaskIssueUiData taskIssueUiData = this.issueData;
        this.analyticsPageType = taskIssueUiData instanceof TaskIssueUiDataContainer.TaskSetupIssue ? BuildAttributionUiEvent.Page.PageType.TASK_SETUP_ISSUE_PAGE : (taskIssueUiData instanceof TaskIssueUiDataContainer.AlwaysRunNoOutputIssue ? BuildAttributionUiEvent.Page.PageType.ALWAYS_RUN_NO_OUTPUTS_PAGE : (taskIssueUiData instanceof TaskIssueUiDataContainer.AlwaysRunUpToDateOverride ? BuildAttributionUiEvent.Page.PageType.ALWAYS_RUN_UP_TO_DATE_OVERRIDE_PAGE : BuildAttributionUiEvent.Page.PageType.UNKNOWN_PAGE));
        this.executionTimeMs = this.issueData.getTask().getExecutionTime().getTimeMs();
    }

    @NotNull
    public final TaskIssueUiData getIssueData() {
        return this.issueData;
    }

    @Override
    @NotNull
    public WarningsPageId getPageId() {
        return this.pageId;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getAnalyticsPageType() {
        return this.analyticsPageType;
    }

    @Override
    @NotNull
    public BuildAnalyzerTreeNodePresentation getPresentation() {
        String string = this.issueData.getTask().getTaskPath();
        BuildAnalyzerTreeNodePresentation.NodeIconState nodeIconState = BuildAnalyzerTreeNodePresentation.NodeIconState.WARNING_ICON;
        String string2 = WarningsDataPageModelKt.access$rightAlignedNodeDurationTextFromMs(this.getExecutionTimeMs());
        return new BuildAnalyzerTreeNodePresentation(string, null, string2, nodeIconState, 2, null);
    }

    @Override
    @NotNull
    public Long getExecutionTimeMs() {
        return this.executionTimeMs;
    }
}

