/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.analyzers.DownloadsAnalyzerKt;
import com.android.build.attribution.ui.model.RepositoriesTableModel;
import com.android.build.attribution.ui.model.RequestsListTableModel;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016J\u0006\u0010\u0017\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/android/build/attribution/ui/model/DownloadsInfoPageModel;", "", "downloadsData", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "<init>", "(Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;)V", "value", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult;", "repositoriesTableModel", "getRepositoriesTableModel", "()Lcom/intellij/util/ui/ListTableModel;", "repositoriesTableEmptyText", "", "getRepositoriesTableEmptyText", "()Ljava/lang/String;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "requestsListModel", "getRequestsListModel", "selectedRepositoriesUpdated", "", "repositories", "", "recreateTableModels", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nDownloadsInfoPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsInfoPageModel.kt\ncom/android/build/attribution/ui/model/DownloadsInfoPageModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1374#2:168\n1460#2,5:169\n*S KotlinDebug\n*F\n+ 1 DownloadsInfoPageModel.kt\ncom/android/build/attribution/ui/model/DownloadsInfoPageModel\n*L\n50#1:168\n50#1:169,5\n*E\n"})
public final class DownloadsInfoPageModel {
    @NotNull
    private final DownloadsAnalyzer.Result downloadsData;
    @NotNull
    private ListTableModel<DownloadsAnalyzer.RepositoryResult> repositoriesTableModel;
    @NotNull
    private ListTableModel<DownloadsAnalyzer.DownloadResult> requestsListModel;

    public DownloadsInfoPageModel(@NotNull DownloadsAnalyzer.Result downloadsData) {
        Intrinsics.checkNotNullParameter((Object)downloadsData, (String)"downloadsData");
        this.downloadsData = downloadsData;
        this.repositoriesTableModel = new RepositoriesTableModel(this.downloadsData);
        this.requestsListModel = new RequestsListTableModel();
    }

    @NotNull
    public final ListTableModel<DownloadsAnalyzer.RepositoryResult> getRepositoriesTableModel() {
        return this.repositoriesTableModel;
    }

    @NotNull
    public final String getRepositoriesTableEmptyText() {
        Object object;
        DownloadsAnalyzer.Result result2 = this.downloadsData;
        if (result2 instanceof DownloadsAnalyzer.GradleDoesNotProvideEvents) {
            object = "Minimal Gradle version providing downloads data is " + DownloadsAnalyzerKt.getMinGradleVersionProvidingDownloadEvents().getVersion() + ".";
        } else if (result2 instanceof DownloadsAnalyzer.ActiveResult) {
            object = "There was no attempt to download files during this build.";
        } else {
            if (result2 instanceof DownloadsAnalyzer.AnalyzerIsDisabled) {
                throw new IllegalStateException("UI Should not be available for this state.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final ListTableModel<DownloadsAnalyzer.DownloadResult> getRequestsListModel() {
        return this.requestsListModel;
    }

    /*
     * WARNING - void declaration
     */
    public final void selectedRepositoriesUpdated(@NotNull List<DownloadsAnalyzer.RepositoryResult> repositories) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Iterable iterable = repositories;
        ListTableModel<DownloadsAnalyzer.DownloadResult> listTableModel = this.requestsListModel;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DownloadsAnalyzer.RepositoryResult it = (DownloadsAnalyzer.RepositoryResult)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getDownloads();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        listTableModel.setItems((List)destination$iv$iv);
    }

    public final void recreateTableModels() {
        this.repositoriesTableModel = new RepositoriesTableModel(this.downloadsData);
        this.requestsListModel = new RequestsListTableModel();
    }
}

