/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.analytics;

import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskIssueType;
import com.android.build.attribution.ui.model.BuildAnalyzerViewModel;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksFilter;
import com.android.build.attribution.ui.model.TasksTreeNode;
import com.android.build.attribution.ui.model.WarningsFilter;
import com.android.build.attribution.ui.model.WarningsTreeNode;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Dimension;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002NOB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\rJ&\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010&\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020\u0017J\u0016\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u0017J\u0006\u0010-\u001a\u00020\u0017J\u0006\u0010.\u001a\u00020\u0017J\u0006\u0010/\u001a\u00020\u0017J\u0006\u00100\u001a\u00020\u0017J\u000e\u00101\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$J\u000e\u00102\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$J\u0006\u00103\u001a\u00020\u0017J\u000e\u00104\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$J\u000e\u00105\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$J\u0016\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u0002082\u0006\u0010#\u001a\u00020$J\u0016\u00109\u001a\u00020\u00172\u0006\u00107\u001a\u00020:2\u0006\u0010#\u001a\u00020$J\u0006\u0010;\u001a\u00020\u0017J\b\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0012H\u0002J\u0010\u0010@\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0012H\u0002J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020=H\u0002J\u000e\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020\u00172\u0006\u0010G\u001a\u00020\u000fJ\u000e\u0010H\u001a\u00020\n2\u0006\u0010D\u001a\u00020EJ\u0006\u0010I\u001a\u00020\u0017J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020L0K2\u0006\u00107\u001a\u000208H\u0002J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020L0K2\u0006\u00107\u001a\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "", "project", "Lcom/intellij/openapi/project/Project;", "uiSizeProvider", "Lkotlin/Function0;", "Ljava/awt/Dimension;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "unknownPage", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page;", "currentPage", "tabOpenEventSource", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics$TabOpenEventSource;", "buildAttributionReportSessionId", "", "pagesVisited", "", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics$AnalyticsPageId;", "pagesCountByType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "", "sendSessionOverIfExist", "", "tabCreated", "tabOpened", "tabHidden", "tabClosed", "buildReportReplaced", "registerOpenEventSource", "eventSource", "pageChange", "targetPage", "eventType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$EventType;", "duration", "Ljava/time/Duration;", "bugReportLinkClicked", "reportingWindowCopyButtonClicked", "reportingWindowClosed", "helpLinkClicked", "currentPageId", "target", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "memorySettingsOpened", "noGCSettingWarningSuppressed", "runAgpUpgradeClicked", "rerunBuildWithConfCacheClicked", "turnConfigurationCacheOnInPropertiesClicked", "updatePluginButtonClicked", "runCheckJetifierTaskClicked", "migrateToNonTransitiveRClassesClicked", "turnJetifierOffClicked", "findLibraryVersionDeclarationActionUsed", "warningsFilterApplied", "filter", "Lcom/android/build/attribution/ui/model/WarningsFilter;", "tasksFilterApplied", "Lcom/android/build/attribution/ui/model/TasksFilter;", "toolWindowBalloonShown", "newUiEventBuilder", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Builder;", "registerPage", "pageId", "toPage", "doLog", "uiEvent", "initFirstPage", "model", "Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel;", "newReportSessionId", "buildSessionId", "getStateFromModel", "reportUnregisteredEvent", "warningsFilterState", "", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$FilterItem;", "tasksFilterState", "TabOpenEventSource", "AnalyticsPageId", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAttributionUiAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAttributionUiAnalytics.kt\ncom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1869#2,2:346\n1869#2,2:348\n1869#2,2:350\n*S KotlinDebug\n*F\n+ 1 BuildAttributionUiAnalytics.kt\ncom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics\n*L\n313#1:346,2\n320#1:348,2\n335#1:350,2\n*E\n"})
public final class BuildAttributionUiAnalytics {
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<Dimension> uiSizeProvider;
    @NotNull
    private final BuildAttributionUiEvent.Page unknownPage;
    @NotNull
    private BuildAttributionUiEvent.Page currentPage;
    @NotNull
    private TabOpenEventSource tabOpenEventSource;
    @Nullable
    private String buildAttributionReportSessionId;
    @NotNull
    private final Map<AnalyticsPageId, BuildAttributionUiEvent.Page> pagesVisited;
    @NotNull
    private final Map<BuildAttributionUiEvent.Page.PageType, Integer> pagesCountByType;

    public BuildAttributionUiAnalytics(@NotNull Project project, @NotNull Function0<? extends Dimension> uiSizeProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(uiSizeProvider, (String)"uiSizeProvider");
        this.project = project;
        this.uiSizeProvider = uiSizeProvider;
        BuildAttributionUiEvent.Page page = BuildAttributionUiEvent.Page.newBuilder().setPageType(BuildAttributionUiEvent.Page.PageType.UNKNOWN_PAGE).build();
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"build(...)");
        this.currentPage = this.unknownPage = page;
        this.tabOpenEventSource = TabOpenEventSource.TAB_HEADER;
        this.pagesVisited = new LinkedHashMap();
        this.pagesCountByType = new LinkedHashMap();
        Disposer.register((Disposable)((Disposable)this.project), () -> BuildAttributionUiAnalytics._init_$lambda$0(this));
    }

    private final void sendSessionOverIfExist() {
        if (this.buildAttributionReportSessionId != null) {
            BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(this.currentPage).setEventType(BuildAttributionUiEvent.EventType.USAGE_SESSION_OVER);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
            this.doLog(builder);
        }
    }

    public final void tabCreated() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.TAB_CREATED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void tabOpened() {
        BuildAttributionUiEvent.EventType eventType = switch (WhenMappings.$EnumSwitchMapping$0[this.tabOpenEventSource.ordinal()]) {
            case 1 -> BuildAttributionUiEvent.EventType.TAB_OPENED_WITH_WNA_BUTTON;
            case 2 -> BuildAttributionUiEvent.EventType.TAB_OPENED_WITH_BUILD_OUTPUT_LINK;
            case 3 -> BuildAttributionUiEvent.EventType.TAB_OPENED_WITH_ACTION;
            case 4 -> BuildAttributionUiEvent.EventType.TAB_OPENED_WITH_TAB_CLICK;
            case 5 -> null;
            case 6 -> BuildAttributionUiEvent.EventType.TOOL_WINDOW_BALLOON_DETAILS_LINK_CLICKED;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (eventType != null) {
            BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(this.currentPage).setEventType(eventType);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
            this.doLog(builder);
        }
    }

    public final void tabHidden() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(this.currentPage).setEventType(BuildAttributionUiEvent.EventType.TAB_HIDDEN);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void tabClosed() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(this.currentPage).setEventType(BuildAttributionUiEvent.EventType.TAB_CLOSED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void buildReportReplaced() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.CONTENT_REPLACED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void registerOpenEventSource(@NotNull TabOpenEventSource eventSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventSource), (String)"eventSource");
        this.tabOpenEventSource = eventSource;
    }

    public final void pageChange(@NotNull BuildAttributionUiEvent.Page currentPage, @NotNull BuildAttributionUiEvent.Page targetPage, @NotNull BuildAttributionUiEvent.EventType eventType, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)currentPage, (String)"currentPage");
        Intrinsics.checkNotNullParameter((Object)targetPage, (String)"targetPage");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(eventType).setCurrentPage(currentPage).setTargetPage(targetPage).setEventProcessingTimeMs(duration.toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventProcessingTimeMs(...)");
        this.doLog(builder);
        this.currentPage = targetPage;
    }

    public final void bugReportLinkClicked(@NotNull BuildAttributionUiEvent.Page currentPage) {
        Intrinsics.checkNotNullParameter((Object)currentPage, (String)"currentPage");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(currentPage).setEventType(BuildAttributionUiEvent.EventType.GENERATE_REPORT_LINK_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void reportingWindowCopyButtonClicked() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(this.currentPage).setEventType(BuildAttributionUiEvent.EventType.REPORT_DIALOG_TEXT_COPY_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void reportingWindowClosed() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(this.currentPage).setEventType(BuildAttributionUiEvent.EventType.REPORT_DIALOG_CLOSED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void helpLinkClicked(@NotNull BuildAttributionUiEvent.Page currentPageId, @NotNull BuildAnalyzerBrowserLinks target2) {
        Intrinsics.checkNotNullParameter((Object)currentPageId, (String)"currentPageId");
        Intrinsics.checkNotNullParameter((Object)((Object)target2), (String)"target");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(currentPageId).setLinkTarget(target2.getAnalyticsValue()).setEventType(BuildAttributionUiEvent.EventType.HELP_LINK_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void memorySettingsOpened() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.OPEN_MEMORY_SETTINGS_BUTTON_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void noGCSettingWarningSuppressed() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.CONFIGURE_GC_WARNING_SUSPEND_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void runAgpUpgradeClicked() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.UPGRADE_AGP_BUTTON_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void rerunBuildWithConfCacheClicked() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.RERUN_BUILD_WITH_CONFIGURATION_CACHE_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void turnConfigurationCacheOnInPropertiesClicked() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.TURN_ON_CONFIGURATION_CACHE_IN_PROPERTIES_LINK_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void updatePluginButtonClicked(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.UPDATE_PLUGIN_BUTTON_CLICKED).setEventProcessingTimeMs(duration.toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventProcessingTimeMs(...)");
        this.doLog(builder);
    }

    public final void runCheckJetifierTaskClicked(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.RUN_CHECK_JETIFIER_TASK_CLICKED).setEventProcessingTimeMs(duration.toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventProcessingTimeMs(...)");
        this.doLog(builder);
    }

    public final void migrateToNonTransitiveRClassesClicked() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.MIGRATE_NON_TRANSITIVE_R_CLASS_ACTION_CLICKED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    public final void turnJetifierOffClicked(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.REMOVE_JETIFIER_PROPERTY_CLICKED).setEventProcessingTimeMs(duration.toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventProcessingTimeMs(...)");
        this.doLog(builder);
    }

    public final void findLibraryVersionDeclarationActionUsed(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.FIND_LIBRARY_DECLARATION_CLICKED).setEventProcessingTimeMs(duration.toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventProcessingTimeMs(...)");
        this.doLog(builder);
    }

    public final void warningsFilterApplied(@NotNull WarningsFilter filter2, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.FILTER_APPLIED).addAllAppliedFilters((Iterable)this.warningsFilterState(filter2)).setEventProcessingTimeMs(duration.toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventProcessingTimeMs(...)");
        this.doLog(builder);
    }

    public final void tasksFilterApplied(@NotNull TasksFilter filter2, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.FILTER_APPLIED).addAllAppliedFilters((Iterable)this.tasksFilterState(filter2)).setEventProcessingTimeMs(duration.toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventProcessingTimeMs(...)");
        this.doLog(builder);
    }

    public final void toolWindowBalloonShown() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setEventType(BuildAttributionUiEvent.EventType.TOOL_WINDOW_BALLOON_SHOWN);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    private final BuildAttributionUiEvent.Builder newUiEventBuilder() {
        BuildAttributionUiEvent.Builder builder;
        if (this.buildAttributionReportSessionId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BuildAttributionUiEvent.Builder builder2 = builder = BuildAttributionUiEvent.newBuilder();
        boolean bl = false;
        builder2.setBuildAttributionReportSessionId(this.buildAttributionReportSessionId);
        Dimension dimension2 = (Dimension)this.uiSizeProvider.invoke();
        if (dimension2 != null) {
            Dimension it = dimension2;
            boolean bl2 = false;
            builder2.setWidth((long)it.width);
            builder2.setHeight((long)it.height);
        }
        BuildAttributionUiEvent.Builder builder3 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"also(...)");
        return builder3;
    }

    private final BuildAttributionUiEvent.Page registerPage(AnalyticsPageId pageId) {
        Integer n = this.pagesCountByType.compute(pageId.getPageType(), (arg_0, arg_1) -> BuildAttributionUiAnalytics.registerPage$lambda$1(BuildAttributionUiAnalytics::registerPage$lambda$0, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)n);
        int newPageEntryIndex = ((Number)n).intValue();
        BuildAttributionUiEvent.Page page = BuildAttributionUiEvent.Page.newBuilder().setPageType(pageId.getPageType()).setPageEntryIndex(newPageEntryIndex).build();
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"build(...)");
        return page;
    }

    private final BuildAttributionUiEvent.Page toPage(AnalyticsPageId pageId) {
        BuildAttributionUiEvent.Page page = this.pagesVisited.computeIfAbsent(pageId, arg_0 -> BuildAttributionUiAnalytics.toPage$lambda$1(arg_0 -> BuildAttributionUiAnalytics.toPage$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"computeIfAbsent(...)");
        return page;
    }

    private final void doLog(BuildAttributionUiEvent.Builder uiEvent) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.BUILD_ATTRIBUTION_UI_EVENT);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setKind(...)");
        AndroidStudioEvent.Builder builder2 = UsageTrackerUtils.withProjectId(builder, this.project).setBuildAttributionUiEvent(uiEvent);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setBuildAttributionUiEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
        this.tabOpenEventSource = TabOpenEventSource.TAB_HEADER;
    }

    public final void initFirstPage(@NotNull BuildAnalyzerViewModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.currentPage = this.getStateFromModel(model);
    }

    public final void newReportSessionId(@NotNull String buildSessionId) {
        Intrinsics.checkNotNullParameter((Object)buildSessionId, (String)"buildSessionId");
        this.sendSessionOverIfExist();
        this.pagesVisited.clear();
        this.pagesCountByType.clear();
        this.currentPage = this.unknownPage;
        this.buildAttributionReportSessionId = buildSessionId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BuildAttributionUiEvent.Page getStateFromModel(@NotNull BuildAnalyzerViewModel model) {
        AnalyticsPageId analyticsPageId;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        BuildAttributionUiAnalytics buildAttributionUiAnalytics = this;
        switch (WhenMappings.$EnumSwitchMapping$2[model.getSelectedData().ordinal()]) {
            case 1: {
                analyticsPageId = new AnalyticsPageId(BuildAttributionUiEvent.Page.PageType.BUILD_SUMMARY, BuildAnalyzerViewModel.DataSet.OVERVIEW.getUiName());
                break;
            }
            case 2: {
                AnalyticsPageId analyticsPageId2;
                void it;
                TasksTreeNode tasksTreeNode = model.getTasksPageModel().getSelectedNode();
                BuildAttributionUiAnalytics buildAttributionUiAnalytics2 = buildAttributionUiAnalytics;
                boolean bl = false;
                if (it != null) {
                    analyticsPageId2 = new AnalyticsPageId(it.getDescriptor().getAnalyticsPageType(), it.getDescriptor().getPageId().getId());
                } else {
                    analyticsPageId2 = new AnalyticsPageId(switch (WhenMappings.$EnumSwitchMapping$1[model.getTasksPageModel().getSelectedGrouping().ordinal()]) {
                        case 1 -> BuildAttributionUiEvent.Page.PageType.CRITICAL_PATH_TASKS_ROOT;
                        case 2 -> BuildAttributionUiEvent.Page.PageType.PLUGIN_CRITICAL_PATH_TASKS_ROOT;
                        case 3 -> BuildAttributionUiEvent.Page.PageType.TASK_CATEGORY_CRITICAL_PATH_TASKS_ROOT;
                        default -> throw new NoWhenBranchMatchedException();
                    }, "");
                }
                analyticsPageId = analyticsPageId2;
                buildAttributionUiAnalytics = buildAttributionUiAnalytics2;
                break;
            }
            case 3: {
                WarningsTreeNode it = model.getWarningsPageModel().getSelectedNode();
                BuildAttributionUiAnalytics buildAttributionUiAnalytics3 = buildAttributionUiAnalytics;
                boolean bl = false;
                analyticsPageId = it != null ? new AnalyticsPageId(it.getDescriptor().getAnalyticsPageType(), it.getDescriptor().getPageId().getId()) : new AnalyticsPageId(BuildAttributionUiEvent.Page.PageType.WARNINGS_ROOT, "");
                buildAttributionUiAnalytics = buildAttributionUiAnalytics3;
                break;
            }
            case 4: {
                analyticsPageId = new AnalyticsPageId(BuildAttributionUiEvent.Page.PageType.DOWNLOADS_INFO, "");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return buildAttributionUiAnalytics.toPage(analyticsPageId);
    }

    public final void reportUnregisteredEvent() {
        BuildAttributionUiEvent.Builder builder = this.newUiEventBuilder().setCurrentPage(this.currentPage).setEventType(BuildAttributionUiEvent.EventType.UNKNOWN_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
        this.doLog(builder);
    }

    private final List<BuildAttributionUiEvent.FilterItem> warningsFilterState(WarningsFilter filter2) {
        Enum it;
        List list2;
        List $this$warningsFilterState_u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        Iterable $this$forEach$iv = filter2.getShowTaskSourceTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PluginSourceType)((Object)element$iv);
            boolean bl2 = false;
            $this$warningsFilterState_u24lambda_u240.add(switch (WhenMappings.$EnumSwitchMapping$3[it.ordinal()]) {
                case 1 -> BuildAttributionUiEvent.FilterItem.SHOW_ANDROID_PLUGIN_TASKS;
                case 2 -> BuildAttributionUiEvent.FilterItem.SHOW_PROJECT_CUSTOMIZATION_TASKS;
                case 3 -> BuildAttributionUiEvent.FilterItem.SHOW_THIRD_PARTY_TASKS;
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        $this$forEach$iv = filter2.getShowTaskWarningTypes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TaskIssueType)((Object)element$iv);
            boolean bl3 = false;
            $this$warningsFilterState_u24lambda_u240.add(switch (WhenMappings.$EnumSwitchMapping$4[it.ordinal()]) {
                case 1 -> BuildAttributionUiEvent.FilterItem.SHOW_ALWAYS_RUN_TASK_WARNINGS;
                case 2 -> BuildAttributionUiEvent.FilterItem.SHOW_TASK_SETUP_ISSUE_WARNINGS;
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        if (filter2.getShowAnnotationProcessorWarnings()) {
            $this$warningsFilterState_u24lambda_u240.add(BuildAttributionUiEvent.FilterItem.SHOW_ANNOTATION_PROCESSOR_WARNINGS);
        }
        if (filter2.getShowNonCriticalPathTasks()) {
            $this$warningsFilterState_u24lambda_u240.add(BuildAttributionUiEvent.FilterItem.SHOW_WARNINGS_FOR_TASK_NOT_FROM_CRITICAL_PATH);
        }
        if (filter2.getShowConfigurationCacheWarnings()) {
            $this$warningsFilterState_u24lambda_u240.add(BuildAttributionUiEvent.FilterItem.SHOW_CONFIGURATION_CACHE_WARNINGS);
        }
        if (filter2.getShowJetifierWarnings()) {
            $this$warningsFilterState_u24lambda_u240.add(BuildAttributionUiEvent.FilterItem.SHOW_JETIFIER_USAGE_WARNINGS);
        }
        return CollectionsKt.sorted((Iterable)list2);
    }

    private final List<BuildAttributionUiEvent.FilterItem> tasksFilterState(TasksFilter filter2) {
        List list2;
        List $this$tasksFilterState_u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        Iterable $this$forEach$iv = filter2.getShowTaskSourceTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginSourceType it = (PluginSourceType)((Object)element$iv);
            boolean bl2 = false;
            $this$tasksFilterState_u24lambda_u240.add(switch (WhenMappings.$EnumSwitchMapping$3[it.ordinal()]) {
                case 1 -> BuildAttributionUiEvent.FilterItem.SHOW_ANDROID_PLUGIN_TASKS;
                case 2 -> BuildAttributionUiEvent.FilterItem.SHOW_PROJECT_CUSTOMIZATION_TASKS;
                case 3 -> BuildAttributionUiEvent.FilterItem.SHOW_THIRD_PARTY_TASKS;
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        if (filter2.getShowTasksWithoutWarnings()) {
            $this$tasksFilterState_u24lambda_u240.add(BuildAttributionUiEvent.FilterItem.SHOW_TASKS_WITHOUT_WARNINGS);
        }
        return CollectionsKt.sorted((Iterable)list2);
    }

    private static final void _init_$lambda$0(BuildAttributionUiAnalytics this$0) {
        this$0.sendSessionOverIfExist();
    }

    private static final Integer registerPage$lambda$0(BuildAttributionUiEvent.Page.PageType pageType, Integer count) {
        Intrinsics.checkNotNullParameter((Object)pageType, (String)"<unused var>");
        Integer n = count;
        return n != null ? n + 1 : 1;
    }

    private static final Integer registerPage$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final BuildAttributionUiEvent.Page toPage$lambda$0(BuildAttributionUiAnalytics this$0, AnalyticsPageId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.registerPage(it);
    }

    private static final BuildAttributionUiEvent.Page toPage$lambda$1(Function1 $tmp0, Object p0) {
        return (BuildAttributionUiEvent.Page)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics$AnalyticsPageId;", "", "pageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "pageId", "", "<init>", "(Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;Ljava/lang/String;)V", "getPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getPageId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.build-attribution"})
    public static final class AnalyticsPageId {
        @NotNull
        private final BuildAttributionUiEvent.Page.PageType pageType;
        @NotNull
        private final String pageId;

        public AnalyticsPageId(@NotNull BuildAttributionUiEvent.Page.PageType pageType, @NotNull String pageId) {
            Intrinsics.checkNotNullParameter((Object)pageType, (String)"pageType");
            Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
            this.pageType = pageType;
            this.pageId = pageId;
        }

        @NotNull
        public final BuildAttributionUiEvent.Page.PageType getPageType() {
            return this.pageType;
        }

        @NotNull
        public final String getPageId() {
            return this.pageId;
        }

        @NotNull
        public final BuildAttributionUiEvent.Page.PageType component1() {
            return this.pageType;
        }

        @NotNull
        public final String component2() {
            return this.pageId;
        }

        @NotNull
        public final AnalyticsPageId copy(@NotNull BuildAttributionUiEvent.Page.PageType pageType, @NotNull String pageId) {
            Intrinsics.checkNotNullParameter((Object)pageType, (String)"pageType");
            Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
            return new AnalyticsPageId(pageType, pageId);
        }

        public static /* synthetic */ AnalyticsPageId copy$default(AnalyticsPageId analyticsPageId, BuildAttributionUiEvent.Page.PageType pageType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                pageType = analyticsPageId.pageType;
            }
            if ((n & 2) != 0) {
                string = analyticsPageId.pageId;
            }
            return analyticsPageId.copy(pageType, string);
        }

        @NotNull
        public String toString() {
            return "AnalyticsPageId(pageType=" + this.pageType + ", pageId=" + this.pageId + ")";
        }

        public int hashCode() {
            int result2 = this.pageType.hashCode();
            result2 = result2 * 31 + this.pageId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnalyticsPageId)) {
                return false;
            }
            AnalyticsPageId analyticsPageId = (AnalyticsPageId)other;
            if (this.pageType != analyticsPageId.pageType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pageId, (Object)analyticsPageId.pageId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics$TabOpenEventSource;", "", "<init>", "(Ljava/lang/String;I)V", "WNA_BUTTON", "BUILD_OUTPUT_LINK", "TAB_HEADER", "AUTO_OPEN", "BALLOON_LINK", "BUILD_MENU_ACTION", "intellij.android.build-attribution"})
    public static final class TabOpenEventSource
    extends Enum<TabOpenEventSource> {
        public static final /* enum */ TabOpenEventSource WNA_BUTTON = new TabOpenEventSource();
        public static final /* enum */ TabOpenEventSource BUILD_OUTPUT_LINK = new TabOpenEventSource();
        public static final /* enum */ TabOpenEventSource TAB_HEADER = new TabOpenEventSource();
        public static final /* enum */ TabOpenEventSource AUTO_OPEN = new TabOpenEventSource();
        public static final /* enum */ TabOpenEventSource BALLOON_LINK = new TabOpenEventSource();
        public static final /* enum */ TabOpenEventSource BUILD_MENU_ACTION = new TabOpenEventSource();
        private static final /* synthetic */ TabOpenEventSource[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TabOpenEventSource[] values() {
            return (TabOpenEventSource[])$VALUES.clone();
        }

        public static TabOpenEventSource valueOf(String value2) {
            return Enum.valueOf(TabOpenEventSource.class, value2);
        }

        @NotNull
        public static EnumEntries<TabOpenEventSource> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tabOpenEventSourceArray = new TabOpenEventSource[]{TabOpenEventSource.WNA_BUTTON, TabOpenEventSource.BUILD_OUTPUT_LINK, TabOpenEventSource.TAB_HEADER, TabOpenEventSource.AUTO_OPEN, TabOpenEventSource.BALLOON_LINK, TabOpenEventSource.BUILD_MENU_ACTION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[TabOpenEventSource.values().length];
            try {
                nArray[TabOpenEventSource.WNA_BUTTON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabOpenEventSource.BUILD_OUTPUT_LINK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabOpenEventSource.BUILD_MENU_ACTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabOpenEventSource.TAB_HEADER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabOpenEventSource.AUTO_OPEN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TabOpenEventSource.BALLOON_LINK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TasksDataPageModel.Grouping.values().length];
            try {
                nArray[TasksDataPageModel.Grouping.UNGROUPED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TasksDataPageModel.Grouping.BY_PLUGIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TasksDataPageModel.Grouping.BY_TASK_CATEGORY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[BuildAnalyzerViewModel.DataSet.values().length];
            try {
                nArray[BuildAnalyzerViewModel.DataSet.OVERVIEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildAnalyzerViewModel.DataSet.TASKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildAnalyzerViewModel.DataSet.WARNINGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildAnalyzerViewModel.DataSet.DOWNLOADS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[PluginSourceType.values().length];
            try {
                nArray[PluginSourceType.ANDROID_PLUGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginSourceType.BUILD_SCRIPT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginSourceType.THIRD_PARTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[TaskIssueType.values().length];
            try {
                nArray[TaskIssueType.ALWAYS_RUN_TASKS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskIssueType.TASK_SETUP_ISSUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

