/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.build.attribution.AbstractBuildAnalysisResult;
import com.android.build.attribution.BuildAnalysisResults;
import com.android.build.attribution.BuildAnalyzerNotificationManager;
import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.FailureResult;
import com.android.build.attribution.HistoricBuildAnalysisResults;
import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.build.attribution.ui.BuildAttributionUiManagerImpl;
import com.android.build.attribution.ui.BuildAttributionUiManagerKt;
import com.android.build.attribution.ui.BuildFailureViewComponentContainer;
import com.android.build.attribution.ui.NewViewComponentContainer;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.TaskIssueReporterImpl;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.builder.BuildAttributionReportBuilder;
import com.android.build.attribution.ui.model.BuildAnalyzerViewModel;
import com.android.build.diagnostic.WindowsDefenderCheckService;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.BuildContentManager;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f*\u0001\u0018\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0003J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0003J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070-2\u0006\u0010$\u001a\u00020.H\u0002J\u0016\u0010/\u001a\u00020\u001f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00070-H\u0002J\u001e\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u000f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00070-H\u0002J\u0018\u00103\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u00104\u001a\u00020\u001f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00070-H\u0002J\f\u00105\u001a\u00020\u001f*\u00020\u000fH\u0002J\b\u00106\u001a\u00020\u001fH\u0002J\b\u00107\u001a\u00020\u001fH\u0003J\b\u00108\u001a\u00020\u001fH\u0002J\b\u00109\u001a\u00020\u001fH\u0002J\b\u0010:\u001a\u00020\u001fH\u0016J\u0016\u0010;\u001a\u00020\u001f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/android/build/attribution/ui/BuildAttributionUiManagerImpl;", "Lcom/android/build/attribution/ui/BuildAttributionUiManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "buildAttributionView", "Lcom/intellij/openapi/ui/ComponentContainer;", "getBuildAttributionView$annotations", "()V", "getBuildAttributionView", "()Lcom/intellij/openapi/ui/ComponentContainer;", "setBuildAttributionView", "(Lcom/intellij/openapi/ui/ComponentContainer;)V", "buildContent", "Lcom/intellij/ui/content/Content;", "getBuildContent$annotations", "getBuildContent", "()Lcom/intellij/ui/content/Content;", "setBuildContent", "(Lcom/intellij/ui/content/Content;)V", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "contentManagerListener", "com/android/build/attribution/ui/BuildAttributionUiManagerImpl$contentManagerListener$1", "Lcom/android/build/attribution/ui/BuildAttributionUiManagerImpl$contentManagerListener$1;", "uiAnalytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "notificationManager", "Lcom/android/build/attribution/BuildAnalyzerNotificationManager;", "showBuildAnalysisReportById", "", "buildID", "", "showNewReport", "doShowNewSuccessReport", "buildAnalysisResult", "Lcom/android/build/attribution/BuildAnalysisResults;", "doShowNewFailureReport", "failureType", "Lcom/android/build/attribution/FailureResult$Type;", "openTab", "eventSource", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics$TabOpenEventSource;", "getViewFactoryFromLatestResultStatus", "Lkotlin/Function0;", "Lcom/android/build/attribution/AbstractBuildAnalysisResult;", "createTabWithNewView", "viewFactory", "placeNewViewInExistingTab", "content", "makeExistingTabSelected", "createAndRegisterNewView", "replaceContentView", "createNewTab", "reInitReportUI", "onContentClosed", "cleanUp", "dispose", "invokeLaterIfNotDisposed", "runnable", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAttributionUiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAttributionUiManager.kt\ncom/android/build/attribution/ui/BuildAttributionUiManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1#2:361\n*E\n"})
public final class BuildAttributionUiManagerImpl
implements BuildAttributionUiManager {
    @NotNull
    private final Project project;
    @Nullable
    private ComponentContainer buildAttributionView;
    @Nullable
    private Content buildContent;
    @Nullable
    private ContentManager contentManager;
    @NotNull
    private final contentManagerListener.1 contentManagerListener;
    @NotNull
    private final BuildAttributionUiAnalytics uiAnalytics;
    @NotNull
    private final BuildAnalyzerNotificationManager notificationManager;

    public BuildAttributionUiManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.contentManagerListener = new ContentManagerListener(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getContent() != this.this$0.getBuildContent()) {
                    return;
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).tabOpened();
                } else if (event.getOperation() == ContentManagerEvent.ContentOperation.remove) {
                    BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).tabHidden();
                }
            }
        };
        this.uiAnalytics = new BuildAttributionUiAnalytics(this.project, (Function0<? extends Dimension>)((Function0)() -> BuildAttributionUiManagerImpl.uiAnalytics$lambda$0(this)));
        this.notificationManager = new BuildAnalyzerNotificationManager(this.project, this.uiAnalytics);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> BuildAttributionUiManagerImpl._init_$lambda$0(this, arg_0));
    }

    @Nullable
    public final ComponentContainer getBuildAttributionView() {
        return this.buildAttributionView;
    }

    public final void setBuildAttributionView(@Nullable ComponentContainer componentContainer) {
        this.buildAttributionView = componentContainer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBuildAttributionView$annotations() {
    }

    @Nullable
    public final Content getBuildContent() {
        return this.buildContent;
    }

    public final void setBuildContent(@Nullable Content content2) {
        this.buildContent = content2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBuildContent$annotations() {
    }

    @Override
    public void showBuildAnalysisReportById(@NotNull String buildID) {
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        if (!((Boolean)StudioFlags.BUILD_ANALYZER_HISTORY.get()).booleanValue()) {
            return;
        }
        HistoricBuildAnalysisResults buildResults = BuildAnalyzerStorageManager.Companion.getInstance(this.project).getHistoricBuildResultByID(buildID).get();
    }

    @Override
    public void showNewReport() {
        this.invokeLaterIfNotDisposed((Function0<Unit>)((Function0)() -> BuildAttributionUiManagerImpl.showNewReport$lambda$0(this)));
    }

    @UiThread
    private final void doShowNewSuccessReport(BuildAnalysisResults buildAnalysisResult) {
        BuildAttributionReportUiData reportUiData = new BuildAttributionReportBuilder(buildAnalysisResult, WindowsDefenderCheckService.Companion.getInstance(this.project).getWarningData()).build();
        Function0 viewFactory = () -> BuildAttributionUiManagerImpl.doShowNewSuccessReport$lambda$0(reportUiData, this);
        Content content2 = this.buildContent;
        if (content2 != null && content2.isValid()) {
            this.placeNewViewInExistingTab(content2, (Function0<? extends ComponentContainer>)viewFactory);
        } else {
            this.createTabWithNewView((Function0<? extends ComponentContainer>)viewFactory);
        }
        if (BuildAttributionUiManagerKt.access$shouldAutoOpenTab(reportUiData)) {
            Content content3 = this.buildContent;
            Intrinsics.checkNotNull((Object)content3);
            this.makeExistingTabSelected(content3, BuildAttributionUiAnalytics.TabOpenEventSource.AUTO_OPEN);
        }
        this.notificationManager.showToolWindowBalloonIfNeeded(reportUiData, (Function0<Unit>)((Function0)() -> BuildAttributionUiManagerImpl.doShowNewSuccessReport$lambda$1(this)));
    }

    @UiThread
    private final void doShowNewFailureReport(FailureResult.Type failureType) {
        Content content2 = this.buildContent;
        if (content2 != null && content2.isValid()) {
            this.placeNewViewInExistingTab(content2, (Function0<? extends ComponentContainer>)((Function0)() -> BuildAttributionUiManagerImpl.doShowNewFailureReport$lambda$0(failureType)));
        }
    }

    @Override
    public void openTab(@NotNull BuildAttributionUiAnalytics.TabOpenEventSource eventSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventSource), (String)"eventSource");
        if (BuildAnalyzerStorageManager.Companion.getInstance(this.project).hasData()) {
            this.invokeLaterIfNotDisposed((Function0<Unit>)((Function0)() -> BuildAttributionUiManagerImpl.openTab$lambda$0(this, eventSource)));
        }
    }

    private final Function0<ComponentContainer> getViewFactoryFromLatestResultStatus(AbstractBuildAnalysisResult buildAnalysisResult) {
        AbstractBuildAnalysisResult abstractBuildAnalysisResult = buildAnalysisResult;
        if (abstractBuildAnalysisResult instanceof BuildAnalysisResults) {
            BuildAttributionReportUiData reportUiData = new BuildAttributionReportBuilder((BuildEventsAnalysisResult)((Object)buildAnalysisResult), WindowsDefenderCheckService.Companion.getInstance(this.project).getWarningData()).build();
            return () -> BuildAttributionUiManagerImpl.getViewFactoryFromLatestResultStatus$lambda$0(reportUiData, this);
        }
        if (abstractBuildAnalysisResult instanceof FailureResult) {
            return () -> BuildAttributionUiManagerImpl.getViewFactoryFromLatestResultStatus$lambda$1(buildAnalysisResult);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void createTabWithNewView(Function0<? extends ComponentContainer> viewFactory) {
        this.createAndRegisterNewView(viewFactory);
        this.createNewTab();
    }

    private final void placeNewViewInExistingTab(Content content2, Function0<? extends ComponentContainer> viewFactory) {
        this.createAndRegisterNewView(viewFactory);
        this.replaceContentView(content2);
    }

    private final void makeExistingTabSelected(Content content2, BuildAttributionUiAnalytics.TabOpenEventSource eventSource) {
        this.uiAnalytics.registerOpenEventSource(eventSource);
        ContentManager contentManager = content2.getManager();
        if (contentManager != null) {
            contentManager.setSelectedContent(content2, true, true);
        }
        BuildContentManager.getInstance((Project)this.project).getOrCreateToolWindow().show(BuildAttributionUiManagerImpl::makeExistingTabSelected$lambda$0);
    }

    private final void createAndRegisterNewView(Function0<? extends ComponentContainer> viewFactory) {
        ComponentContainer componentContainer = this.buildAttributionView;
        if (componentContainer != null) {
            ComponentContainer existingView = componentContainer;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)existingView));
        }
        this.buildAttributionView = (ComponentContainer)viewFactory.invoke();
    }

    private final void replaceContentView(Content $this$replaceContentView) {
        block0: {
            ComponentContainer componentContainer = this.buildAttributionView;
            if (componentContainer == null) break block0;
            ComponentContainer view = componentContainer;
            boolean bl = false;
            $this$replaceContentView.getComponent().removeAll();
            $this$replaceContentView.getComponent().add((Component)view.getComponent(), "Center");
            Disposer.register((Disposable)((Disposable)$this$replaceContentView), (Disposable)((Disposable)view));
            this.uiAnalytics.buildReportReplaced();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createNewTab() {
        block1: {
            void content2;
            ContentImpl contentImpl;
            ComponentContainer componentContainer = this.buildAttributionView;
            if (componentContainer == null) break block1;
            ComponentContainer view = componentContainer;
            boolean bl = false;
            ContentImpl contentImpl2 = contentImpl = new ContentImpl((JComponent)new BorderLayoutPanel(), "Build Analyzer", true);
            BuildAttributionUiManagerImpl buildAttributionUiManagerImpl = this;
            boolean bl2 = false;
            content2.getComponent().add((Component)view.getComponent(), "Center");
            Disposer.register((Disposable)this, (Disposable)((Disposable)content2));
            Disposer.register((Disposable)((Disposable)content2), (Disposable)((Disposable)view));
            Disposer.register((Disposable)((Disposable)content2), () -> BuildAttributionUiManagerImpl.createNewTab$lambda$0$0$0(this));
            BuildContentManager.getInstance((Project)this.project).addContent((Content)content2);
            this.uiAnalytics.tabCreated();
            ContentManager contentManager = this.contentManager = content2.getManager();
            if (contentManager != null) {
                contentManager.addContentManagerListener((ContentManagerListener)this.contentManagerListener);
            }
            buildAttributionUiManagerImpl.buildContent = (Content)contentImpl;
        }
    }

    @UiThread
    private final void reInitReportUI() {
        block2: {
            Content content2 = this.buildContent;
            if (content2 == null || !content2.isValid()) break block2;
            ComponentContainer componentContainer = this.buildAttributionView;
            if (componentContainer != null) {
                ComponentContainer view = componentContainer;
                boolean bl = false;
                NewViewComponentContainer newViewComponentContainer = view instanceof NewViewComponentContainer ? (NewViewComponentContainer)view : null;
                if (newViewComponentContainer != null) {
                    newViewComponentContainer.reInitUi();
                }
                content2.getComponent().removeAll();
                content2.getComponent().add((Component)view.getComponent(), "Center");
            }
        }
    }

    private final void onContentClosed() {
        this.uiAnalytics.tabClosed();
        this.cleanUp();
    }

    private final void cleanUp() {
        ContentManager contentManager = this.contentManager;
        if (contentManager != null) {
            contentManager.removeContentManagerListener((ContentManagerListener)this.contentManagerListener);
        }
        this.contentManager = null;
        this.buildAttributionView = null;
        this.buildContent = null;
    }

    public void dispose() {
        this.cleanUp();
    }

    private final void invokeLaterIfNotDisposed(Function0<Unit> runnable2) {
        BuildAttributionUiManagerKt.invokeLaterIfNotDisposed(this.project, runnable2);
    }

    private static final Dimension uiAnalytics$lambda$0(BuildAttributionUiManagerImpl this$0) {
        Object object = this$0.buildAttributionView;
        return object != null && (object = object.getComponent()) != null ? ((Component)object).getSize() : null;
    }

    private static final void _init_$lambda$0(BuildAttributionUiManagerImpl this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reInitReportUI();
    }

    private static final Unit showNewReport$lambda$0(BuildAttributionUiManagerImpl this$0) {
        AbstractBuildAnalysisResult buildAnalysisResult = BuildAnalyzerStorageManager.Companion.getInstance(this$0.project).getLatestBuildAnalysisResults();
        this$0.uiAnalytics.newReportSessionId(buildAnalysisResult.getBuildSessionID());
        AbstractBuildAnalysisResult abstractBuildAnalysisResult = buildAnalysisResult;
        if (abstractBuildAnalysisResult instanceof FailureResult) {
            this$0.doShowNewFailureReport(((FailureResult)buildAnalysisResult).getFailureType());
        } else if (abstractBuildAnalysisResult instanceof BuildAnalysisResults) {
            this$0.doShowNewSuccessReport((BuildAnalysisResults)buildAnalysisResult);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final NewViewComponentContainer doShowNewSuccessReport$lambda$0(BuildAttributionReportUiData $reportUiData, BuildAttributionUiManagerImpl this$0) {
        TaskIssueReporterImpl issueReporter = new TaskIssueReporterImpl($reportUiData, this$0.project, this$0.uiAnalytics);
        return new NewViewComponentContainer($reportUiData, this$0.project, issueReporter, this$0.uiAnalytics);
    }

    private static final Unit doShowNewSuccessReport$lambda$1(BuildAttributionUiManagerImpl this$0) {
        block0: {
            this$0.openTab(BuildAttributionUiAnalytics.TabOpenEventSource.BALLOON_LINK);
            ComponentContainer componentContainer = this$0.buildAttributionView;
            NewViewComponentContainer newViewComponentContainer = componentContainer instanceof NewViewComponentContainer ? (NewViewComponentContainer)componentContainer : null;
            if (newViewComponentContainer == null) break block0;
            NewViewComponentContainer it = newViewComponentContainer;
            boolean bl = false;
            it.getModel().setSelectedData(BuildAnalyzerViewModel.DataSet.WARNINGS);
        }
        return Unit.INSTANCE;
    }

    private static final ComponentContainer doShowNewFailureReport$lambda$0(FailureResult.Type $failureType) {
        return new BuildFailureViewComponentContainer($failureType);
    }

    private static final Unit openTab$lambda$0(BuildAttributionUiManagerImpl this$0, BuildAttributionUiAnalytics.TabOpenEventSource $eventSource) {
        Content content2 = this$0.buildContent;
        if (!(content2 != null ? content2.isValid() : false)) {
            Function0<ComponentContainer> viewFactory = this$0.getViewFactoryFromLatestResultStatus(BuildAnalyzerStorageManager.Companion.getInstance(this$0.project).getLatestBuildAnalysisResults());
            this$0.createTabWithNewView(viewFactory);
        }
        Content content3 = this$0.buildContent;
        Intrinsics.checkNotNull((Object)content3);
        this$0.makeExistingTabSelected(content3, $eventSource);
        return Unit.INSTANCE;
    }

    private static final NewViewComponentContainer getViewFactoryFromLatestResultStatus$lambda$0(BuildAttributionReportUiData $reportUiData, BuildAttributionUiManagerImpl this$0) {
        TaskIssueReporterImpl issueReporter = new TaskIssueReporterImpl($reportUiData, this$0.project, this$0.uiAnalytics);
        return new NewViewComponentContainer($reportUiData, this$0.project, issueReporter, this$0.uiAnalytics);
    }

    private static final BuildFailureViewComponentContainer getViewFactoryFromLatestResultStatus$lambda$1(AbstractBuildAnalysisResult $buildAnalysisResult) {
        return new BuildFailureViewComponentContainer(((FailureResult)$buildAnalysisResult).getFailureType());
    }

    private static final void makeExistingTabSelected$lambda$0() {
    }

    private static final void createNewTab$lambda$0$0$0(BuildAttributionUiManagerImpl this$0) {
        this$0.onContentClosed();
    }

    public static final /* synthetic */ BuildAttributionUiAnalytics access$getUiAnalytics$p(BuildAttributionUiManagerImpl $this) {
        return $this.uiAnalytics;
    }
}

