/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.build.attribution.BuildAnalysisResults;
import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.FailureResult;
import com.android.build.attribution.KnownGradlePluginsService;
import com.android.build.attribution.analytics.BuildAttributionAnalyticsManager;
import com.android.build.attribution.analyzers.BuildAnalyzersWrapper;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.CriticalPathAnalyzer;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.data.BuildInvocationType;
import com.android.build.attribution.data.BuildRequestHolder;
import com.android.build.attribution.data.GradlePluginsData;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.build.attribution.ui.BuildAttributionUiManagerKt;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.ConfigurationCacheTestBuildFlowRunner;
import com.android.build.output.DownloadInfoDataModel;
import com.android.build.output.DownloadsInfoPresentableBuildEvent;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.attribution.BasicBuildAttributionInfo;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionManager;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionUtil;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.BuildViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0014\u0010\u0019\u001a\u00020\u0014*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010$J$\u0010%\u001a\u00020\u0014*\u00020\u00032\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/android/build/attribution/BuildAttributionManagerImpl;", "Lcom/android/tools/idea/gradle/project/build/attribution/BuildAttributionManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "currentBuildAnalysisContext", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/build/attribution/BuildAttributionManagerImpl$BuildAnalysisContext;", "currentBuildRequest", "Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;", "getCurrentBuildRequest", "()Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;", "onBuildStart", "", "request", "onBuildSuccess", "Lcom/android/tools/idea/gradle/project/build/attribution/BasicBuildAttributionInfo;", "onBuildFailure", "cleanup", "attributionFileDir", "Ljava/io/File;", "statusChanged", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "openResultsTab", "shouldShowBuildOutputLink", "", "getNumberOfPartialResultsGenerated", "", "(Ljava/io/File;)Ljava/lang/Integer;", "setUpDownloadsInfoNodeOnBuildOutput", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "buildDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "downloadsInfoDataModel", "Lcom/android/build/output/DownloadInfoDataModel;", "BuildAnalysisContext", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAttributionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAttributionManagerImpl.kt\ncom/android/build/attribution/BuildAttributionManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n808#2,11:230\n1#3:241\n*S KotlinDebug\n*F\n+ 1 BuildAttributionManagerImpl.kt\ncom/android/build/attribution/BuildAttributionManagerImpl\n*L\n100#1:230,11\n*E\n"})
public final class BuildAttributionManagerImpl
implements BuildAttributionManager {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<BuildAnalysisContext> currentBuildAnalysisContext;

    public BuildAttributionManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.currentBuildAnalysisContext = new AtomicReference();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final Logger getLog() {
        Logger logger = Logger.getInstance((String)"Build Analyzer");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @VisibleForTesting
    @NotNull
    public final GradleBuildInvoker.Request getCurrentBuildRequest() {
        return this.currentBuildAnalysisContext.get().getCurrentBuildRequest();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onBuildStart(@NotNull GradleBuildInvoker.Request request) {
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            BuildAnalysisContext $this$onBuildStart_u24lambda_u240 = new BuildAnalysisContext(request);
            boolean bl = false;
            this.currentBuildAnalysisContext.set($this$onBuildStart_u24lambda_u240);
            ((KnownGradlePluginsService)ApplicationManager.getApplication().getService(KnownGradlePluginsService.class)).asyncRefresh();
            if (!((Boolean)StudioFlags.BUILD_OUTPUT_DOWNLOADS_INFORMATION.get()).booleanValue()) {
                return;
            }
            Iterable $this$filterIsInstance$iv = $this$onBuildStart_u24lambda_u240.getAnalyzersProxy().getBuildAnalyzers();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DownloadsAnalyzer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            DownloadsAnalyzer downloadsAnalyzer = (DownloadsAnalyzer)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            if (downloadsAnalyzer == null) break block2;
            DownloadsAnalyzer it = downloadsAnalyzer;
            boolean bl2 = false;
            DownloadInfoDataModel downloadsInfoDataModel = new DownloadInfoDataModel((Disposable)$this$onBuildStart_u24lambda_u240.getCurrentBuildDisposable(), null, 2, null);
            it.getEventsProcessor().setDownloadsInfoDataModel(downloadsInfoDataModel);
            this.setUpDownloadsInfoNodeOnBuildOutput(this.project, request.getTaskId(), $this$onBuildStart_u24lambda_u240.getCurrentBuildDisposable(), downloadsInfoDataModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public BasicBuildAttributionInfo onBuildSuccess(@NotNull GradleBuildInvoker.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        long buildFinishedProcessedTimestamp = System.currentTimeMillis();
        Ref.ObjectRef agpVersion = new Ref.ObjectRef();
        BuildAnalysisContext buildAnalysisContext = this.currentBuildAnalysisContext.get();
        if (buildAnalysisContext != null) {
            BuildAnalysisContext $this$onBuildSuccess_u24lambda_u240 = buildAnalysisContext;
            boolean bl = false;
            Closeable closeable = $this$onBuildSuccess_u24lambda_u240.getAnalyticsManager();
            Throwable throwable = null;
            try {
                BuildAttributionAnalyticsManager analyticsManager = (BuildAttributionAnalyticsManager)closeable;
                boolean bl2 = false;
                analyticsManager.runLoggingPerformanceStats(buildFinishedProcessedTimestamp - ((CriticalPathAnalyzer.Result)$this$onBuildSuccess_u24lambda_u240.getAnalyzersProxy().getCriticalPathAnalyzer().getResult()).getBuildFinishedTimestamp(), this.getNumberOfPartialResultsGenerated($this$onBuildSuccess_u24lambda_u240.getAttributionFileDir()), (Function0<Unit>)((Function0)() -> BuildAttributionManagerImpl.onBuildSuccess$lambda$0$0$0($this$onBuildSuccess_u24lambda_u240, agpVersion, this, analyticsManager)));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return new BasicBuildAttributionInfo((AgpVersion)agpVersion.element);
    }

    @Override
    public void onBuildFailure(@NotNull GradleBuildInvoker.Request request) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            BuildAnalysisContext buildAnalysisContext = this.currentBuildAnalysisContext.get();
            if (buildAnalysisContext == null) break block0;
            BuildAnalysisContext $this$onBuildFailure_u24lambda_u240 = buildAnalysisContext;
            boolean bl = false;
            this.cleanup($this$onBuildFailure_u24lambda_u240, BuildAttributionUtil.getAgpAttributionFileDir(request.getData()));
            BuildAttributionUiManagerKt.invokeLaterIfNotDisposed(this.project, (Function0<Unit>)((Function0)() -> BuildAttributionManagerImpl.onBuildFailure$lambda$0$0(this, $this$onBuildFailure_u24lambda_u240)));
        }
    }

    private final void cleanup(BuildAnalysisContext $this$cleanup, File attributionFileDir) {
        ProgressManager.getInstance().executeNonCancelableSection(() -> BuildAttributionManagerImpl.cleanup$lambda$0($this$cleanup, this, attributionFileDir));
    }

    public void statusChanged(@Nullable ProgressEvent event) {
        block4: {
            BuildAnalysisContext buildAnalysisContext = this.currentBuildAnalysisContext.get();
            if (buildAnalysisContext == null) break block4;
            BuildAnalysisContext $this$statusChanged_u24lambda_u240 = buildAnalysisContext;
            boolean bl = false;
            if ($this$statusChanged_u24lambda_u240.getEventsProcessingFailedFlag()) {
                return;
            }
            try {
                if (event == null) {
                    return;
                }
                $this$statusChanged_u24lambda_u240.getAnalyzersWrapper().receiveEvent(event);
            }
            catch (Throwable t) {
                $this$statusChanged_u24lambda_u240.setEventsProcessingFailedFlag(true);
                this.getLog().error("Error during build events processing", t);
            }
        }
    }

    @Override
    public void openResultsTab() {
        BuildAttributionUiManager.Companion.getInstance(this.project).openTab(BuildAttributionUiAnalytics.TabOpenEventSource.BUILD_OUTPUT_LINK);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldShowBuildOutputLink() {
        if (ConfigurationCacheTestBuildFlowRunner.Companion.getInstance(this.project).getRunningFirstConfigurationCacheBuild()) return false;
        BuildAnalysisContext buildAnalysisContext = this.currentBuildAnalysisContext.get();
        if (buildAnalysisContext == null) return true;
        if (!buildAnalysisContext.getEventsProcessingFailedFlag()) return true;
        return false;
    }

    private final Integer getNumberOfPartialResultsGenerated(File attributionFileDir) {
        File[] fileArray;
        try {
            File[] fileArray2;
            File[] it = fileArray2 = AndroidGradlePluginAttributionData.Companion.getPartialResultsDir(attributionFileDir);
            boolean bl = false;
            fileArray = it.exists() ? fileArray2 : null;
            fileArray = fileArray != null && (fileArray2 = fileArray.listFiles()) != null ? Integer.valueOf(fileArray2.length) : null;
        }
        catch (Exception e) {
            fileArray = null;
        }
        return fileArray;
    }

    private final void setUpDownloadsInfoNodeOnBuildOutput(Project $this$setUpDownloadsInfoNodeOnBuildOutput, ExternalSystemTaskId id2, CheckedDisposable buildDisposable, DownloadInfoDataModel downloadsInfoDataModel) {
        GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion($this$setUpDownloadsInfoNodeOnBuildOutput);
        DownloadsInfoPresentableBuildEvent rootDownloadEvent = new DownloadsInfoPresentableBuildEvent(id2, buildDisposable, System.currentTimeMillis(), gradleVersion2, downloadsInfoDataModel);
        BuildViewManager viewManager = (BuildViewManager)$this$setUpDownloadsInfoNodeOnBuildOutput.getService(BuildViewManager.class);
        viewManager.onEvent((Object)id2, (BuildEvent)rootDownloadEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit onBuildSuccess$lambda$0$0$0(BuildAnalysisContext $this_run, Ref.ObjectRef $agpVersion, BuildAttributionManagerImpl this$0, BuildAttributionAnalyticsManager $analyticsManager) {
        try {
            AgpVersion agpVersion;
            AndroidGradlePluginAttributionData attributionData = AndroidGradlePluginAttributionData.Companion.load($this_run.getAttributionFileDir());
            Ref.ObjectRef objectRef = $agpVersion;
            Object object = attributionData;
            if (object != null && (object = object.getBuildInfo()) != null && (object = object.getAgpVersion()) != null) {
                void it;
                Object object2 = object;
                Ref.ObjectRef objectRef2 = objectRef;
                boolean bl = false;
                agpVersion = AgpVersion.Companion.tryParse((String)it);
                objectRef = objectRef2;
            } else {
                agpVersion = null;
            }
            objectRef.element = agpVersion;
            GradlePluginsData pluginsData = ((KnownGradlePluginsService)ApplicationManager.getApplication().getService(KnownGradlePluginsService.class)).getGradlePluginsData();
            StudioProvidedInfo studioProvidedInfo = StudioProvidedInfo.Companion.fromProject(this$0.project, $this_run.getBuildRequestHolder(), $this_run.getCurrentBuildInvocationType());
            if (!$this_run.getEventsProcessingFailedFlag()) {
                $this_run.getAnalyzersWrapper().onBuildSuccess(attributionData, pluginsData, $this_run.getAnalyzersProxy(), studioProvidedInfo);
                Future<BuildAnalysisResults> analysisResults = BuildAnalyzerStorageManager.Companion.getInstance(this$0.project).storeNewBuildResults($this_run.getAnalyzersProxy(), $this_run.getBuildSessionId(), new BuildRequestHolder($this_run.getCurrentBuildRequest()));
                BuildAnalysisResults buildAnalysisResults = analysisResults.get();
                Intrinsics.checkNotNullExpressionValue((Object)buildAnalysisResults, (String)"get(...)");
                $analyticsManager.logAnalyzersData(buildAnalysisResults);
                $analyticsManager.logBuildSuccess($this_run.getCurrentBuildInvocationType());
            } else {
                $analyticsManager.logAnalysisFailure($this_run.getCurrentBuildInvocationType());
                BuildAnalyzerStorageManager.Companion.getInstance(this$0.project).recordNewFailure($this_run.getBuildSessionId(), FailureResult.Type.ANALYSIS_FAILURE);
            }
        }
        catch (ProcessCanceledException e) {
            BuildAnalyzerStorageManager.Companion.getInstance(this$0.project).recordNewFailure($this_run.getBuildSessionId(), FailureResult.Type.ANALYSIS_CANCELED);
            $analyticsManager.logAnalysisCancellation($this_run.getCurrentBuildInvocationType());
            throw e;
        }
        catch (Throwable t) {
            this$0.getLog().error("Error during post-build analysis", t);
            $analyticsManager.logAnalysisFailure($this_run.getCurrentBuildInvocationType());
            BuildAnalyzerStorageManager.Companion.getInstance(this$0.project).recordNewFailure($this_run.getBuildSessionId(), FailureResult.Type.ANALYSIS_FAILURE);
        }
        finally {
            this$0.cleanup($this_run, $this_run.getAttributionFileDir());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit onBuildFailure$lambda$0$0(BuildAttributionManagerImpl this$0, BuildAnalysisContext $this_run) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String buildSessionId = string;
        Closeable closeable = new BuildAttributionAnalyticsManager(buildSessionId, this$0.project);
        Throwable throwable = null;
        try {
            BuildAttributionAnalyticsManager analyticsManager = (BuildAttributionAnalyticsManager)closeable;
            boolean bl = false;
            analyticsManager.logBuildFailure($this_run.getCurrentBuildInvocationType());
            $this_run.getAnalyzersWrapper().onBuildFailure();
            BuildAnalyzerStorageManager.Companion.getInstance(this$0.project).recordNewFailure(buildSessionId, FailureResult.Type.BUILD_FAILURE);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final void cleanup$lambda$0(BuildAnalysisContext $this_cleanup, BuildAttributionManagerImpl this$0, File $attributionFileDir) {
        try {
            CheckedDisposable it = $this_cleanup.getCurrentBuildDisposable();
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        catch (Throwable t) {
            this$0.getLog().error("Error disposing build disposable", t);
        }
        try {
            String[] t = new String[]{"build-attribution"};
            FileUtils.deleteRecursivelyIfExists((File)FileUtils.join((File)$attributionFileDir, (String[])t));
        }
        catch (Throwable t) {
            this$0.getLog().error("Error during build attribution files cleanup", t);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u00068"}, d2={"Lcom/android/build/attribution/BuildAttributionManagerImpl$BuildAnalysisContext;", "", "currentBuildRequest", "Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;", "<init>", "(Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;)V", "getCurrentBuildRequest", "()Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;", "buildSessionId", "", "getBuildSessionId", "()Ljava/lang/String;", "currentBuildDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "getCurrentBuildDisposable", "()Lcom/intellij/openapi/util/CheckedDisposable;", "eventsProcessingFailedFlag", "", "getEventsProcessingFailedFlag", "()Z", "setEventsProcessingFailedFlag", "(Z)V", "currentBuildInvocationType", "Lcom/android/build/attribution/data/BuildInvocationType;", "getCurrentBuildInvocationType", "()Lcom/android/build/attribution/data/BuildInvocationType;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "getTaskContainer", "()Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "getPluginContainer", "()Lcom/android/build/attribution/data/PluginContainer;", "analyzersProxy", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "getAnalyzersProxy", "()Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "analyzersWrapper", "Lcom/android/build/attribution/analyzers/BuildAnalyzersWrapper;", "getAnalyzersWrapper", "()Lcom/android/build/attribution/analyzers/BuildAnalyzersWrapper;", "attributionFileDir", "Ljava/io/File;", "getAttributionFileDir", "()Ljava/io/File;", "buildRequestHolder", "Lcom/android/build/attribution/data/BuildRequestHolder;", "getBuildRequestHolder", "()Lcom/android/build/attribution/data/BuildRequestHolder;", "analyticsManager", "Lcom/android/build/attribution/analytics/BuildAttributionAnalyticsManager;", "getAnalyticsManager", "()Lcom/android/build/attribution/analytics/BuildAttributionAnalyticsManager;", "detectBuildType", "request", "intellij.android.build-attribution"})
    private static final class BuildAnalysisContext {
        @NotNull
        private final GradleBuildInvoker.Request currentBuildRequest;
        @NotNull
        private final String buildSessionId;
        @NotNull
        private final CheckedDisposable currentBuildDisposable;
        private boolean eventsProcessingFailedFlag;
        @NotNull
        private final BuildInvocationType currentBuildInvocationType;
        @NotNull
        private final TaskContainer taskContainer;
        @NotNull
        private final PluginContainer pluginContainer;
        @NotNull
        private final BuildEventsAnalyzersProxy analyzersProxy;
        @NotNull
        private final BuildAnalyzersWrapper analyzersWrapper;
        @NotNull
        private final File attributionFileDir;
        @NotNull
        private final BuildRequestHolder buildRequestHolder;
        @NotNull
        private final BuildAttributionAnalyticsManager analyticsManager;

        public BuildAnalysisContext(@NotNull GradleBuildInvoker.Request currentBuildRequest) {
            Intrinsics.checkNotNullParameter((Object)currentBuildRequest, (String)"currentBuildRequest");
            this.currentBuildRequest = currentBuildRequest;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.buildSessionId = string;
            CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable((String)("BuildAnalyzer disposable for " + this.currentBuildRequest.getTaskId()));
            Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
            this.currentBuildDisposable = checkedDisposable;
            this.currentBuildInvocationType = this.detectBuildType(this.currentBuildRequest);
            this.taskContainer = new TaskContainer();
            this.pluginContainer = new PluginContainer();
            this.analyzersProxy = new BuildEventsAnalyzersProxy(this.taskContainer, this.pluginContainer, BuildAnalyzerStorageManager.Companion.getInstance(this.currentBuildRequest.getProject()));
            this.analyzersWrapper = new BuildAnalyzersWrapper(this.analyzersProxy.getBuildAnalyzers(), this.taskContainer, this.pluginContainer);
            this.attributionFileDir = BuildAttributionUtil.getAgpAttributionFileDir(this.currentBuildRequest.getData());
            this.buildRequestHolder = new BuildRequestHolder(this.currentBuildRequest);
            this.analyticsManager = new BuildAttributionAnalyticsManager(this.buildSessionId, this.currentBuildRequest.getProject());
        }

        @NotNull
        public final GradleBuildInvoker.Request getCurrentBuildRequest() {
            return this.currentBuildRequest;
        }

        @NotNull
        public final String getBuildSessionId() {
            return this.buildSessionId;
        }

        @NotNull
        public final CheckedDisposable getCurrentBuildDisposable() {
            return this.currentBuildDisposable;
        }

        public final boolean getEventsProcessingFailedFlag() {
            return this.eventsProcessingFailedFlag;
        }

        public final void setEventsProcessingFailedFlag(boolean bl) {
            this.eventsProcessingFailedFlag = bl;
        }

        @NotNull
        public final BuildInvocationType getCurrentBuildInvocationType() {
            return this.currentBuildInvocationType;
        }

        @NotNull
        public final TaskContainer getTaskContainer() {
            return this.taskContainer;
        }

        @NotNull
        public final PluginContainer getPluginContainer() {
            return this.pluginContainer;
        }

        @NotNull
        public final BuildEventsAnalyzersProxy getAnalyzersProxy() {
            return this.analyzersProxy;
        }

        @NotNull
        public final BuildAnalyzersWrapper getAnalyzersWrapper() {
            return this.analyzersWrapper;
        }

        @NotNull
        public final File getAttributionFileDir() {
            return this.attributionFileDir;
        }

        @NotNull
        public final BuildRequestHolder getBuildRequestHolder() {
            return this.buildRequestHolder;
        }

        @NotNull
        public final BuildAttributionAnalyticsManager getAnalyticsManager() {
            return this.analyticsManager;
        }

        private final BuildInvocationType detectBuildType(GradleBuildInvoker.Request request) {
            return ConfigurationCacheTestBuildFlowRunner.Companion.getInstance(request.getProject()).isTestConfigurationCacheBuild(request) ? BuildInvocationType.CONFIGURATION_CACHE_TRIAL : (request.getGradleTasks().contains("checkJetifier") ? BuildInvocationType.CHECK_JETIFIER : BuildInvocationType.REGULAR_BUILD);
        }
    }
}

