/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.annotations.concurrency.Slow;
import com.android.build.attribution.AbstractBuildAnalysisResult;
import com.android.build.attribution.BuildAnalysisResults;
import com.android.build.attribution.BuildAnalyzerSettings;
import com.android.build.attribution.BuildAnalyzerStorageDescriptor;
import com.android.build.attribution.BuildAnalyzerStorageFileManager;
import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.BuildDescriptor;
import com.android.build.attribution.BuildDescriptorImpl;
import com.android.build.attribution.BuildDescriptorStorageService;
import com.android.build.attribution.FailureResult;
import com.android.build.attribution.HistoricBuildAnalysisResults;
import com.android.build.attribution.analyzers.AlwaysRunTasksAnalyzer;
import com.android.build.attribution.analyzers.AnnotationProcessorsAnalyzer;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.CheckJetifierResultData;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityProjectResult;
import com.android.build.attribution.analyzers.CriticalPathAnalyzer;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.analyzers.GarbageCollectionAnalyzer;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerResult;
import com.android.build.attribution.analyzers.ProjectConfigurationAnalyzer;
import com.android.build.attribution.analyzers.TaskCategoryWarningsAnalyzer;
import com.android.build.attribution.analyzers.TasksConfigurationIssuesAnalyzer;
import com.android.build.attribution.data.BuildRequestHolder;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.containers.ConcurrentList;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0003J \u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\tH\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u000bH\u0016J\f\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0016J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001a0*2\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010-\u001a\u00020 2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0017J\u0016\u00100\u001a\b\u0012\u0004\u0012\u0002010*2\u0006\u0010,\u001a\u00020\u0019H\u0016J\b\u00102\u001a\u000203H\u0017J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u001eH\u0016J\f\u00107\u001a\u0006\u0012\u0002\b\u00030*H\u0016J\u0010\u00108\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0019H\u0007J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020 H\u0002J\f\u0010?\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u001a\u0010@\u001a\u0006\u0012\u0002\b\u00030*2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002050BH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/build/attribution/BuildAnalyzerStorageManagerImpl;", "Lcom/android/build/attribution/BuildAnalyzerStorageManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildResults", "Lcom/android/build/attribution/AbstractBuildAnalysisResult;", "cachedCheckJetifierResultData", "Lcom/android/build/attribution/analyzers/CheckJetifierResultData;", "fileManager", "Lcom/android/build/attribution/BuildAnalyzerStorageFileManager;", "getFileManager", "()Lcom/android/build/attribution/BuildAnalyzerStorageFileManager;", "descriptors", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/android/build/attribution/BuildDescriptorImpl;", "getDescriptors$annotations", "()V", "getDescriptors", "()Lcom/intellij/util/containers/ConcurrentList;", "inMemoryResults", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/build/attribution/BuildAnalysisResults;", "workingWithDiskLock", "Ljava/util/concurrent/locks/ReentrantLock;", "storageDescriptor", "Lcom/android/build/attribution/BuildAnalyzerStorageDescriptor;", "notifyDataListeners", "", "createBuildResultsObject", "analyzersProxy", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "buildSessionID", "requestHolder", "Lcom/android/build/attribution/data/BuildRequestHolder;", "getLatestBuildAnalysisResults", "getCachedCheckJetifierResultData", "clearBuildResultsStored", "Ljava/util/concurrent/Future;", "storeNewBuildResults", "buildID", "recordNewFailure", "failureType", "Lcom/android/build/attribution/FailureResult$Type;", "getHistoricBuildResultByID", "Lcom/android/build/attribution/HistoricBuildAnalysisResults;", "getCurrentBuildHistoryDataSize", "", "getNumberOfBuildResultsStored", "", "getStorageDescriptor", "onSettingsChange", "deleteHistoricBuildResultByID", "getListOfHistoricBuildDescriptors", "", "Lcom/android/build/attribution/BuildDescriptor;", "hasData", "", "updateDescriptor", "deleteOldRecords", "deleteFirstNRecords", "lazy", "Lkotlin/Function0;", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAnalyzerStorageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAnalyzerStorageManagerImpl.kt\ncom/android/build/attribution/BuildAnalyzerStorageManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n295#2,2:249\n2423#2,14:251\n*S KotlinDebug\n*F\n+ 1 BuildAnalyzerStorageManagerImpl.kt\ncom/android/build/attribution/BuildAnalyzerStorageManagerImpl\n*L\n196#1:249,2\n242#1:251,14\n*E\n"})
public final class BuildAnalyzerStorageManagerImpl
implements BuildAnalyzerStorageManager {
    @NotNull
    private final Project project;
    @Nullable
    private volatile AbstractBuildAnalysisResult buildResults;
    @Nullable
    private volatile CheckJetifierResultData cachedCheckJetifierResultData;
    @NotNull
    private final BuildAnalyzerStorageFileManager fileManager;
    @NotNull
    private final ConcurrentList<BuildDescriptorImpl> descriptors;
    @NotNull
    private final ConcurrentHashMap<String, BuildAnalysisResults> inMemoryResults;
    @NotNull
    private final ReentrantLock workingWithDiskLock;
    @NotNull
    private final BuildAnalyzerStorageDescriptor storageDescriptor;

    public BuildAnalyzerStorageManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        File file = ProjectUtil.getProjectDataPath((Project)this.project, (String)"build-analyzer-history-data").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        this.fileManager = new BuildAnalyzerStorageFileManager(file);
        this.descriptors = BuildDescriptorStorageService.Companion.getInstance(this.project).getState().getDescriptors();
        this.inMemoryResults = new ConcurrentHashMap();
        this.workingWithDiskLock = new ReentrantLock();
        this.storageDescriptor = new BuildAnalyzerStorageDescriptor(this.fileManager.getTotalFilesSize(), (AtomicProperty<Integer>)new AtomicProperty((Object)this.getNumberOfBuildResultsStored()));
        this.onSettingsChange();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BuildAnalyzerStorageFileManager getFileManager() {
        return this.fileManager;
    }

    @NotNull
    public final ConcurrentList<BuildDescriptorImpl> getDescriptors() {
        return this.descriptors;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDescriptors$annotations() {
    }

    @Slow
    private final synchronized void notifyDataListeners() {
        ((BuildAnalyzerStorageManager.Listener)this.project.getMessageBus().syncPublisher(BuildAnalyzerStorageManager.Companion.getDATA_IS_READY_TOPIC())).newDataAvailable();
    }

    private final BuildAnalysisResults createBuildResultsObject(BuildEventsAnalyzersProxy analyzersProxy, String buildSessionID, BuildRequestHolder requestHolder) {
        GradleBuildInvoker.Request.RequestData requestData = requestHolder.getBuildRequest().getData();
        AnnotationProcessorsAnalyzer.Result result2 = (AnnotationProcessorsAnalyzer.Result)analyzersProxy.getAnnotationProcessorsAnalyzer().getResult();
        AlwaysRunTasksAnalyzer.Result result3 = (AlwaysRunTasksAnalyzer.Result)analyzersProxy.getAlwaysRunTasksAnalyzer().getResult();
        CriticalPathAnalyzer.Result result4 = (CriticalPathAnalyzer.Result)analyzersProxy.getCriticalPathAnalyzer().getResult();
        GarbageCollectionAnalyzer.Result result5 = (GarbageCollectionAnalyzer.Result)analyzersProxy.getGarbageCollectionAnalyzer().getResult();
        ProjectConfigurationAnalyzer.Result result6 = (ProjectConfigurationAnalyzer.Result)analyzersProxy.getProjectConfigurationAnalyzer().getResult();
        TasksConfigurationIssuesAnalyzer.Result result7 = (TasksConfigurationIssuesAnalyzer.Result)analyzersProxy.getTasksConfigurationIssuesAnalyzer().getResult();
        ConfigurationCachingCompatibilityProjectResult configurationCachingCompatibilityProjectResult = (ConfigurationCachingCompatibilityProjectResult)analyzersProxy.getConfigurationCachingCompatibilityAnalyzer().getResult();
        JetifierUsageAnalyzerResult jetifierUsageAnalyzerResult = (JetifierUsageAnalyzerResult)analyzersProxy.getJetifierUsageAnalyzer().getResult();
        Object object = analyzersProxy.getDownloadsAnalyzer();
        if (object == null || (object = (DownloadsAnalyzer.Result)((BaseAnalyzer)object).getResult()) == null) {
            object = DownloadsAnalyzer.AnalyzerIsDisabled.INSTANCE;
        }
        return new BuildAnalysisResults(requestData, result2, result3, result4, result5, result6, result7, configurationCachingCompatibilityProjectResult, jetifierUsageAnalyzerResult, (DownloadsAnalyzer.Result)object, (TaskCategoryWarningsAnalyzer.Result)analyzersProxy.getTaskCategoryWarningsAnalyzer().getResult(), buildSessionID, analyzersProxy.getTaskContainer().getAllTasks(), analyzersProxy.getPluginContainer().getAllPlugins());
    }

    @Override
    @NotNull
    public AbstractBuildAnalysisResult getLatestBuildAnalysisResults() {
        if (this.hasData()) {
            AbstractBuildAnalysisResult abstractBuildAnalysisResult = this.buildResults;
            Intrinsics.checkNotNull((Object)abstractBuildAnalysisResult);
            return abstractBuildAnalysisResult;
        }
        throw new IllegalStateException("Storage Manager does not have data to return.");
    }

    @Override
    @Nullable
    public CheckJetifierResultData getCachedCheckJetifierResultData() {
        return this.cachedCheckJetifierResultData;
    }

    @Override
    @NotNull
    public Future<?> clearBuildResultsStored() {
        return this.deleteFirstNRecords((Function0<Integer>)((Function0)() -> BuildAnalyzerStorageManagerImpl.clearBuildResultsStored$lambda$0(this)));
    }

    @Override
    @NotNull
    public Future<BuildAnalysisResults> storeNewBuildResults(@NotNull BuildEventsAnalyzersProxy analyzersProxy, @NotNull String buildID, @NotNull BuildRequestHolder requestHolder) {
        Intrinsics.checkNotNullParameter((Object)analyzersProxy, (String)"analyzersProxy");
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        Intrinsics.checkNotNullParameter((Object)requestHolder, (String)"requestHolder");
        BuildAnalysisResults buildResults = this.createBuildResultsObject(analyzersProxy, buildID, requestHolder);
        this.buildResults = buildResults;
        this.cachedCheckJetifierResultData = analyzersProxy.getJetifierUsageAnalyzer().getCheckJetifierResultData();
        this.notifyDataListeners();
        if (((Boolean)StudioFlags.BUILD_ANALYZER_HISTORY.get()).booleanValue()) {
            this.descriptors.add((Object)new BuildDescriptorImpl(buildResults.getBuildSessionID(), buildResults.getBuildFinishedTimestamp(), buildResults.getTotalBuildTimeMs()));
            this.updateDescriptor();
            ((Map)this.inMemoryResults).put(buildResults.getBuildSessionID(), buildResults);
            Function0 onBackground = () -> BuildAnalyzerStorageManagerImpl.storeNewBuildResults$lambda$0(this, buildResults);
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> BuildAnalyzerStorageManagerImpl.storeNewBuildResults$lambda$1(onBackground));
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"executeOnPooledThread(...)");
            return future2;
        }
        CompletableFuture<BuildAnalysisResults> completableFuture = CompletableFuture.completedFuture(buildResults);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @Slow
    public void recordNewFailure(@NotNull String buildID, @NotNull FailureResult.Type failureType) {
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        Intrinsics.checkNotNullParameter((Object)((Object)failureType), (String)"failureType");
        this.buildResults = new FailureResult(buildID, failureType);
        this.notifyDataListeners();
    }

    @Override
    @NotNull
    public Future<HistoricBuildAnalysisResults> getHistoricBuildResultByID(@NotNull String buildID) {
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        BuildAnalysisResults buildAnalysisResults = this.inMemoryResults.get(buildID);
        if (buildAnalysisResults != null) {
            BuildAnalysisResults it = buildAnalysisResults;
            boolean bl = false;
            CompletableFuture<HistoricBuildAnalysisResults> completableFuture = CompletableFuture.completedFuture(it.toHistoricalResults());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        Function0 onBackground = () -> BuildAnalyzerStorageManagerImpl.getHistoricBuildResultByID$lambda$1(this, buildID);
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> BuildAnalyzerStorageManagerImpl.getHistoricBuildResultByID$lambda$2(onBackground));
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"executeOnPooledThread(...)");
        return future2;
    }

    @Override
    @Slow
    public long getCurrentBuildHistoryDataSize() {
        return this.fileManager.getCurrentBuildHistoryDataSize();
    }

    @Override
    public int getNumberOfBuildResultsStored() {
        return this.descriptors.size();
    }

    @Override
    @NotNull
    public BuildAnalyzerStorageDescriptor getStorageDescriptor() {
        return this.storageDescriptor;
    }

    @Override
    @NotNull
    public Future<?> onSettingsChange() {
        return this.deleteOldRecords();
    }

    @VisibleForTesting
    public final void deleteHistoricBuildResultByID(@NotNull String buildID) {
        block2: {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
                Iterable $this$firstOrNull$iv = this.getListOfHistoricBuildDescriptors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BuildDescriptor it = (BuildDescriptor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getBuildSessionID(), (Object)buildID)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            BuildDescriptor buildDescriptor = v0;
            if (buildDescriptor == null) break block2;
            BuildDescriptor result2 = buildDescriptor;
            boolean bl = false;
            TypeIntrinsics.asMutableCollection((Object)((Collection)this.descriptors)).remove(result2);
            this.updateDescriptor();
            this.inMemoryResults.remove(buildID);
            this.fileManager.deleteHistoricBuildResultByID(buildID);
        }
    }

    @Override
    @NotNull
    public Set<BuildDescriptor> getListOfHistoricBuildDescriptors() {
        Set result2 = new LinkedHashSet();
        Iterator it = this.descriptors.iterator();
        while (true) {
            BuildDescriptor x = null;
            try {
                Object e = it.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                x = (BuildDescriptor)e;
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            result2.add(x);
        }
        return result2;
    }

    @Override
    public boolean hasData() {
        return this.buildResults != null;
    }

    private final void updateDescriptor() {
        this.storageDescriptor.getNumberOfBuildResultsStored().set((Object)this.getNumberOfBuildResultsStored());
    }

    private final Future<?> deleteOldRecords() {
        return this.deleteFirstNRecords((Function0<Integer>)((Function0)() -> BuildAnalyzerStorageManagerImpl.deleteOldRecords$lambda$0(this)));
    }

    private final Future<?> deleteFirstNRecords(Function0<Integer> lazy) {
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> BuildAnalyzerStorageManagerImpl.deleteFirstNRecords$lambda$0(this, lazy));
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"executeOnPooledThread(...)");
        return future2;
    }

    private static final int clearBuildResultsStored$lambda$0(BuildAnalyzerStorageManagerImpl this$0) {
        return this$0.descriptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BuildAnalysisResults storeNewBuildResults$lambda$0(BuildAnalyzerStorageManagerImpl this$0, BuildAnalysisResults $buildResults) {
        Lock lock = this$0.workingWithDiskLock;
        lock.lock();
        try {
            boolean bl = false;
            this$0.fileManager.storeBuildResultsInFile($buildResults);
            BuildAnalysisResults buildAnalysisResults = this$0.inMemoryResults.remove($buildResults.getBuildSessionID());
        }
        finally {
            lock.unlock();
        }
        this$0.deleteOldRecords().get();
        return $buildResults;
    }

    private static final BuildAnalysisResults storeNewBuildResults$lambda$1(Function0 $tmp0) {
        return (BuildAnalysisResults)$tmp0.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HistoricBuildAnalysisResults getHistoricBuildResultByID$lambda$1(BuildAnalyzerStorageManagerImpl this$0, String $buildID) {
        HistoricBuildAnalysisResults historicBuildAnalysisResults;
        Lock lock = this$0.workingWithDiskLock;
        lock.lock();
        try {
            boolean bl = false;
            historicBuildAnalysisResults = this$0.fileManager.getHistoricBuildResultByID($buildID);
        }
        finally {
            lock.unlock();
        }
        return historicBuildAnalysisResults;
    }

    private static final HistoricBuildAnalysisResults getHistoricBuildResultByID$lambda$2(Function0 $tmp0) {
        return (HistoricBuildAnalysisResults)$tmp0.invoke();
    }

    private static final int deleteOldRecords$lambda$0(BuildAnalyzerStorageManagerImpl this$0) {
        return this$0.descriptors.size() - BuildAnalyzerSettings.Companion.getInstance(this$0.project).getState().getMaxNumberOfBuildsStored();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void deleteFirstNRecords$lambda$0(BuildAnalyzerStorageManagerImpl this$0, Function0 $lazy) {
        Lock lock = this$0.workingWithDiskLock;
        lock.lock();
        try {
            boolean bl = false;
            int n = ((Number)$lazy.invoke()).intValue();
            for (int i = 0; i < n; ++i) {
                BuildDescriptor descriptor2;
                Object v0;
                int it = i;
                boolean bl2 = false;
                Iterable $this$minByOrNull$iv = this$0.getListOfHistoricBuildDescriptors();
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        BuildDescriptor it2 = (BuildDescriptor)minElem$iv;
                        boolean bl3 = false;
                        long minValue$iv = it2.getBuildFinishedTimestamp();
                        do {
                            Object e$iv = iterator$iv.next();
                            BuildDescriptor it3 = (BuildDescriptor)e$iv;
                            $i$a$-minByOrNull-BuildAnalyzerStorageManagerImpl$deleteFirstNRecords$1$1$1$1 = false;
                            long v$iv = it3.getBuildFinishedTimestamp();
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                if ((BuildDescriptor)v0 == null) continue;
                boolean bl4 = false;
                this$0.deleteHistoricBuildResultByID(descriptor2.getBuildSessionID());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }
}

