/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.build.attribution.BuildAnalyzerNotificationManagerKt;
import com.android.build.attribution.WarningType;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\u0016\u0010\u0011\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/attribution/BuildAnalyzerNotificationManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "uiAnalytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;)V", "alreadyNotifiedAbout", "", "Lcom/android/build/attribution/WarningType;", "showToolWindowBalloonIfNeeded", "", "reportUiData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "viewDetailsLinkClickListener", "Lkotlin/Function0;", "showAsNotification", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAnalyzerNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAnalyzerNotificationManager.kt\ncom/android/build/attribution/BuildAnalyzerNotificationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n774#2:113\n865#2,2:114\n*S KotlinDebug\n*F\n+ 1 BuildAnalyzerNotificationManager.kt\ncom/android/build/attribution/BuildAnalyzerNotificationManager\n*L\n44#1:113\n44#1:114,2\n*E\n"})
public final class BuildAnalyzerNotificationManager {
    @NotNull
    private final Project project;
    @NotNull
    private final BuildAttributionUiAnalytics uiAnalytics;
    @NotNull
    private final Set<WarningType> alreadyNotifiedAbout;

    public BuildAnalyzerNotificationManager(@NotNull Project project, @NotNull BuildAttributionUiAnalytics uiAnalytics) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiAnalytics, (String)"uiAnalytics");
        this.project = project;
        this.uiAnalytics = uiAnalytics;
        this.alreadyNotifiedAbout = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    public final void showToolWindowBalloonIfNeeded(@NotNull BuildAttributionReportUiData reportUiData, @NotNull Function0<Unit> viewDetailsLinkClickListener) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reportUiData, (String)"reportUiData");
        Intrinsics.checkNotNullParameter(viewDetailsLinkClickListener, (String)"viewDetailsLinkClickListener");
        BuildAnalyzerNotificationManagerKt.migrateSetting(this.project);
        if (BuildAnalyzerNotificationManagerKt.access$isBuildAnalyzerSpecialBuild(reportUiData)) {
            return;
        }
        Iterable $this$filter$iv = BuildAnalyzerNotificationManagerKt.access$warningTypes(reportUiData);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WarningType it = (WarningType)element$iv$iv;
            boolean bl = false;
            if (!it.getTriggerNotification()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List warningTypesInCurrentBuild = (List)destination$iv$iv;
        if (!this.alreadyNotifiedAbout.containsAll(warningTypesInCurrentBuild)) {
            this.showAsNotification(viewDetailsLinkClickListener);
            this.alreadyNotifiedAbout.addAll(warningTypesInCurrentBuild);
        }
    }

    private final void showAsNotification(Function0<Unit> viewDetailsLinkClickListener) {
        NotificationGroupManager.getInstance().getNotificationGroup("Build Analyzer").createNotification("Build Analyzer detected new build performance issues", NotificationType.WARNING).addAction(new AnAction(viewDetailsLinkClickListener){
            final /* synthetic */ Function0<Unit> $viewDetailsLinkClickListener;
            {
                this.$viewDetailsLinkClickListener = $viewDetailsLinkClickListener;
                super("Review to improve build performance");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$viewDetailsLinkClickListener.invoke();
            }
        }).notify(this.project);
        this.uiAnalytics.toolWindowBalloonShown();
    }
}

