/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.lang.ContextFreeResolveUtil;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    public OCDebuggerTypesHelper(CidrDebugProcess process) {
        super(process);
    }

    @Nullable
    protected OCReference createReferenceFromText(@NotNull LLValue var, @NotNull PsiElement context) {
        if (var == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(1);
        }
        return OCElementFactory.referenceElementFromText((String)var.getName(), (PsiElement)context, (boolean)false);
    }

    @Nullable
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue var) {
        PsiElement context;
        if (position == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(2);
        }
        if (var == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(3);
        }
        if ((context = this.getContextElement(position)) == null) {
            return null;
        }
        return OCThisSelfSuperSymbol.tryResolveThisSelfSuper((String)var.getName(), (PsiElement)context, (OCResolveContext)OCResolveContext.forPsi((PsiElement)context)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiElement resolveToDeclaration(@Nullable XSourcePosition position, @NotNull LLValue var) {
        if (var == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(4);
        }
        ExternalResolveUtils.prohibitClangResolve();
        try {
            PsiElement psiElement = super.resolveToDeclaration(position, var);
            return psiElement;
        }
        finally {
            ExternalResolveUtils.allowClangResolve();
        }
    }

    @Nullable
    protected OCType resolveType(CidrPhysicalValue value, Class ... klass) {
        XSourcePosition pos = value.getSourcePosition();
        if (pos == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProcess.getProject()).findFile(pos.getFile());
        String type = value.getVar().getType();
        return this.doResolveType(pos, type, psiFile, klass);
    }

    @Nullable
    private OCType doResolveType(@NotNull XSourcePosition pos, @NotNull String typeName, PsiFile psiFile, Class ... klass) {
        if (pos == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(5);
        }
        if (typeName == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(6);
        }
        PsiElement element = this.getContextElement(pos);
        return OCDebuggerTypesHelper.doResolveType(typeName, psiFile, element, klass);
    }

    @Nullable
    private static OCType doResolveType(@NotNull String typeName, PsiFile psiFile, PsiElement context, Class ... klass) {
        OCResolveContext resolveContext;
        if (typeName == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(7);
        }
        if (context == null) {
            return null;
        }
        OCTypeElement exp = OCElementFactory.typeElementFromTextOrNull((String)typeName, (PsiElement)context, (boolean)false);
        if (exp == null) {
            return null;
        }
        OCType expType = exp.getType();
        OCType resolved = expType.resolve(resolveContext = OCResolveContext.forPsi((PsiElement)context));
        if (resolved instanceof OCReferenceType) {
            OCReferenceType referenceType = (OCReferenceType)resolved;
            List symbols = referenceType.getReference(psiFile).resolveToSymbols(resolveContext);
            for (OCSymbol symbol : symbols) {
                OCSymbol definitionSymbol = symbol.getDefinitionSymbol(context.getProject());
                if (definitionSymbol == null || !OCDebuggerTypesHelper.isInstanceOf(definitionSymbol.getResolvedType(resolveContext), klass)) continue;
                return definitionSymbol.getResolvedType(resolveContext);
            }
            for (OCSymbol symbol : symbols) {
                OCType type = symbol.getResolvedType(resolveContext);
                if (!OCDebuggerTypesHelper.isInstanceOf(type, klass)) continue;
                return type;
            }
        } else if (OCDebuggerTypesHelper.isInstanceOf(resolved, klass)) {
            return resolved;
        }
        return null;
    }

    private static boolean isInstanceOf(OCType type, Class[] klass) {
        for (Class each : klass) {
            if (!each.isInstance(type)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Integer getSizeOf(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(8);
        }
        return (Integer)ReadAction.compute(() -> {
            XSourcePosition pos;
            if (this.myProcess.getProject().isDisposed()) {
                return null;
            }
            OCType type = this.resolveType(value, OCType.class);
            if (type != null && (pos = value.getSourcePosition()) != null) {
                Project project = this.myProcess.getProject();
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(pos.getFile());
                return type.getSizeInBytes(psiFile, null, project);
            }
            return null;
        });
    }

    public XSourcePosition computeSourcePosition(@NotNull CidrMemberValue value) {
        OCDeclaratorSymbol field;
        OCType type;
        if (value == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(9);
        }
        if ((type = this.resolveType(value.getParent(), OCPointerType.class, OCStructType.class, OCReferenceType.class, OCObjectType.class)) == null) {
            return null;
        }
        OCType terminalType = type.getTerminalType();
        if (terminalType instanceof OCObjectType) {
            OCInstanceVariableSymbol var = (OCInstanceVariableSymbol)((OCObjectType)terminalType).findMember(value.getVar().getName(), OCInstanceVariableSymbol.class);
            if (var != null) {
                return XDebuggerUtil.getInstance().createPositionByOffset(var.getContainingFile(), var.getOffset());
            }
        } else if (terminalType instanceof OCStructType && (field = ((OCStructType)terminalType).findField(value.getVar().getName())) != null) {
            return XDebuggerUtil.getInstance().createPositionByOffset(field.getContainingFile(), field.getOffset());
        }
        return null;
    }

    @Nullable
    public PsiElement getContextElement(@Nullable XSourcePosition sourcePosition) {
        return OCDebuggerTypesHelper.getContextElement(sourcePosition, this.myProcess.getProject());
    }

    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value, @Nullable String dynamicTypeName) {
        OCMemberSymbol symbol;
        if (value == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(10);
        }
        if ((symbol = ContextFreeResolveUtil.resolveToProperty((String)dynamicTypeName, (String)value.getName(), (Project)this.myProcess.getProject())) == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(symbol.getContainingFile(), symbol.getOffset());
    }

    @Contract(value="null, _ -> null")
    public static PsiElement getContextElement(@Nullable XSourcePosition sourcePosition, @NotNull Project project) {
        PsiElement result;
        if (project == null) {
            OCDebuggerTypesHelper.$$$reportNull$$$0(11);
        }
        if ((result = OCPsiFile.tryGetElementFromOCFile((PsiElement)CidrDebuggerTypesHelper.getContextElement((XSourcePosition)sourcePosition, (Project)project))) != null && result.getParent() instanceof OCForStatement) {
            result = ((OCForStatement)result.getParent()).getInitializer();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/OCDebuggerTypesHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferenceFromText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitContextVariable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveToDeclaration";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doResolveType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getSizeOf";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "computeSourcePosition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveProperty";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

