/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrPotentialTestHolderRootsProvider;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrTestWithScopeElementsFramework<TEST_OBJECT extends CidrTestScopeElement>
extends CidrTestFrameworkBase<TEST_OBJECT>
implements CidrTestRunConfigurationLanguageSupport {
    protected final Class<? extends PsiElement>[] myTestHolderClassWithoutMacroCall;
    protected final boolean myCanHaveMacroAsTest;
    protected final boolean myCanHaveNamespaceAsTest;
    protected final boolean myCanHaveClassAsTest;
    protected final boolean myCanHaveFunctionAsTest;
    protected final boolean myCanHaveDeclaratorAsTest;
    protected OCSymbolKind[] myDeclaratorKinds;
    protected final Key<Map<String, TEST_OBJECT>> myObjects;
    protected final Key<Boolean> myIsDirty;
    protected final Key<Boolean> myIsProcessing;
    protected final Key<Boolean> myIsProcessingCanceled;
    private final Key<Pair<TEST_OBJECT, Long>> myTestScopeInElementWithVersion;

    @SafeVarargs
    protected CidrTestWithScopeElementsFramework(@NlsSafe @NotNull String testFrameworkId, Class<? extends PsiElement> ... testHolderClass) {
        if (testFrameworkId == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(0);
        }
        if (testHolderClass == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(1);
        }
        super(testFrameworkId, testHolderClass);
        this.myDeclaratorKinds = new OCSymbolKind[]{OCSymbolKind.GLOBAL_VARIABLE};
        this.myObjects = Key.create((String)(this.myFrameworkId + " objects"));
        this.myIsDirty = Key.create((String)(this.myFrameworkId + " dirty"));
        this.myIsProcessing = Key.create((String)(this.myFrameworkId + " processing"));
        this.myIsProcessingCanceled = Key.create((String)(this.myFrameworkId + " processing canceled"));
        this.myTestScopeInElementWithVersion = Key.create((String)(this.myFrameworkId + "Test Scope With Version"));
        this.myTestHolderClassWithoutMacroCall = ContainerUtil.filter((Collection)this.myTestHolderClass, clazz -> !clazz.equals(OCMacroCall.class)).toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
        this.myCanHaveMacroAsTest = this.myTestHolderClass.contains(OCMacroCall.class);
        this.myCanHaveNamespaceAsTest = this.myTestHolderClass.contains(OCCppNamespace.class);
        this.myCanHaveClassAsTest = this.myTestHolderClass.contains(OCStruct.class);
        this.myCanHaveFunctionAsTest = this.myTestHolderClass.contains(OCFunctionDefinition.class);
        this.myCanHaveDeclaratorAsTest = this.myTestHolderClass.contains(OCDeclarator.class);
    }

    @TestOnly
    @NotNull
    public Map<String, TEST_OBJECT> collectTestObjects(@NotNull PsiFile file) {
        Map testObjs;
        HashMap<VirtualFile, CidrTestInfoForFile> indexedTests;
        CidrTestInfoForFile testInfo;
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(2);
        }
        if ((testInfo = (indexedTests = this.getIndexedTests(file.getProject())).get(file.getVirtualFile())) != null && (testObjs = (Map)this.myObjects.get((UserDataHolder)testInfo)) != null) {
            Map map = testObjs;
            if (map == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(3);
            }
            return map;
        }
        Map map = Collections.emptyMap();
        if (map == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(4);
        }
        return map;
    }

    public final Class<? extends PsiElement>[] getTestHolderClassWithoutMacroCall() {
        return this.myTestHolderClassWithoutMacroCall;
    }

    @Override
    public void prepareTestIndexLookup(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(5);
        }
        this.getTestObjects(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, TEST_OBJECT> getOrCreateObjects(@NotNull PsiFile actualFile, @NotNull CidrTestInfoForFile infoForFile) {
        Object object;
        CidrTestListUpdater updater;
        Map objects;
        block42: {
            boolean isDirty;
            if (actualFile == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(6);
            }
            if (infoForFile == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(7);
            }
            if (infoForFile.getFrameworkVersion() == CidrTestFrameworkVersion.NOT_AVAILABLE) {
                Map map = Collections.emptyMap();
                if (map == null) {
                    CidrTestWithScopeElementsFramework.$$$reportNull$$$0(8);
                }
                return map;
            }
            objects = (Map)this.myObjects.get((UserDataHolder)infoForFile);
            boolean bl = isDirty = this.myIsDirty.get((UserDataHolder)infoForFile) == Boolean.TRUE;
            if (objects != null && !isDirty) {
                Map map = objects;
                if (map == null) {
                    CidrTestWithScopeElementsFramework.$$$reportNull$$$0(9);
                }
                return map;
            }
            updater = this.getUpdater(actualFile.getProject());
            if (!OCTestExecution.canWaitInThisThread()) {
                updater.scheduleUpdate(actualFile.getVirtualFile());
                Map map = Objects.requireNonNullElse(objects, Collections.emptyMap());
                if (map == null) {
                    CidrTestWithScopeElementsFramework.$$$reportNull$$$0(10);
                }
                return map;
            }
            CidrTestInfoForFile cidrTestInfoForFile = infoForFile;
            synchronized (cidrTestInfoForFile) {
                Map map;
                boolean first = true;
                while (this.myIsProcessing.get((UserDataHolder)infoForFile) == Boolean.TRUE) {
                    block41: {
                        if (first) {
                            first = false;
                        }
                        ProgressManager.checkCanceled();
                        try {
                            ((Object)((Object)infoForFile)).wait(250L);
                            if (this.myIsProcessingCanceled.get((UserDataHolder)infoForFile) != Boolean.TRUE) break block41;
                            ProgressManager.checkCanceled();
                            break block42;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.myIsProcessing.get((UserDataHolder)infoForFile) == Boolean.TRUE) continue;
                    map = Objects.requireNonNullElse((Map)this.myObjects.get((UserDataHolder)infoForFile), Collections.emptyMap());
                    // MONITOREXIT @DISABLED, blocks:[0, 10, 27] lbl41 : MonitorExitStatement: MONITOREXIT : var6_6
                }
                {
                    if (map == null) {
                        CidrTestWithScopeElementsFramework.$$$reportNull$$$0(11);
                    }
                    return map;
                }
                this.myIsProcessing.set((UserDataHolder)infoForFile, (Object)true);
                this.myIsProcessingCanceled.set((UserDataHolder)infoForFile, null);
            }
        }
        try {
            Map<String, TEST_OBJECT> objectsDirectly = this.createTestObjectsDirectly(actualFile);
            Object object2 = infoForFile;
            synchronized (object2) {
                this.myIsDirty.set((UserDataHolder)infoForFile, null);
                this.myObjects.set((UserDataHolder)infoForFile, objectsDirectly);
                updater.incTestInfoVersion();
            }
            object2 = objectsDirectly;
            object = object2;
        }
        catch (ProcessCanceledException e) {
            CidrTestInfoForFile cidrTestInfoForFile = infoForFile;
            synchronized (cidrTestInfoForFile) {
                this.myIsProcessingCanceled.set((UserDataHolder)infoForFile, (Object)Boolean.TRUE);
                updater.incTestInfoVersion();
            }
            updater.scheduleUpdate(actualFile.getVirtualFile());
            throw e;
        }
        catch (IndexNotReadyException e) {
            updater.scheduleUpdate(actualFile.getVirtualFile());
            Map map = Objects.requireNonNullElse(objects, Collections.emptyMap());
            Map map2 = map;
            if (map2 == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(13);
            }
            return map2;
        }
        finally {
            CidrTestInfoForFile cidrTestInfoForFile = infoForFile;
            synchronized (cidrTestInfoForFile) {
                if (this.myIsProcessing.get((UserDataHolder)infoForFile) == Boolean.TRUE) {
                    this.myIsProcessing.set((UserDataHolder)infoForFile, (Object)false);
                    ((Object)((Object)infoForFile)).notifyAll();
                }
            }
        }
        if (object == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(12);
        }
        return object;
    }

    @Override
    protected void initInfo(@NotNull PsiFile file, @NotNull CidrTestInfoForFile newTestInfo) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(14);
        }
        if (newTestInfo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(15);
        }
        this.getOrCreateObjects(file, newTestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyDirty(@NotNull CidrTestInfoForFile dst, @Nullable CidrTestInfoForFile src) {
        if (dst == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(16);
        }
        if (src != null) {
            CidrTestInfoForFile cidrTestInfoForFile = dst;
            synchronized (cidrTestInfoForFile) {
                this.myIsDirty.set((UserDataHolder)dst, (Object)Boolean.TRUE);
                this.myObjects.set((UserDataHolder)dst, (Object)((Map)this.myObjects.get((UserDataHolder)src)));
            }
        }
    }

    @NotNull
    public Map<String, TEST_OBJECT> getTestObjects(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(17);
        }
        Map<String, TEST_OBJECT> map = this.getOrCreateObjects(file, this.getTestInfo(file));
        if (map == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(18);
        }
        return map;
    }

    public void updateTestsListOrScheduleUpdateIfCannotWait(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(19);
        }
        this.getTestObjects(file);
    }

    @Override
    @Nullable
    protected TEST_OBJECT createFileTestObjectIfPossible(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(20);
        }
        CidrTestScopeElement scope = CidrTestScopeElementImpl.createTestScopeElementForFile((PsiFile)file, () -> CidrTestUtil.createFilePattern(this, () -> CidrTestScope.createEmptyTestScope((String)this.getPatternSeparatorInCommandLine()), file, this::shouldAddToFileScope));
        return (TEST_OBJECT)scope;
    }

    protected boolean shouldAddToFileScope(@NotNull CidrTestScopeElement testScopeElement) {
        if (testScopeElement == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(21);
        }
        return testScopeElement.isTest();
    }

    @NotNull
    protected abstract Map<String, TEST_OBJECT> createTestObjectsDirectly(@NotNull PsiFile var1);

    @NonNls
    @NotNull
    public abstract String getProtocolPrefix();

    public CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suite, @Nullable String test) {
        throw new RuntimeException("Not implemented");
    }

    protected TEST_OBJECT getTestObjectFromTestHolder(@NotNull PsiElement maybeTestHolder, @NotNull Set<String> macroNames) {
        if (maybeTestHolder == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(22);
        }
        if (macroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(23);
        }
        Pair pair = (Pair)this.myTestScopeInElementWithVersion.get((UserDataHolder)maybeTestHolder);
        Project project = maybeTestHolder.getProject();
        long modificationCount = this.getPsiFileVersion(maybeTestHolder.getContainingFile());
        if (pair != null && (Long)pair.second == modificationCount) {
            return (TEST_OBJECT)((CidrTestScopeElement)pair.first);
        }
        TEST_OBJECT ret = null;
        boolean saveResultToCache = false;
        if (this.isTestMacroCandidate(maybeTestHolder, macroNames)) {
            ret = this.findTestObjectFromMacro(maybeTestHolder, macroNames);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveNamespaceAsTest && maybeTestHolder instanceof OCCppNamespace) {
            ret = this.extractTestObject(((OCCppNamespace)maybeTestHolder).getSymbol(), project, OCSymbolKind.NAMESPACE);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveClassAsTest && maybeTestHolder instanceof OCStruct) {
            ret = this.extractTestObject(((OCStruct)maybeTestHolder).getSymbol(), project, OCSymbolKind.STRUCT);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveFunctionAsTest && maybeTestHolder instanceof OCFunctionDefinition) {
            ret = this.extractTestObject((OCSymbol)((OCFunctionDefinition)maybeTestHolder).getSymbol(), project, OCSymbolKind.FUNCTION_DECLARATION);
            saveResultToCache = true;
        }
        if (ret == null && this.myCanHaveDeclaratorAsTest && maybeTestHolder instanceof OCDeclarator) {
            ret = this.extractTestObject(((OCDeclarator)maybeTestHolder).getSymbol(), project, this.myDeclaratorKinds);
            saveResultToCache = true;
        }
        if (saveResultToCache) {
            this.cacheResultForTestHolder(maybeTestHolder, ret, modificationCount);
        }
        return ret;
    }

    protected long getPsiFileVersion(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(24);
        }
        CidrTestInfoForFile info = this.getTestInfo(psiFile);
        long version = info.getFileVersion();
        if (this.myIsDirty.get((UserDataHolder)info) == Boolean.TRUE) {
            version *= -1L;
        }
        return version;
    }

    protected void cacheResultForTestHolder(@NotNull PsiElement maybeTestHolder, @Nullable TEST_OBJECT ret) {
        if (maybeTestHolder == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(25);
        }
        this.cacheResultForTestHolder(maybeTestHolder, ret, this.getFileVersion(maybeTestHolder.getContainingFile()));
    }

    protected void cacheResultForTestHolder(@NotNull PsiElement maybeTestHolder, @Nullable TEST_OBJECT ret, long version) {
        if (maybeTestHolder == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(26);
        }
        this.myTestScopeInElementWithVersion.set((UserDataHolder)maybeTestHolder, (Object)Pair.create(ret, (Object)version));
    }

    @Contract(value="null, _, _ -> null")
    protected TEST_OBJECT extractTestObject(@Nullable OCSymbol symbol, @NotNull Project project, OCSymbolKind ... kinds) {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(27);
        }
        if (kinds == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(28);
        }
        if (symbol == null) {
            return null;
        }
        PsiFile file = symbol.getContainingPsiFile(project);
        if (file != null && this.isAvailable(file)) {
            for (OCSymbolKind canBe : kinds) {
                if (symbol.getKind() != canBe) continue;
                OCResolveContext context = OCResolveContext.forSymbol((OCSymbol)symbol, (Project)project);
                String key = this.getTestObjectKeyForSymbol(symbol, context);
                return (TEST_OBJECT)((CidrTestScopeElement)this.getTestObjects(file).get(key));
            }
        }
        return null;
    }

    @Nullable
    protected String getTestObjectKeyForSymbol(@NotNull OCSymbol symbol, OCResolveContext context) {
        if (symbol == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(29);
        }
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return null;
        }
        return CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)symbol, context);
    }

    @Contract(value="null, null, _, _, _ -> false")
    protected boolean standardProbe(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Class<?> clazz, @NotNull Project project, OCSymbolKind ... symbolKind) {
        if (clazz == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(30);
        }
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(31);
        }
        if (symbolKind == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(32);
        }
        if (symbol == null && clazz.isInstance(element)) {
            symbol = ((OCSymbolDeclarator)element).getSymbol();
        }
        return this.extractTestObject(symbol, project, symbolKind) != null;
    }

    protected TEST_OBJECT findTestObjectFromMacro(@NotNull PsiElement maybeMacro, @NotNull Set<String> testMacroNames) {
        if (maybeMacro == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(33);
        }
        if (testMacroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(34);
        }
        Ref ref = new Ref();
        Ref psiPreviouslyProcessed = new Ref();
        long macroCallOffset = ((OCMacroCall)maybeMacro).getComplexOffset();
        ((OCMacroCall)maybeMacro).processExpansionLeaves(leaf -> {
            OCElement testHolder = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)leaf, (Class[])this.myTestHolderClassWithoutMacroCall);
            if (testHolder != null && testHolder.getComplexOffset() > macroCallOffset && psiPreviouslyProcessed.get() != testHolder) {
                psiPreviouslyProcessed.set((Object)testHolder);
                TEST_OBJECT ret = this.getTestObjectFromTestHolder((PsiElement)testHolder, testMacroNames);
                if (ret != null) {
                    ref.set(ret);
                    return false;
                }
            }
            return true;
        });
        return (TEST_OBJECT)((CidrTestScopeElement)ref.get());
    }

    @Contract(pure=true)
    public boolean isTestMacroCandidate(@NotNull PsiElement element, @NotNull Set<String> testMacroNames) {
        if (element == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(35);
        }
        if (testMacroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(36);
        }
        return element instanceof OCMacroCall;
    }

    @Nullable
    public TEST_OBJECT findTestObject(@NotNull String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope) throws IndexNotReadyException {
        if (pathToFind == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(37);
        }
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(38);
        }
        Ref result = new Ref();
        this.consumeTestObjects(project, (SearchScope)scope, testInfo -> {
            if (pathToFind.equals(testInfo.getTestPath())) {
                result.set(testInfo);
                return false;
            }
            return true;
        });
        return (TEST_OBJECT)((CidrTestScopeElement)result.get());
    }

    @NotNull
    public Collection<TEST_OBJECT> collectTestObjects(@Nullable String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope) throws IndexNotReadyException {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(39);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.consumeTestObjects(pathToFind, project, scope, (Processor<? super TEST_OBJECT>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(40);
        }
        return collection;
    }

    public void consumeTestObjects(@Nullable String pathToFind, @NotNull Project project, @Nullable GlobalSearchScope scope, @NotNull Processor<? super TEST_OBJECT> processor) {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(42);
        }
        this.consumeTestObjects(project, (SearchScope)scope, testInfo -> {
            if (pathToFind == null) {
                processor.process(testInfo);
                return true;
            }
            int pathToFindLength = pathToFind.length();
            String infoTestPath = testInfo.getTestPath();
            if (infoTestPath.startsWith(pathToFind) && (pathToFindLength == infoTestPath.length() || infoTestPath.charAt(pathToFindLength) == '/')) {
                processor.process(testInfo);
            }
            return true;
        });
    }

    public void consumeTestObjects(@NotNull Project project, @Nullable SearchScope scope, @NotNull Processor<? super TEST_OBJECT> processor) throws IndexNotReadyException {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(43);
        }
        if (processor == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(44);
        }
        LinkedList<VirtualFile> testFirstCollection = new LinkedList<VirtualFile>();
        Set<VirtualFile> potentialTestHolders = CidrPotentialTestHolderRootsProvider.Companion.getPotentialTestHolderFiles(project, this);
        CidrTestListUpdater.fillCollectionWithTestFirst(potentialTestHolders, testFirstCollection);
        this.consumeTestInfo(project, testFirstCollection.iterator(), scope, (Processor<Pair<PsiFile, CidrTestInfoForFile>>)((Processor)fileAndFileInfo -> {
            for (CidrTestScopeElement testScope : this.getOrCreateObjects((PsiFile)fileAndFileInfo.first, (CidrTestInfoForFile)((Object)((Object)fileAndFileInfo.second))).values()) {
                if (processor.process((Object)testScope)) continue;
                return false;
            }
            return true;
        }));
    }

    @Contract(value="null -> null")
    public OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement testElement) {
        if (testElement == null || CidrTestWithScopeElementsFramework.isMacroInjectedIdOwner(testElement)) {
            return null;
        }
        final CidrTestScopeElement testObject = (CidrTestScopeElement)this.getTestObject(testElement);
        if (testObject != null) {
            return new OCTestLineMarkInfo(){

                @NotNull
                public String getUrlInTestTree() {
                    String string = CidrTestWithScopeElementsFramework.this.getTestUrl(testObject);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean isSuite() {
                    return !testObject.isTest();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework$1", "getUrlInTestTree"));
                }
            };
        }
        return null;
    }

    @NotNull
    protected String getTestUrl(@NotNull TEST_OBJECT testObject) {
        if (testObject == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(45);
        }
        String string = this.getProtocolPrefix() + testObject.getTestPath();
        if (string == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        if (project == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(47);
        }
        GlobalSearchScope globalSearchScope = OCSearchScope.getProjectSourcesScope((Project)project);
        if (globalSearchScope == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(48);
        }
        return globalSearchScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTestInfo(@NotNull Kryo kryo, @NotNull Output output, @NotNull CidrTestInfoForFile testInfo) {
        CidrTestScopeSerializer serializer;
        if (kryo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(49);
        }
        if (output == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(50);
        }
        if (testInfo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(51);
        }
        if ((serializer = this.getTestSerializer()) == null) {
            return;
        }
        CidrTestInfoForFile cidrTestInfoForFile = testInfo;
        synchronized (cidrTestInfoForFile) {
            Map map = (Map)this.myObjects.get((UserDataHolder)testInfo);
            if (map == null) {
                output.writeInt(0);
            } else {
                output.writeInt(map.size());
                map.forEach((name, testScopeElement) -> {
                    output.writeString(name);
                    serializer.write(kryo, output, testScopeElement);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTestInfo(@NotNull Kryo kryo, @NotNull Input input, @NotNull CidrTestInfoForFile initTestInfo, @NotNull PsiFile fileWithTest) {
        CidrTestScopeSerializer<TEST_OBJECT> serializer;
        if (kryo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(52);
        }
        if (input == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(53);
        }
        if (initTestInfo == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(54);
        }
        if (fileWithTest == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(55);
        }
        if ((serializer = this.getTestSerializer()) == null) {
            return;
        }
        CidrTestInfoForFile cidrTestInfoForFile = initTestInfo;
        synchronized (cidrTestInfoForFile) {
            HashMap<String, TEST_OBJECT> links = new HashMap<String, TEST_OBJECT>();
            int testCount = input.readInt();
            for (int i = 0; i < testCount; ++i) {
                String name = input.readString();
                TEST_OBJECT scopeElement = serializer.read(kryo, input, fileWithTest);
                if (scopeElement == null) continue;
                links.put(name, scopeElement);
            }
            this.myObjects.set((UserDataHolder)initTestInfo, links);
        }
    }

    @Nullable
    protected CidrTestScopeSerializer<TEST_OBJECT> getTestSerializer() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9, 10, 11, 12, 13, 18, 40, 46, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testHolderClass";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 40: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoForFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTestInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testScopeElement";
                break;
            }
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeTestHolder";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroNames";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 27: 
            case 31: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolKind";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeMacro";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMacroNames";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFind";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testObject";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kryo";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testInfo";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initTestInfo";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework";
                break;
            }
            case 3: 
            case 4: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestObjects";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateObjects";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestObjects";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestUrl";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "collectTestObjects";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 40: 
            case 46: 
            case 48: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestIndexLookup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateObjects";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyDirty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTestObjects";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateTestsListOrScheduleUpdateIfCannotWait";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFileTestObjectIfPossible";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToFileScope";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTestObjectFromTestHolder";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileVersion";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "cacheResultForTestHolder";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "extractTestObject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTestObjectKeyForSymbol";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "standardProbe";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findTestObjectFromMacro";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isTestMacroCandidate";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findTestObject";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "consumeTestObjects";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getTestUrl";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesScope";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "writeTestInfo";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "readTestInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9, 10, 11, 12, 13, 18, 40, 46, 48 -> new IllegalStateException(string);
        };
    }

    public static interface CidrTestScopeSerializer<TEST_OBJECT extends CidrTestScopeElement> {
        public void write(@NotNull Kryo var1, @NotNull Output var2, @NotNull TEST_OBJECT var3);

        @Nullable
        public TEST_OBJECT read(@NotNull Kryo var1, @NotNull Input var2, @NotNull PsiFile var3);
    }
}

