/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.testing.CidrTestIndexContributor;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/testing/CidrTestIndexProvider;", "", "<init>", "()V", "gatherTestLinks", "", "", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeElement;", "pFile", "Lcom/intellij/psi/PsiFile;", "fwProtocol", "intellij.c.testing"})
public final class CidrTestIndexProvider {
    @NotNull
    public static final CidrTestIndexProvider INSTANCE = new CidrTestIndexProvider();

    private CidrTestIndexProvider() {
    }

    @NotNull
    public final Map<String, CidrTestScopeElement> gatherTestLinks(@NotNull PsiFile pFile, @NotNull String fwProtocol) {
        Intrinsics.checkNotNullParameter((Object)pFile, (String)"pFile");
        Intrinsics.checkNotNullParameter((Object)fwProtocol, (String)"fwProtocol");
        CidrTestIndexContributor clangContributor = CidrTestIndexContributor.findTestIndexContributorForProtocol("clang");
        boolean tryWithClangContributor = true;
        while (true) {
            CidrTestIndexContributor contributor = null;
            if (tryWithClangContributor && clangContributor != null && clangContributor.canProcessFile(pFile, fwProtocol)) {
                contributor = clangContributor;
            } else {
                contributor = CidrTestIndexContributor.findTestIndexContributorForProtocol(fwProtocol);
                if (contributor == null) {
                    return MapsKt.emptyMap();
                }
            }
            try {
                Map<String, CidrTestScopeElement> map = contributor.gatherTestLinks(pFile, fwProtocol);
                Intrinsics.checkNotNullExpressionValue(map, (String)"gatherTestLinks(...)");
                return map;
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable e) {
                if (Intrinsics.areEqual((Object)clangContributor, (Object)contributor) && !CidrTestIndexContributor.indexTestsByClangOnly()) {
                    tryWithClangContributor = false;
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

