/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/testing/CidrShowTestInfoForProject;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "getTestInfoTxt", "Lkotlin/Pair;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c.testing"})
public final class CidrShowTestInfoForProject
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(AnAction.getEventProject((AnActionEvent)e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Pair<StringBuilder, String> pair = this.getTestInfoTxt(project2);
        StringBuilder builder = (StringBuilder)pair.component1();
        String title = (String)pair.component2();
        LightVirtualFile infoFile = new LightVirtualFile(title, (FileType)PlainTextFileType.INSTANCE, (CharSequence)builder);
        infoFile.setWritable(false);
        FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)infoFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<StringBuilder, String> getTestInfoTxt(Project project) {
        StringBuilder topBuilder = new StringBuilder();
        Object[] objectArray = new Object[]{project.getName()};
        String title = CidrExecutionBundle.message((String)"test.tests.in.project", (Object[])objectArray) + "\n";
        topBuilder.append(title);
        for (OCTestFramework framework : OCTestFrameworks.getFrameworks()) {
            StringBuilder builder = new StringBuilder();
            if (!(framework instanceof CidrTestFrameworkBase)) continue;
            Object[] objectArray2 = new Object[]{((CidrTestFrameworkBase)framework).getFrameworkId()};
            builder.append("\n").append(CidrExecutionBundle.message((String)"test.framework", (Object[])objectArray2));
            HashMap<VirtualFile, CidrTestInfoForFile> testCache = ((CidrTestFrameworkBase)framework).getIndexedTests(project);
            int testCount = 0;
            Intrinsics.checkNotNull(testCache);
            HashMap<VirtualFile, CidrTestInfoForFile> hashMap = testCache;
            synchronized (hashMap) {
                boolean bl = false;
                for (VirtualFile vf : testCache.keySet()) {
                    CidrTestInfoForFile cidrTestInfoForFile = testCache.get(vf);
                    if (cidrTestInfoForFile == null || cidrTestInfoForFile.getFrameworkVersion() == CidrTestFrameworkVersion.NOT_AVAILABLE || !(framework instanceof CidrTestWithScopeElementsFramework)) continue;
                    CidrTestInfoForFile cidrTestInfoForFile2 = cidrTestInfoForFile;
                    synchronized (cidrTestInfoForFile2) {
                        boolean bl2 = false;
                        Map testMap = (Map)((CidrTestWithScopeElementsFramework)framework).myObjects.get((UserDataHolder)cidrTestInfoForFile);
                        if (testMap != null && !testMap.isEmpty()) {
                            builder.append("\n  " + vf.getPath());
                            HashSet<String> configurationNames = new HashSet<String>();
                            for (String testName : CollectionsKt.toSortedSet((Iterable)testMap.keySet())) {
                                String configurationName;
                                CidrTestScopeElement cidrTestScopeElement = (CidrTestScopeElement)testMap.get(testName);
                                if (cidrTestScopeElement == null || !cidrTestScopeElement.isTest()) continue;
                                String string = cidrTestScopeElement.getConfigurationName();
                                if (string == null) {
                                    string = "(null)";
                                }
                                if (configurationNames.contains(configurationName = string)) continue;
                                builder.append("\n    " + configurationName);
                                configurationNames.add(configurationName);
                            }
                            Object[] objectArray3 = new Object[]{configurationNames.size()};
                            builder.append("\n    ").append(CidrExecutionBundle.message((String)"test.test.count", (Object[])objectArray3));
                            if (((CidrTestWithScopeElementsFramework)framework).isPotentialTestHolderRoot(project).value((Object)vf)) {
                                testCount += configurationNames.size();
                            } else {
                                builder.append("\n    ").append(CidrExecutionBundle.message((String)"test.file.is.not.source.file", (Object[])new Object[0]));
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            Object[] objectArray4 = new Object[]{testCount};
            builder.append("\n  ").append(CidrExecutionBundle.message((String)"test.test.count", (Object[])objectArray4));
            if (testCount <= 0) continue;
            topBuilder.append((CharSequence)builder);
        }
        return new Pair((Object)topBuilder, (Object)title);
    }
}

