/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.idea.insights.model.connection.Connection;
import com.android.tools.idea.insights.model.event.Version;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001aK\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\r\u0010\u000e\u001aM\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"getFirebaseConsoleUrl", "", "connection", "Lcom/android/tools/idea/insights/model/connection/Connection;", "timeIntervalRange", "Lkotlin/Pair;", "", "versions", "", "Lcom/android/tools/idea/insights/model/event/Version;", "id", "Lcom/android/tools/idea/insights/model/issue/IssueId;", "sessionEventKey", "getFirebaseConsoleUrl-SEexaHk", "(Lcom/android/tools/idea/insights/model/connection/Connection;Lkotlin/Pair;Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "buildFirebaseConsoleUrl", "issueId", "buildFirebaseConsoleUrl-SEexaHk", "firebase"})
public final class FirebaseConsoleUrlUtilKt {
    @NotNull
    public static final String getFirebaseConsoleUrl-SEexaHk(@NotNull Connection connection, @Nullable Pair<Long, Long> timeIntervalRange, @NotNull Set<Version> versions2, @NotNull String string, @Nullable String sessionEventKey) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(versions2, (String)"versions");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-android-tools-idea-insights-model-issue-IssueId$-id$0");
        return FirebaseConsoleUrlUtilKt.buildFirebaseConsoleUrl-SEexaHk(connection, timeIntervalRange, versions2, string, sessionEventKey);
    }

    private static final String buildFirebaseConsoleUrl-SEexaHk(Connection connection, Pair<Long, Long> timeIntervalRange, Set<Version> versions2, String string, String sessionEventKey) {
        URIBuilder uriBuilder = new URIBuilder("https://console.firebase.google.com/");
        uriBuilder.setPath("project/" + connection.getProjectId() + "/crashlytics/app/" + connection.getClientId() + "/issues/" + string);
        if (timeIntervalRange != null) {
            uriBuilder.addParameter("time", timeIntervalRange.getFirst() + ":" + timeIntervalRange.getSecond());
        }
        if (!((Collection)versions2).isEmpty()) {
            uriBuilder.addParameter("versions", CollectionsKt.joinToString$default((Iterable)versions2, (CharSequence)";", null, null, (int)0, null, FirebaseConsoleUrlUtilKt::buildFirebaseConsoleUrl_SEexaHk$lambda$0, (int)30, null));
        }
        if (sessionEventKey != null) {
            uriBuilder.addParameter("sessionEventKey", sessionEventKey);
        }
        String string2 = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final CharSequence buildFirebaseConsoleUrl_SEexaHk$lambda$0(Version it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDisplayVersion() + " (" + it.getBuildVersion() + ")";
    }
}

