/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.config;

import com.android.tools.idea.gradle.model.IdeVariantCore;
import com.android.tools.idea.gradle.model.IdeVariantHeader;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.utils.StringHelper;
import com.google.services.firebase.insights.config.FileLocation;
import com.google.services.firebase.insights.config.FirebaseAppManagerKt;
import com.google.services.firebase.insights.config.GoogleServicesDirectoryLocator;
import com.google.services.firebase.insights.config.VariantDirectoryLocator;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u0013\u001a\u00020\bH\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\"\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/google/services/firebase/insights/config/GoogleServicesDirectoryLocator;", "Lcom/google/services/firebase/insights/config/VariantDirectoryLocator;", "moduleVariantsProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/Module;", "", "", "moduleSelectedVariantProvider", "Lcom/android/tools/idea/gradle/model/IdeVariantHeader;", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "locate", "", "", "Lcom/google/services/firebase/insights/config/FileLocation;", "module", "getUnselectedVariantPaths", "variantName", "getSelectedVariantPaths", "variant", "getVariantPathsFromFlavors", "flavors", "buildType", "firebase"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nFirebaseAppManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseAppManager.kt\ncom/google/services/firebase/insights/config/GoogleServicesDirectoryLocator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n463#2:274\n413#2:275\n1252#3,2:276\n1056#3:278\n1255#3:279\n1563#3:280\n1634#3,3:281\n1#4:284\n*S KotlinDebug\n*F\n+ 1 FirebaseAppManager.kt\ncom/google/services/firebase/insights/config/GoogleServicesDirectoryLocator\n*L\n218#1:274\n218#1:275\n218#1:276,2\n219#1:278\n218#1:279\n227#1:280\n227#1:281,3\n*E\n"})
public final class GoogleServicesDirectoryLocator
implements VariantDirectoryLocator {
    @TestOnly
    @NotNull
    private final Function1<Module, Set<String>> moduleVariantsProvider;
    @TestOnly
    @NotNull
    private final Function1<Module, IdeVariantHeader> moduleSelectedVariantProvider;

    public GoogleServicesDirectoryLocator(@NotNull Function1<? super Module, ? extends Set<String>> moduleVariantsProvider, @NotNull Function1<? super Module, ? extends IdeVariantHeader> moduleSelectedVariantProvider) {
        Intrinsics.checkNotNullParameter(moduleVariantsProvider, (String)"moduleVariantsProvider");
        Intrinsics.checkNotNullParameter(moduleSelectedVariantProvider, (String)"moduleSelectedVariantProvider");
        this.moduleVariantsProvider = moduleVariantsProvider;
        this.moduleSelectedVariantProvider = moduleSelectedVariantProvider;
    }

    public /* synthetic */ GoogleServicesDirectoryLocator(Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = GoogleServicesDirectoryLocator::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            function12 = GoogleServicesDirectoryLocator::_init_$lambda$1;
        }
        this((Function1<? super Module, ? extends Set<String>>)function1, (Function1<? super Module, ? extends IdeVariantHeader>)function12);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, List<FileLocation>> locate(@NotNull Module module) {
        void $this$mapValuesTo$iv$iv;
        IdeVariantHeader selectedVariant;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Set variants = (Set)this.moduleVariantsProvider.invoke((Object)module);
        Map fileLocationsByVariantName = new LinkedHashMap();
        fileLocationsByVariantName.put("All", SetsKt.setOf((Object)FileLocation.box-impl(FileLocation.constructor-impl(""))));
        IdeVariantHeader ideVariantHeader = selectedVariant = (IdeVariantHeader)this.moduleSelectedVariantProvider.invoke((Object)module);
        if (ideVariantHeader != null) {
            IdeVariantHeader it = ideVariantHeader;
            boolean bl = false;
            fileLocationsByVariantName.put(it.getDisplayName(), this.getSelectedVariantPaths(it));
        }
        for (String variant : variants) {
            fileLocationsByVariantName.put(variant, this.getUnselectedVariantPaths(variant));
        }
        Map $this$mapValues$iv = fileLocationsByVariantName;
        boolean $i$f$mapValues = false;
        Map bl = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            Iterable $this$sortedBy$iv = (Iterable)entry.getValue();
            boolean $i$f$sortedBy = false;
            List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    String fileLocation = ((FileLocation)a).unbox-impl();
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(fileLocation.chars().filter(locate.2.1.1.INSTANCE).count());
                    fileLocation = ((FileLocation)b).unbox-impl();
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(fileLocation.chars().filter(locate.2.1.1.INSTANCE).count()));
                }
            });
            map3.put(k, list);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FileLocation> getUnselectedVariantPaths(String variantName) {
        void $this$mapTo$iv$iv;
        String[] stringArray = StringUtils.splitByCharacterTypeCamelCase((String)variantName);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByCharacterTypeCamelCase(...)");
        Iterable $this$map$iv = ArraysKt.asList((Object[])stringArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        List allFlavorNames = (List)destination$iv$iv;
        if (allFlavorNames.isEmpty()) {
            return SetsKt.emptySet();
        }
        String buildType = (String)CollectionsKt.last((List)allFlavorNames);
        List<String> flavors = allFlavorNames.subList(0, CollectionsKt.getLastIndex((List)allFlavorNames));
        return this.getVariantPathsFromFlavors(flavors, buildType);
    }

    private final Set<FileLocation> getSelectedVariantPaths(IdeVariantHeader variant) {
        return this.getVariantPathsFromFlavors(variant.getProductFlavors(), variant.getBuildType());
    }

    private final Set<FileLocation> getVariantPathsFromFlavors(List<String> flavors, String buildType) {
        Object[] objectArray = new FileLocation[]{FileLocation.box-impl(FileLocation.constructor-impl("")), FileLocation.box-impl(FileLocation.constructor-impl("src/" + buildType))};
        Set fileLocations = SetsKt.mutableSetOf((Object[])objectArray);
        if (!((Collection)flavors).isEmpty()) {
            String string;
            Object object = CollectionsKt.joinToString$default((Iterable)flavors, (CharSequence)"", null, null, (int)0, null, GoogleServicesDirectoryLocator::getVariantPathsFromFlavors$lambda$0, (int)30, null);
            if (((CharSequence)object).length() > 0) {
                char p0 = ((String)object).charAt(0);
                boolean $i$a$-replaceFirstCharWithChar-GoogleServicesDirectoryLocator$getVariantPathsFromFlavors$flavorName$32 = false;
                char c = Character.toLowerCase(p0);
                Object $i$a$-replaceFirstCharWithChar-GoogleServicesDirectoryLocator$getVariantPathsFromFlavors$flavorName$32 = object;
                int n = 1;
                String string2 = ((String)$i$a$-replaceFirstCharWithChar-GoogleServicesDirectoryLocator$getVariantPathsFromFlavors$flavorName$32).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                $i$a$-replaceFirstCharWithChar-GoogleServicesDirectoryLocator$getVariantPathsFromFlavors$flavorName$32 = string2;
                string = c + (String)$i$a$-replaceFirstCharWithChar-GoogleServicesDirectoryLocator$getVariantPathsFromFlavors$flavorName$32;
            } else {
                string = object;
            }
            String flavorName = string;
            object = fileLocations;
            Object object2 = new FileLocation[]{FileLocation.box-impl(FileLocation.constructor-impl("src/" + flavorName + "/" + buildType)), FileLocation.box-impl(FileLocation.constructor-impl("src/" + buildType + "/" + flavorName)), FileLocation.box-impl(FileLocation.constructor-impl("src/" + flavorName)), FileLocation.box-impl(FileLocation.constructor-impl("src/" + StringHelper.appendCapitalized((String)flavorName, (String)buildType)))};
            object2 = CollectionsKt.listOf((Object[])object2);
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
            Object fileLocation = "src";
            for (String flavor : flavors) {
                fileLocation = (String)fileLocation + "/" + flavor;
                fileLocations.add(FileLocation.box-impl(FileLocation.constructor-impl((String)fileLocation)));
                fileLocations.add(FileLocation.box-impl(FileLocation.constructor-impl((String)fileLocation + "/" + buildType)));
                fileLocations.add(FileLocation.box-impl(FileLocation.constructor-impl(StringHelper.appendCapitalized((String)fileLocation, (String)buildType))));
            }
        }
        return fileLocations;
    }

    private static final Set _init_$lambda$0(Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GradleAndroidModel androidModel = GradleAndroidModel.Companion.get(it);
        Object object = androidModel;
        if (object == null || (object = object.getFilteredVariantNames()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    private static final IdeVariantCore _init_$lambda$1(Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GradleAndroidModel gradleAndroidModel = GradleAndroidModel.Companion.get(it);
        return gradleAndroidModel != null ? gradleAndroidModel.getSelectedVariant() : null;
    }

    private static final CharSequence getVariantPathsFromFlavors$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FirebaseAppManagerKt.capitalize(it);
    }

    public GoogleServicesDirectoryLocator() {
        this(null, null, 3, null);
    }
}

