/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.downloads.DownloadService;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBColor;
import icons.FirebaseIcons;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class FirebaseTutorialBundleCacheManager
extends DownloadService {
    private static final String BUNDLE_NAME = "firebase_tutorial_bundle";
    private static final String BUNDLE_FILE_NAME = "firebase_tutorial_bundle.xml";
    private static final String TEMP_BUNDLE_FILE_NAME = "firebase_tutorial_bundle_temp.xml";
    private static final String ICON_REPLACEMENT_PROPERTY = "firebase.icons";
    private static final String PLUGIN_ID = "com.google.services.firebase.firebase_services";
    private static final String TUTORIAL_CONFIG_FILENAME = "/firebase_tutorial_bundle.xml";
    private static final File CACHE_PATH = new File(PathManager.getSystemPath(), "firebase_tutorial_bundle");
    private static final String BUNDLE_URL = "https://firebase.google.com/android-studio/firebase_assistant/firebase_tutorial_bundle.xml";
    private static final String ICON_PREFIX_URL = "https://firebase.google.com/android-studio/firebase_assistant";
    private static boolean USE_DARK_ICONS = !JBColor.isBright();
    private String tutorialContents = null;
    private final PropertiesComponent cache;

    public void loadFromFile(URL url) {
        try {
            this.tutorialContents = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            FirebaseTutorialBundleCacheManager.getLog().warn("Error while trying to load firebase tutorial bundle file", (Throwable)e);
        }
    }

    public InputStream getTutorialStream() {
        this.refreshSynchronously();
        return new ByteArrayInputStream(this.tutorialContents.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(FirebaseTutorialBundleCacheManager.class);
    }

    public FirebaseTutorialBundleCacheManager() {
        this(PropertiesComponent.getInstance(), BUNDLE_URL);
    }

    FirebaseTutorialBundleCacheManager(PropertiesComponent cache, String remoteBundleUrl) {
        super("Firebase Tutorial Bundle", remoteBundleUrl, FirebaseTutorialBundleCacheManager.class.getResource(TUTORIAL_CONFIG_FILENAME), CACHE_PATH, TEMP_BUNDLE_FILE_NAME, BUNDLE_FILE_NAME);
        this.cache = cache;
    }

    public Icon getIconResource(String resourceRoot, Class resourceClass, String iconName) {
        Icon replacementLocalIcon;
        String localPath = FileUtils.toSystemIndependentPath((String)new File(resourceRoot, iconName).toString());
        String replacementIconPath = System.getProperty(ICON_REPLACEMENT_PROPERTY);
        if (replacementIconPath != null && (replacementLocalIcon = this.getIconFromCustomLocation(replacementIconPath, localPath)) != null) {
            return replacementLocalIcon;
        }
        if (this.iconInCache(iconName)) {
            return this.getIconFromCache(iconName);
        }
        Icon localIcon = this.getIconFromLocalResources(localPath, resourceClass);
        if (localIcon != null) {
            return localIcon;
        }
        Icon internetIcon = this.getIconFromInternet(localPath, iconName);
        if (internetIcon != null) {
            return internetIcon;
        }
        return FirebaseIcons.ACTION_ICON;
    }

    private Icon getIconFromCustomLocation(String filePrefix, String localPath) {
        File imagePath = new File(filePrefix, FirebaseTutorialBundleCacheManager.getThemedIconName(localPath));
        try {
            BufferedImage localImage = ImageIO.read(imagePath);
            ImageIcon localIcon = new ImageIcon(localImage);
            return localIcon;
        }
        catch (IOException e) {
            FirebaseTutorialBundleCacheManager.getLog().error("Error while fetching " + imagePath.toString(), (Throwable)e);
            return null;
        }
    }

    private Icon getIconFromInternet(String localPath, String iconName) {
        try {
            BufferedImage internetImage = ImageIO.read(new URL(ICON_PREFIX_URL + FirebaseTutorialBundleCacheManager.getThemedIconName(localPath)));
            ImageIcon internetIcon = new ImageIcon(internetImage);
            this.cacheIcon(internetIcon, iconName);
            return internetIcon;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Icon getIconFromLocalResources(String localPath, Class resourceClass) {
        try {
            Icon localIcon = IconLoader.findIcon((String)localPath, (Class)resourceClass);
            if (localIcon != null && localIcon.getIconWidth() > 1) {
                return localIcon;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private boolean iconInCache(String iconName) {
        return this.cache.isValueSet(PLUGIN_ID + FirebaseTutorialBundleCacheManager.getThemedIconName(iconName));
    }

    Icon getIconFromCache(String iconName) {
        try {
            return FirebaseTutorialBundleCacheManager.fromBase64String(this.cache.getValue(PLUGIN_ID + FirebaseTutorialBundleCacheManager.getThemedIconName(iconName)));
        }
        catch (IOException | ClassNotFoundException e) {
            FirebaseTutorialBundleCacheManager.getLog().warn("error while deserializing " + iconName);
            return FirebaseIcons.ACTION_ICON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheIcon(ImageIcon icon, String iconName) {
        PropertiesComponent propertiesComponent = this.cache;
        synchronized (propertiesComponent) {
            try {
                this.cache.setValue(PLUGIN_ID + FirebaseTutorialBundleCacheManager.getThemedIconName(iconName), FirebaseTutorialBundleCacheManager.toBase64String(icon));
            }
            catch (IOException e) {
                FirebaseTutorialBundleCacheManager.getLog().warn("error while caching " + iconName, (Throwable)e);
            }
        }
    }

    private static String getThemedIconName(String name) {
        if (!USE_DARK_ICONS) {
            return name;
        }
        return name.replace(".png", "_dark.png");
    }

    static ImageIcon fromBase64String(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return (ImageIcon)o;
    }

    static String toBase64String(ImageIcon o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

