/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.clangd.schema;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\r\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\bH\u0016J\r\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/clangd/schema/ClangTidySchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "<init>", "()V", "CLANG_TIDY_SCHEMA", "", "CLANG_TIDY_DARK_SCHEMA", "schemaName", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "getPresentableName", "Lcom/intellij/openapi/util/NlsContexts$ListItem;", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "getSchemaVersion", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;", "isUserVisible", "getSchemaFile", "intellij.cidr.clangd.schema"})
public final class ClangTidySchemaProvider
implements JsonSchemaFileProvider {
    @NotNull
    public static final ClangTidySchemaProvider INSTANCE = new ClangTidySchemaProvider();
    @NotNull
    private static final String CLANG_TIDY_SCHEMA = "clangtidy.json";
    @NotNull
    private static final String CLANG_TIDY_DARK_SCHEMA = "clangtidyDark.json";
    @NotNull
    private static final String schemaName;

    private ClangTidySchemaProvider() {
    }

    public boolean isAvailable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)".clang-tidy", (Object)file.getName());
    }

    @NotNull
    public String getName() {
        return schemaName;
    }

    @NotNull
    public String getPresentableName() {
        return schemaName;
    }

    @NotNull
    public SchemaType getSchemaType() {
        return SchemaType.embeddedSchema;
    }

    @Nullable
    public JsonSchemaVersion getSchemaVersion() {
        return JsonSchemaVersion.SCHEMA_7;
    }

    public boolean isUserVisible() {
        return false;
    }

    @Nullable
    public VirtualFile getSchemaFile() {
        String schema = EditorColorsManager.getInstance().isDarkEditor() ? CLANG_TIDY_DARK_SCHEMA : CLANG_TIDY_SCHEMA;
        return JsonSchemaProviderFactory.getResourceFile(this.getClass(), (String)("/schemas/" + schema));
    }

    static {
        String string = ClangdBundle.message((String)"clang.tidy.schema.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        schemaName = string;
    }
}

