/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.io.FileUtilRt;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CompilerUsagesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("cidr.compilers", 2);
    private static final EventId1<DetectedCompilerKind> CIDR_COMPILER = GROUP.registerEvent("cidr.compiler", (EventField)EventFields.Enum((String)"value", DetectedCompilerKind.class));
    public static final Pattern NATIVE_GCC_REGEX = Pattern.compile("^(gcc|g\\+\\+)(-.*)?");
    private static final Map<String, DetectedCompilerKind> NAMED_COMPILER_CUSTOM_KINDS = Map.ofEntries(Map.entry("armcc", DetectedCompilerKind.KEIL_ARMCC), Map.entry("armclang", DetectedCompilerKind.KEIL_ARMCLANG), Map.entry("c++", DetectedCompilerKind.SYSTEM_DEFAULT), Map.entry("cc", DetectedCompilerKind.SYSTEM_DEFAULT), Map.entry("cl", DetectedCompilerKind.MSVC_NATIVE), Map.entry("icl", DetectedCompilerKind.MSVC_NATIVE), Map.entry("clang", DetectedCompilerKind.CLANG), Map.entry("clang++", DetectedCompilerKind.CLANG), Map.entry("dpcpp", DetectedCompilerKind.CLANG), Map.entry("icx", DetectedCompilerKind.CLANG), Map.entry("icpx", DetectedCompilerKind.CLANG), Map.entry("clang-cl", DetectedCompilerKind.CLANG_CL), Map.entry("dpcpp-cl", DetectedCompilerKind.CLANG_CL), Map.entry("cpp", DetectedCompilerKind.SYSTEM_DEFAULT), Map.entry("emcc", DetectedCompilerKind.EMSCRIPTEN), Map.entry("em++", DetectedCompilerKind.EMSCRIPTEN), Map.entry("gcc", DetectedCompilerKind.GCC_NATIVE), Map.entry("g++", DetectedCompilerKind.GCC_NATIVE), Map.entry("icc", DetectedCompilerKind.GCC_NATIVE), Map.entry("icpc", DetectedCompilerKind.GCC_NATIVE), Map.entry("icc430", DetectedCompilerKind.IAR_MSP430), Map.entry("icc8051", DetectedCompilerKind.IAR_8051), Map.entry("iccarm", DetectedCompilerKind.IAR_ARM), Map.entry("iccavr_tiny", DetectedCompilerKind.IAR_AVR), Map.entry("iccavr", DetectedCompilerKind.IAR_AVR), Map.entry("iccriscv", DetectedCompilerKind.IAR_RISCV), Map.entry("iccrx", DetectedCompilerKind.IAR_RX), Map.entry("iccstm8", DetectedCompilerKind.IAR_STM8), Map.entry("sdcc", DetectedCompilerKind.SDCC), Map.entry("xgcc", DetectedCompilerKind.GCC_NATIVE), Map.entry("xg++", DetectedCompilerKind.GCC_NATIVE), Map.entry("nvcc", DetectedCompilerKind.NVCC));
    private static final List<Pair<String, DetectedCompilerKind>> GCC_NAME_PARTS = Arrays.asList(Pair.pair((Object)"arm", (Object)((Object)DetectedCompilerKind.GCC_ARM)), Pair.pair((Object)"avr", (Object)((Object)DetectedCompilerKind.GCC_AVR)), Pair.pair((Object)"esp32", (Object)((Object)DetectedCompilerKind.GCC_ESP32)), Pair.pair((Object)"lx106", (Object)((Object)DetectedCompilerKind.GCC_ESP8266)), Pair.pair((Object)"mips", (Object)((Object)DetectedCompilerKind.GCC_MIPS)), Pair.pair((Object)"riscv", (Object)((Object)DetectedCompilerKind.GCC_RISCV)));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            CompilerUsagesCollector.$$$reportNull$$$0(0);
        }
        Set<MetricEvent> set = OCWorkspace.getInstance(project).getConfigurations().stream().flatMap(OCResolveConfiguration::getAllCompilerSettings).map(OCCompilerSettings::getCompilerExecutable).map(CompilerUsagesCollector::extractMetric).filter(Predicates.nonNull()).map(value -> CIDR_COMPILER.metric((Object)value)).collect(Collectors.toSet());
        if (set == null) {
            CompilerUsagesCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    public static DetectedCompilerKind extractMetric(@Nullable File compilerPath) {
        if (compilerPath == null) {
            return null;
        }
        String nakedCompilerName = CompilerUsagesCollector.stripFolderName(compilerPath.getName());
        DetectedCompilerKind value = NAMED_COMPILER_CUSTOM_KINDS.get(nakedCompilerName = nakedCompilerName.toLowerCase(Locale.ROOT));
        if (value != null) {
            return value;
        }
        if (nakedCompilerName.contains("-gcc") || nakedCompilerName.contains("-g++") || nakedCompilerName.contains("-cpp") || nakedCompilerName.contains("-c++") || nakedCompilerName.contains("-cc")) {
            for (Pair<String, DetectedCompilerKind> namingPair : GCC_NAME_PARTS) {
                if (!nakedCompilerName.contains((CharSequence)namingPair.first)) continue;
                return (DetectedCompilerKind)((Object)namingPair.second);
            }
        }
        if (NATIVE_GCC_REGEX.matcher(nakedCompilerName).matches()) {
            return DetectedCompilerKind.GCC_NATIVE;
        }
        return DetectedCompilerKind.UNKNOWN;
    }

    @NotNull
    private static String stripFolderName(String fullName) {
        int slashIndex = Math.max(fullName.lastIndexOf(47), fullName.lastIndexOf(92));
        if (slashIndex >= 0) {
            fullName = fullName.substring(slashIndex + 1);
        }
        String string = FileUtilRt.getNameWithoutExtension((String)fullName);
        if (string == null) {
            CompilerUsagesCollector.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "stripFolderName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static enum DetectedCompilerKind {
        CLANG,
        CLANG_CL,
        EMSCRIPTEN,
        GCC_ARM,
        GCC_AVR,
        GCC_ESP32,
        GCC_ESP8266,
        GCC_MIPS,
        GCC_NATIVE,
        GCC_RISCV,
        IAR_8051,
        IAR_ARM,
        IAR_AVR,
        IAR_MSP430,
        IAR_RISCV,
        IAR_RX,
        IAR_STM8,
        KEIL_ARMCC,
        KEIL_ARMCLANG,
        MSVC_NATIVE,
        NVCC,
        SDCC,
        SYSTEM_DEFAULT,
        UNKNOWN,
        USER_DEFINED;

    }
}

