/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.Checksum;
import com.android.repository.api.ProgressIndicator;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;

public interface Downloader {
    public InputStream downloadAndStream(URL var1, ProgressIndicator var2) throws IOException;

    public Path downloadFully(URL var1, ProgressIndicator var2) throws IOException;

    public void downloadFully(URL var1, Path var2, Checksum var3, ProgressIndicator var4) throws IOException;

    default public void downloadFullyWithCaching(URL url, Path target, Checksum checksum, ProgressIndicator indicator) throws IOException {
        this.downloadFully(url, target, checksum, indicator);
    }

    default public void setDownloadIntermediatesLocation(Path intermediatesLocation) {
    }

    public static String hash(InputStream in, long fileSize, String algorithm, ProgressIndicator progress) throws IOException {
        int bytesRead;
        progress.setText("Checking existing file...");
        Hasher hasher = (algorithm.equalsIgnoreCase("sha-256") ? Hashing.sha256() : Hashing.sha1()).newHasher();
        byte[] buf = new byte[5120];
        long totalRead = 0L;
        while ((bytesRead = in.read(buf)) > 0) {
            hasher.putBytes(buf, 0, bytesRead);
            progress.setFraction((double)(totalRead += (long)bytesRead) / (double)fileSize);
        }
        return hasher.hash().toString();
    }
}

