/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.api.ide.stacktrace;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.inspectors.common.api.stacktrace.CodeElement;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/inspectors/common/api/ide/stacktrace/IntelliJCodeElement;", "Lcom/android/tools/inspectors/common/api/stacktrace/CodeElement;", "project", "Lcom/intellij/openapi/project/Project;", "codeLocation", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/codenavigation/CodeLocation;)V", "packageName", "", "simpleClassName", "isInUserCode", "", "getCodeLocation", "getPackageName", "getSimpleClassName", "getMethodName", "isInNativeSources", "isInSources", "intellij.android.inspectors-common.api-ide"})
public final class IntelliJCodeElement
implements CodeElement {
    @NotNull
    private final Project project;
    @NotNull
    private final CodeLocation codeLocation;
    @NotNull
    private final String packageName;
    @NotNull
    private final String simpleClassName;
    private final boolean isInUserCode;

    public IntelliJCodeElement(@NotNull Project project, @NotNull CodeLocation codeLocation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)codeLocation, (String)"codeLocation");
        this.project = project;
        this.codeLocation = codeLocation;
        String className = this.codeLocation.getClassName();
        if (className == null) {
            this.packageName = "<unknown package>";
            this.simpleClassName = "<unkonwn class>";
        } else {
            String string;
            String string2;
            int dot = StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dot <= 0) {
                string2 = "<no package>";
            } else {
                String string3 = className.substring(0, dot);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            this.packageName = string2;
            if (dot + 1 < className.length()) {
                String string4 = className.substring(dot + 1);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            } else {
                string = "<unkonwn class>";
            }
            this.simpleClassName = string;
        }
        this.isInUserCode = IdeInfo.isGameTool() ? false : (this.codeLocation.isNativeCode() ? this.isInNativeSources() : this.isInSources());
    }

    @Override
    @NotNull
    public CodeLocation getCodeLocation() {
        return this.codeLocation;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NotNull
    public String getSimpleClassName() {
        return this.simpleClassName;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.codeLocation.getMethodName();
        if (string == null) {
            string = "<unknown method>";
        }
        return string;
    }

    @Override
    public boolean isInUserCode() {
        return this.isInUserCode;
    }

    private final boolean isInNativeSources() {
        String string = this.codeLocation.getFileName();
        if (string == null) {
            return false;
        }
        String sourceFileName = string;
        if (((CharSequence)sourceFileName).length() == 0) {
            return false;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(sourceFileName);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        Application application = ApplicationManager.getApplication();
        Object object = application.runReadAction(() -> IntelliJCodeElement.isInNativeSources$lambda$0(this, file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (Boolean)object;
    }

    private final boolean isInSources() {
        if (this.codeLocation.getClassName() == null) {
            return false;
        }
        String string = this.codeLocation.getOuterClass();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOuterClass(...)");
        String className = string;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.project);
        Application application = ApplicationManager.getApplication();
        Object object = application.runReadAction(() -> IntelliJCodeElement.isInSources$lambda$0(psiFacade, className, this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (Boolean)object;
    }

    private static final Boolean isInNativeSources$lambda$0(IntelliJCodeElement this$0, VirtualFile $file) {
        return ProjectFileIndex.getInstance((Project)this$0.project).isInSource($file);
    }

    private static final Boolean isInSources$lambda$0(JavaPsiFacade $psiFacade, String $className, IntelliJCodeElement this$0) {
        PsiClass psiClass = $psiFacade.findClass($className, GlobalSearchScope.allScope((Project)this$0.project));
        PsiClass psiClass2 = psiClass;
        if (psiClass2 == null || (psiClass2 = psiClass2.getContainingFile()) == null || (psiClass2 = psiClass2.getVirtualFile()) == null) {
            return false;
        }
        PsiClass file = psiClass2;
        return ProjectFileIndex.getInstance((Project)this$0.project).isInSource((VirtualFile)file);
    }
}

