/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdBatchAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdBatchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.cidr.clangd.legacyBridge"})
public final class ClangdBatchAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = ActionsKt.runReadAction(() -> ClangdBatchAction.actionPerformed$lambda$0(project2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        Collection files = (Collection)object;
        long startTime = System.nanoTime();
        ClangLanguageService clangdService = ClangLanguageServiceProvider.getOrStart((Project)project2);
        if (clangdService == null) {
            ClangUtils.LOG.warn("ClangLanguageService is not found");
            return;
        }
        int nThreads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        Set filesWithErrors = new LinkedHashSet();
        Set filesWithCrashes = new LinkedHashSet();
        AtomicInteger processedCount = new AtomicInteger(0);
        String string = ClangdBundle.message((String)"language.cpp.clangd.batch.action.title", (Object[])new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(project2, files, executorService, startTime, filesWithErrors, filesWithCrashes, clangdService, processedCount, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection<VirtualFile> $files;
            final /* synthetic */ ExecutorService $executorService;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Set<VirtualFile> $filesWithErrors;
            final /* synthetic */ Set<VirtualFile> $filesWithCrashes;
            final /* synthetic */ ClangLanguageService $clangdService;
            final /* synthetic */ AtomicInteger $processedCount;
            {
                this.$project = $project;
                this.$files = $files;
                this.$executorService = $executorService;
                this.$startTime = $startTime;
                this.$filesWithErrors = $filesWithErrors;
                this.$filesWithCrashes = $filesWithCrashes;
                this.$clangdService = $clangdService;
                this.$processedCount = $processedCount;
                super($project, $super_call_param$1, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                void $this$forEach$iv;
                ClangLanguageService $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(false);
                LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
                Iterable $this$filter$iv = this.$files;
                boolean $i$f$filter22 = false;
                Iterable iterable = $this$filter$iv;
                Set<VirtualFile> destination$iv$iv = (Set<VirtualFile>)((Object)new ArrayList<E>());
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!languageUtils.isSupportedFile(it)) continue;
                    destination$iv$iv.add((VirtualFile)element$iv$iv);
                }
                $this$filter$iv = (List)((Object)destination$iv$iv);
                ExecutorService $i$f$filter22 = this.$executorService;
                $this$filterTo$iv$iv = this.$clangdService;
                destination$iv$iv = this.$filesWithCrashes;
                Set<VirtualFile> set = this.$filesWithErrors;
                AtomicInteger atomicInteger = this.$processedCount;
                Collection<VirtualFile> collection = this.$files;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VirtualFile file = (VirtualFile)element$iv;
                    boolean bl = false;
                    $i$f$filter22.submit(() -> actionPerformed.task.1.run$lambda$5$lambda$4(indicator, file, $this$filterTo$iv$iv, destination$iv$iv, set, atomicInteger, collection));
                }
                this.$executorService.shutdown();
                try {
                    while (!this.$executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                        ProgressManager.checkCanceled();
                    }
                }
                finally {
                    this.$executorService.shutdownNow();
                    long totalDurationMS = (System.nanoTime() - this.$startTime) / (long)1000000;
                    String result = "total duration: " + totalDurationMS + "ms, avg: " + totalDurationMS / (long)this.$files.size() + "ms/file\nErrors:\n" + CollectionsKt.joinToString$default((Iterable)this.$filesWithErrors, (CharSequence)"\n", null, null, (int)0, null, actionPerformed.task.1::run$lambda$6, (int)30, null) + "\nCrashes:\n" + CollectionsKt.joinToString$default((Iterable)this.$filesWithCrashes, (CharSequence)"\n", null, null, (int)0, null, actionPerformed.task.1::run$lambda$7, (int)30, null) + "\n";
                    ClangdBatchAction.access$getLOG$cp().warn(result);
                    ActionsKt.invokeLater$default(null, () -> actionPerformed.task.1.run$lambda$8(result, this.$project), (int)1, null);
                }
            }

            public void onCancel() {
                super.onCancel();
                this.$executorService.shutdownNow();
            }

            private static final List run$lambda$5$lambda$4$lambda$3$lambda$1(ClangParseResponse it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompletableFuture completableFuture = it.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"getDiagnostics(...)");
                Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)completableFuture, (long)60000L, (String)"diagnostics");
                return supplier != null ? (List<E>)supplier.get() : null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final Unit run$lambda$5$lambda$4$lambda$3(ProgressIndicator $indicator, VirtualFile $file, ClangLanguageService $clangdService, Set $filesWithCrashes, Set $filesWithErrors, AtomicInteger $processedCount, Collection $files) {
                $indicator.setText($file.getUrl());
                SimpleOpenRequestId requestId = new SimpleOpenRequestId(ClangdBatchAction.class, "opened [" + $file.getName() + "]");
                $clangdService.notifyDocumentOpened($file, (OpenRequestId)requestId);
                try {
                    int n;
                    long time = System.nanoTime();
                    Intrinsics.checkNotNull((Object)$file);
                    List diagnostics = (List)ClangLanguageServiceUtilsKt.computeWithParsedKt((ClangLanguageService)$clangdService, (VirtualFile)$file, actionPerformed.task.1::run$lambda$5$lambda$4$lambda$3$lambda$1);
                    if (diagnostics == null) {
                        if (!$indicator.isCanceled()) {
                            ClangdBatchAction.access$getLOG$cp().error($file.getUrl() + ": clangd crashed");
                            $filesWithCrashes.add($file);
                        }
                        Unit unit = Unit.INSTANCE;
                        return unit;
                    }
                    Iterable $this$count$iv = diagnostics;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (T element$iv : $this$count$iv) {
                            ClangDiagnostic it = (ClangDiagnostic)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getSeverity(), (Object)HighlightSeverity.ERROR) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int numErrors = n;
                    long durationMS = (System.nanoTime() - time) / (long)1000000;
                    long fileLength = $file.getLength();
                    if (numErrors > 0) {
                        $filesWithErrors.add($file);
                    }
                    ClangdBatchAction.access$getLOG$cp().info($file.getUrl() + ", wait time: " + durationMS + "ms, length:" + fileLength / (long)1024 + "kb, performance: " + fileLength / durationMS + " kb/s, numErrors = " + numErrors);
                }
                catch (Throwable ex) {
                    ClangdBatchAction.access$getLOG$cp().error($file.getUrl() + ": clangd crashed");
                    Intrinsics.checkNotNull((Object)$file);
                    $filesWithCrashes.add($file);
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    $clangdService.notifyDocumentClosed($file, (OpenRequestId)requestId);
                    int processed = $processedCount.incrementAndGet();
                    $indicator.setFraction(1.0 * (double)processed / (double)$files.size());
                }
                return Unit.INSTANCE;
            }

            private static final void run$lambda$5$lambda$4(ProgressIndicator $indicator, VirtualFile $file, ClangLanguageService $clangdService, Set $filesWithCrashes, Set $filesWithErrors, AtomicInteger $processedCount, Collection $files) {
                ActionsKt.runReadAction(() -> actionPerformed.task.1.run$lambda$5$lambda$4$lambda$3($indicator, $file, $clangdService, $filesWithCrashes, $filesWithErrors, $processedCount, $files));
            }

            private static final CharSequence run$lambda$6(VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "  " + it.getUrl();
            }

            private static final CharSequence run$lambda$7(VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "  " + it.getUrl();
            }

            private static final Unit run$lambda$8(String $result, Project $project) {
                LightVirtualFile infoFile = new LightVirtualFile("Clangd Batch Result", (FileType)PlainTextFileType.INSTANCE, (CharSequence)$result);
                FileEditorManager.getInstance((Project)$project).openFile((VirtualFile)infoFile, true);
                return Unit.INSTANCE;
            }
        };
        task2.queue();
    }

    private static final Collection actionPerformed$lambda$0(Project $project) {
        return OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)$project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance((String)ClangdBatchAction.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdBatchAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.cidr.clangd.legacyBridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

