/*
 * Decompiled with CFR 0.152.
 */
package com.android.screenshottest.producers;

import com.android.screenshottest.producers.ScreenshotTestConfigurationProducerUtilKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.testartifacts.testsuite.GradleRunConfigurationExtension;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.AbstractGradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.util.TasksToRun;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0014J&\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J&\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/android/screenshottest/producers/ScreenshotTestAllInPackageGradleConfigurationProducer;", "Lorg/jetbrains/plugins/gradle/execution/test/runner/AllInPackageGradleConfigurationProducer;", "<init>", "()V", "suggestConfigurationName", "", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "element", "Lcom/intellij/psi/PsiPackage;", "chosenElements", "", "doIsConfigurationFromContext", "", "configuration", "Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration;", "getAllTestsTaskToRun", "Lorg/jetbrains/plugins/gradle/execution/test/runner/AbstractGradleTestRunConfigurationProducer$TestTasksToRun;", "doSetupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "configure", "sourceElementRef", "taskNamesWithFilter", "psiPackage", "intellij.android.screenshot-test.gradle"})
public final class ScreenshotTestAllInPackageGradleConfigurationProducer
extends AllInPackageGradleConfigurationProducer {
    @NotNull
    protected String suggestConfigurationName(@NotNull ConfigurationContext context, @NotNull PsiPackage element, @NotNull List<? extends PsiPackage> chosenElements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(chosenElements, (String)"chosenElements");
        return "Screenshot Tests in " + element.getQualifiedName();
    }

    protected boolean doIsConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)configuration.getUserData(ScreenshotTestConfigurationProducerUtilKt.getIS_SCREENSHOT_TEST_CONFIGURATION()), (Object)true)) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        PsiPackage psiPackage = AbstractJavaTestConfigurationProducer.checkPackage((PsiElement)location2.getPsiElement());
        if (psiPackage == null) {
            return false;
        }
        PsiPackage psiPackage2 = psiPackage;
        Module module = AndroidUtils.getAndroidModule((ConfigurationContext)context);
        if (module == null) {
            return false;
        }
        Module androidModule = module;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)androidModule);
        if (androidFacet == null) {
            return false;
        }
        AndroidFacet androidFacet2 = androidFacet;
        if (!ScreenshotTestConfigurationProducerUtilKt.isScreenshotTestSourceSet((Location<PsiElement>)location2, androidFacet2)) {
            return false;
        }
        List list = configuration.getSettings().getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTaskNames(...)");
        List configurationTaskNames = list;
        return Intrinsics.areEqual((Object)configurationTaskNames, this.taskNamesWithFilter(context, psiPackage2));
    }

    @NotNull
    protected List<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> getAllTestsTaskToRun(@NotNull ConfigurationContext context, @NotNull PsiPackage element, @NotNull List<? extends PsiPackage> chosenElements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(chosenElements, (String)"chosenElements");
        List tasksToRun = new ArrayList();
        String testFilter = "--tests \"" + element.getQualifiedName() + ".*\"";
        List<String> list = ScreenshotTestConfigurationProducerUtilKt.getScreenshotTestTaskNames(context);
        if (list == null) {
            return tasksToRun;
        }
        List<String> tasks = list;
        tasksToRun.add(new AbstractGradleTestRunConfigurationProducer.TestTasksToRun((TasksToRun)new TasksToRun.Impl("screenshotTest", tasks), testFilter));
        return tasksToRun;
    }

    protected boolean doSetupConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        if (!((Boolean)StudioFlags.ENABLE_SCREENSHOT_TESTING.get()).booleanValue()) {
            return false;
        }
        boolean configured = this.configure(configuration, sourceElement, context);
        if (configured) {
            configuration.putUserData(GradleRunConfigurationExtension.BooleanOptions.SHOW_TEST_RESULT_IN_ANDROID_TEST_SUITE_VIEW.getUserDataKey(), (Object)true);
            configuration.putUserData(ScreenshotTestConfigurationProducerUtilKt.getIS_SCREENSHOT_TEST_CONFIGURATION(), (Object)true);
        }
        return configured;
    }

    private final boolean configure(GradleRunConfiguration configuration, Ref<PsiElement> sourceElementRef, ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        PsiPackage psiPackage = AbstractJavaTestConfigurationProducer.checkPackage((PsiElement)location2.getPsiElement());
        if (psiPackage == null) {
            return false;
        }
        PsiPackage psiPackage2 = psiPackage;
        Module module = AndroidUtils.getAndroidModule((ConfigurationContext)context);
        if (module == null) {
            return false;
        }
        Module myModule = module;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)myModule);
        if (androidFacet == null) {
            return false;
        }
        AndroidFacet facet = androidFacet;
        if (!ScreenshotTestConfigurationProducerUtilKt.isScreenshotTestSourceSet((Location<PsiElement>)location2, facet)) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        String string = psiPackage2.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        String packageName = string;
        if (((CharSequence)packageName).length() == 0) {
            return false;
        }
        sourceElementRef.set((Object)psiPackage2);
        configuration.getSettings().setExternalProjectPath(project2.getBasePath());
        configuration.getSettings().setTaskNames(this.taskNamesWithFilter(context, psiPackage2));
        configuration.setName(this.suggestConfigurationName(context, psiPackage2, (List<? extends PsiPackage>)CollectionsKt.emptyList()));
        return true;
    }

    private final List<String> taskNamesWithFilter(ConfigurationContext context, PsiPackage psiPackage) {
        List<String> list = ScreenshotTestConfigurationProducerUtilKt.getScreenshotTestTaskNames(context);
        Intrinsics.checkNotNull(list);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)list, (Object)"--tests"), (Object)("\"" + psiPackage.getQualifiedName() + ".*\""));
    }
}

