/*
 * Decompiled with CFR 0.152.
 */
package com.android.screenshottest.action;

import com.android.screenshottest.ui.PreviewDetails;
import com.android.screenshottest.ui.UpdateReferenceImagesDialog;
import com.android.screenshottest.util.UpdateReferenceImagesDialogManager;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResults;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/android/screenshottest/action/UpdateReferenceImagesFromTestPanelAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "testResults", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;", "getTestResults", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;", "setTestResults", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "component", "intellij.android.screenshot-test.gradle"})
public final class UpdateReferenceImagesFromTestPanelAction
extends AnAction
implements CustomComponentAction {
    @NotNull
    private final Logger LOG;
    @Nullable
    private AndroidTestResults testResults;

    public UpdateReferenceImagesFromTestPanelAction() {
        super("Add/Update Reference Images...", "Updates the reference images for screenshot tests", null);
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    @Nullable
    public final AndroidTestResults getTestResults() {
        return this.testResults;
    }

    public final void setTestResults(@Nullable AndroidTestResults androidTestResults) {
        this.testResults = androidTestResults;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.LOG.debug("UpdateReferenceImagesFromTestPanelAction triggered for event: " + e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        AndroidTestResults androidTestResults = this.testResults;
        if (androidTestResults == null) {
            return;
        }
        AndroidTestResults results = androidTestResults;
        UpdateReferenceImagesDialog updateReferenceImagesDialog = UpdateReferenceImagesDialogManager.Companion.getInstance(project2).showOrGetDialog();
        if (updateReferenceImagesDialog == null) {
            return;
        }
        UpdateReferenceImagesDialog dialog = updateReferenceImagesDialog;
        List allTestCases = results.getAllTestCases();
        this.LOG.debug("Processing " + allTestCases.size() + " test cases");
        for (AndroidTestCase testCase : allTestCases) {
            Map artifacts = testCase.getAdditionalTestArtifacts();
            String methodName = (String)artifacts.get("PreviewScreenshot.methodName");
            String previewName = (String)artifacts.get("PreviewScreenshot.previewName");
            if (methodName == null || previewName == null) continue;
            String testId = testCase.getClassName() + "." + methodName + "." + previewName;
            PreviewDetails previewDetails = new PreviewDetails(testId, testCase.getClassName(), methodName, previewName, testCase.getResult(), (String)artifacts.get("PreviewScreenshot.refImagePath"), (String)artifacts.get("PreviewScreenshot.newImagePath"), (String)artifacts.get("PreviewScreenshot.diffImagePath"), (String)artifacts.get("PreviewScreenshot.diffPercent"));
            this.LOG.debug("PreviewDetails: " + previewDetails);
            dialog.updateDialogWithTestResult(previewDetails, testCase.getResult() == AndroidTestCaseResult.FAILED);
        }
        dialog.onTestSuiteFinished();
        dialog.show();
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        JButton jButton;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        JButton $this$createCustomComponent_u24lambda_u240 = jButton = new JButton(presentation.getText());
        boolean bl = false;
        $this$createCustomComponent_u24lambda_u240.setFocusable(true);
        $this$createCustomComponent_u24lambda_u240.setToolTipText(presentation.getDescription());
        $this$createCustomComponent_u24lambda_u240.addActionListener(arg_0 -> UpdateReferenceImagesFromTestPanelAction.createCustomComponent$lambda$0$0($this$createCustomComponent_u24lambda_u240, this, presentation, place, arg_0));
        return jButton;
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (component instanceof JButton) {
            ((JButton)component).setText(presentation.getText());
            ((JButton)component).setEnabled(presentation.isEnabled());
            ((JButton)component).setVisible(presentation.isVisible());
            ((JButton)component).setToolTipText(presentation.getDescription());
        }
    }

    private static final void createCustomComponent$lambda$0$0(JButton $this_apply, UpdateReferenceImagesFromTestPanelAction this$0, Presentation $presentation, String $place, ActionEvent it) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)$this_apply);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)this$0, (DataContext)dataContext2, (Presentation)$presentation, (String)$place, (ActionUiKind)((ActionUiKind)ActionUiKind.TOOLBAR), null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        this$0.actionPerformed(event);
    }
}

