/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.sync;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.stats.MemoryProbe;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.NdkProjectInfo;
import com.android.tools.ndk.sync.NativeWorkspaceClientType;
import com.android.tools.ndk.sync.NativeWorkspaceImpl;
import com.android.tools.ndk.sync.NativeWorkspaceModifier;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleCppSyncStats;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0017J\b\u0010\u0019\u001a\u00020\u0015H\u0017R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/ndk/sync/NativeWorkspaceModificationTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "nativeWorkspaceModifiers", "", "Lcom/android/tools/ndk/sync/NativeWorkspaceModifier;", "clientType", "Lcom/android/tools/ndk/sync/NativeWorkspaceClientType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;Ljava/util/Collection;Lcom/android/tools/ndk/sync/NativeWorkspaceClientType;)V", "startedMs", "", "nativeModuleStats", "", "Lcom/google/wireless/android/sdk/stats/GradleCppSyncStats$NativeModuleStats;", "nativeWorkspace", "Lcom/android/tools/ndk/sync/NativeWorkspaceImpl;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onSuccess", "onFinished", "Companion", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nNativeWorkspaceModificationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeWorkspaceModificationTask.kt\ncom/android/tools/ndk/sync/NativeWorkspaceModificationTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,148:1\n1491#2:149\n1516#2,3:150\n1519#2,3:160\n1869#2,2:163\n382#3,7:153\n*S KotlinDebug\n*F\n+ 1 NativeWorkspaceModificationTask.kt\ncom/android/tools/ndk/sync/NativeWorkspaceModificationTask\n*L\n70#1:149\n70#1:150,3\n70#1:160,3\n72#1:163,2\n70#1:153,7\n*E\n"})
public final class NativeWorkspaceModificationTask
extends Task.Modal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<NativeWorkspaceModifier> nativeWorkspaceModifiers;
    private long startedMs;
    @NotNull
    private final List<GradleCppSyncStats.NativeModuleStats> nativeModuleStats;
    @NotNull
    private final NativeWorkspaceImpl nativeWorkspace;
    @NotNull
    private static final Logger logger;

    public NativeWorkspaceModificationTask(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<? extends NativeWorkspaceModifier> nativeWorkspaceModifiers, @NotNull NativeWorkspaceClientType clientType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter(nativeWorkspaceModifiers, (String)"nativeWorkspaceModifiers");
        Intrinsics.checkNotNullParameter((Object)((Object)clientType), (String)"clientType");
        super(project, "Resolving C/C++ Configurations", true);
        this.nativeWorkspaceModifiers = nativeWorkspaceModifiers;
        this.nativeModuleStats = new ArrayList();
        if (this.nativeWorkspaceModifiers.isEmpty()) {
            throw new IllegalStateException("Shouldn't call with empty modifiers".toString());
        }
        this.nativeWorkspace = new NativeWorkspaceImpl(project, modelsProvider, false, clientType, 4, null);
    }

    public /* synthetic */ NativeWorkspaceModificationTask(Project project, IdeModifiableModelsProvider ideModifiableModelsProvider, Collection collection, NativeWorkspaceClientType nativeWorkspaceClientType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            nativeWorkspaceClientType = NativeWorkspaceClientType.ANDROID_STUDIO;
        }
        this(project, ideModifiableModelsProvider, collection, nativeWorkspaceClientType);
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.startedMs = System.currentTimeMillis();
        indicator.setIndeterminate(false);
        Ref.IntRef index = new Ref.IntRef();
        index.element = 1;
        Iterable $this$groupBy$iv = this.nativeWorkspaceModifiers;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            NativeWorkspaceModifier it = (NativeWorkspaceModifier)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getModule();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        destination$iv$iv.forEach((arg_0, arg_1) -> NativeWorkspaceModificationTask.run$lambda$2((arg_0, arg_1) -> NativeWorkspaceModificationTask.run$lambda$1(this, indicator, index, arg_0, arg_1), arg_0, arg_1));
        this.nativeWorkspace.preCommit((ProgressIndicator)new StandardProgressIndicator(indicator){
            private final /* synthetic */ StandardProgressIndicator $$delegate_0;
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                Intrinsics.checkNotNull((Object)$indicator, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.StandardProgressIndicator");
                this.$$delegate_0 = (StandardProgressIndicator)$indicator;
            }

            public void setFraction(double fraction) {
                this.$indicator.setFraction(fraction * 0.5 + 0.5);
            }

            public void start() {
                this.$$delegate_0.start();
            }

            public void stop() {
                this.$$delegate_0.stop();
            }

            public boolean isRunning() {
                return this.$$delegate_0.isRunning();
            }

            public void cancel() {
                this.$$delegate_0.cancel();
            }

            public boolean isCanceled() {
                return this.$$delegate_0.isCanceled();
            }

            public void setText(@NlsContexts.ProgressText String p0) {
                this.$$delegate_0.setText(p0);
            }

            @NlsContexts.ProgressText
            public String getText() {
                return this.$$delegate_0.getText();
            }

            public void setText2(@NlsContexts.ProgressDetails String p0) {
                this.$$delegate_0.setText2(p0);
            }

            @NlsContexts.ProgressDetails
            public String getText2() {
                return this.$$delegate_0.getText2();
            }

            public double getFraction() {
                return this.$$delegate_0.getFraction();
            }

            public void pushState() {
                this.$$delegate_0.pushState();
            }

            public void popState() {
                this.$$delegate_0.popState();
            }

            public boolean isModal() {
                return this.$$delegate_0.isModal();
            }

            @NotNull
            public ModalityState getModalityState() {
                ModalityState modalityState = this.$$delegate_0.getModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"getModalityState(...)");
                return modalityState;
            }

            public void setModalityProgress(@Nullable ProgressIndicator p0) {
                this.$$delegate_0.setModalityProgress(p0);
            }

            public boolean isIndeterminate() {
                return this.$$delegate_0.isIndeterminate();
            }

            public void setIndeterminate(boolean p0) {
                this.$$delegate_0.setIndeterminate(p0);
            }

            public void checkCanceled() {
                this.$$delegate_0.checkCanceled();
            }

            public boolean isPopupWasShown() {
                return this.$$delegate_0.isPopupWasShown();
            }

            public boolean isShowing() {
                return this.$$delegate_0.isShowing();
            }
        });
    }

    @UiThread
    public void onSuccess() {
        super.onSuccess();
        if (!this.getProject().isDisposed()) {
            this.nativeWorkspace.commit();
        }
    }

    @UiThread
    public void onFinished() {
        boolean hasNative;
        super.onFinished();
        this.nativeWorkspace.dispose();
        boolean bl = hasNative = !this.nativeWorkspaceModifiers.isEmpty();
        if (hasNative) {
            GradleCppSyncStats.Builder builder;
            AndroidStudioEvent.Builder builder2;
            long syncTimeMs = System.currentTimeMillis() - this.startedMs;
            logger.info("Updating model took " + (double)this.startedMs / 1000.0 + "s");
            AndroidStudioEvent.Builder $this$onFinished_u24lambda_u240 = builder2 = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_CPP_SYNC_COMPLETED);
            boolean bl2 = false;
            GradleCppSyncStats.Builder $this$onFinished_u24lambda_u240_u240 = builder = $this$onFinished_u24lambda_u240.getGradleCppSyncStatsBuilder();
            boolean bl3 = false;
            $this$onFinished_u24lambda_u240_u240.setNativeWorkspaceSyncTimeMs(syncTimeMs);
            $this$onFinished_u24lambda_u240_u240.addAllSyncedNativeModuleStats((Iterable)this.nativeModuleStats);
            if (Random.Default.nextInt(100) == 0) {
                Object[] objectArray = new String[]{"com.jetbrains.cidr.lang.", String.class.getPackage().getName() + ".", File.class.getPackage().getName() + ".", com.google.common.collect.ImmutableList.class.getPackage().getName() + ".", ImmutableList.class.getPackage().getName() + ".", List.class.getPackage().getName() + ".", Object.class.getPackage().getName() + ".", ArrayList.class.getPackage().getName() + "."};
                MemoryProbe memoryProbe = new MemoryProbe(CollectionsKt.listOf((Object[])objectArray), null, null, false, null, 30, null);
                OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(...)");
                long size = memoryProbe.check((Object)oCWorkspace);
                $this$onFinished_u24lambda_u240_u240.setCidrWorkspaceSize((int)size);
                logger.info("OCWorkspace size = " + (double)size / 1024.0 / 1024.0 + "MiB");
            }
            AndroidStudioEvent.Builder builder3 = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"apply(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder3, (Project)this.getProject()));
        } else {
            logger.info("NDK support for project '" + this.getProject().getName() + "' is disabled because the project doesn't contain any valid native configurations.");
        }
        NdkProjectInfo.get(this.getProject()).setHasNdkModules(hasNative);
        NdkHelper.disableCppLanguageSupport(this.getProject(), !hasNative);
    }

    private static final Unit run$lambda$1(NativeWorkspaceModificationTask this$0, ProgressIndicator $indicator, Ref.IntRef $index, String module, List modifiers) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        this$0.nativeWorkspace.setModule(module);
        Iterable $this$forEach$iv = modifiers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NativeWorkspaceModifier modifier = (NativeWorkspaceModifier)element$iv;
            boolean bl = false;
            $indicator.checkCanceled();
            $indicator.setText("Processing module " + module + "...");
            int n = $index.element;
            $index.element = n + 1;
            $indicator.setFraction(0.5 * (double)n / (double)this$0.nativeWorkspaceModifiers.size());
            modifier.modify(this$0.nativeWorkspace);
        }
        ((Collection)this$0.nativeModuleStats).add(this$0.nativeWorkspace.getStatsForCurrentModule());
        return Unit.INSTANCE;
    }

    private static final void run$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    static {
        Logger logger = Logger.getInstance(NativeWorkspaceModificationTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        NativeWorkspaceModificationTask.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/ndk/sync/NativeWorkspaceModificationTask$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

