/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.run.editor.HybridDebuggerSettings;
import com.android.tools.ndk.run.hybrid.AndroidNativeHybridDebugProcess;
import com.android.tools.ndk.run.hybrid.MethodCollector;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.psi.KtFunction;

public class AndroidJavaDebugProcess
extends JavaDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidJavaDebugProcess.class);
    private static final String TID_EXPRESSION = "android.os.Process.myTid()";
    private final DebuggerSession myJavaSession;
    private final Project myProject;
    private final AndroidNativeHybridDebugProcess myNativeDebugProcess;
    private final XSmartStepIntoHandler<?> mySmartStepIntoHandler = new SmartStepIntoHandlerImpl();
    private XSourcePosition myPauseSourcePosition;
    private ListenableFuture<Integer> myCurrentTidFuture;
    private boolean myCanPerformCommands = true;

    public static JavaDebugProcess create(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession, final @NotNull AndroidNativeHybridDebugProcess nativeDebugProcess) {
        AndroidJavaDebugProcess res = new AndroidJavaDebugProcess(session, javaSession, nativeDebugProcess);
        javaSession.getProcess().setXDebugProcess((JavaDebugProcess)res);
        nativeDebugProcess.setJavaSession(session);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                nativeDebugProcess.unsetJavaSession();
            }
        });
        return res;
    }

    private AndroidJavaDebugProcess(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession, @NotNull AndroidNativeHybridDebugProcess nativeDebugProcess) {
        super(session, javaSession);
        this.myJavaSession = javaSession;
        this.myNativeDebugProcess = nativeDebugProcess;
        this.myProject = javaSession.getProject();
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }

            public void stackFrameChanged() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }
        });
    }

    @NotNull
    private static ListenableFuture<Integer> getCurrentThreadIdFuture(@Nullable XSourcePosition sourcePosition, @NotNull XDebuggerEvaluator evaluator) {
        final SettableFuture futureResult = SettableFuture.create();
        XDebuggerEvaluator.XEvaluationCallback evaluationCallback = new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result instanceof JavaValue) {
                    JavaValue jValue = (JavaValue)result;
                    futureResult.set((Object)Integer.parseInt(jValue.getDescriptor().getValue().toString()));
                } else {
                    futureResult.setException((Throwable)new EvaluateException("Unexpected value type: " + result.toString()));
                }
            }

            public void errorOccurred(@NotNull String errorMessage) {
                futureResult.setException((Throwable)new EvaluateException("Evaluation failed: " + errorMessage));
            }
        };
        evaluator.evaluate(TID_EXPRESSION, evaluationCallback, sourcePosition);
        return futureResult;
    }

    private void updateSourcePosition() {
        if (this.myCurrentTidFuture != null) {
            this.myCurrentTidFuture.cancel(true);
            this.myCurrentTidFuture = null;
        }
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        XDebuggerEvaluator evaluator = this.getEvaluator();
        if (frame != null && evaluator != null) {
            this.myPauseSourcePosition = frame.getSourcePosition();
            this.myCurrentTidFuture = AndroidJavaDebugProcess.getCurrentThreadIdFuture(this.myPauseSourcePosition, evaluator);
        } else {
            this.myPauseSourcePosition = null;
        }
    }

    private void setupNativeBreakpoints(int tid) {
        LinkedList jniMethodNames = Lists.newLinkedList();
        ApplicationManager.getApplication().runReadAction(() -> jniMethodNames.addAll(this.findNativeMethodsInCurrentSourcePosition()));
        for (String jniMethodName : jniMethodNames) {
            this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(jniMethodName, tid);
        }
    }

    @NotNull
    private List<String> findNativeMethodsInCurrentSourcePosition() {
        List<JvmMethodInfo> methods = this.findJvmMethodsBySourcePosition(this.myPauseSourcePosition);
        ArrayList<String> jniMethodNames = new ArrayList<String>();
        for (JvmMethodInfo method : methods) {
            if (!method.isNative()) continue;
            jniMethodNames.addAll(AndroidJavaDebugProcess.getCorrespondingJniFunctionNames(method));
        }
        return jniMethodNames;
    }

    @NotNull
    private List<JvmMethodInfo> findJvmMethodsBySourcePosition(@NotNull XSourcePosition position) {
        MethodCollector methodCollector = new MethodCollector(this.myProject, position);
        return methodCollector.getMethods();
    }

    @NotNull
    private static List<String> getCorrespondingJniFunctionNames(JvmMethodInfo info) {
        return JniMethodResolver.getInstance(info.getPsiElement().getProject()).resolveJavaOrKotlinMethod(info).stream().map(nativeMethodInfo -> nativeMethodInfo.getNativeMethodId().getFunctionName()).distinct().collect(Collectors.toList());
    }

    public boolean checkCanPerformCommands() {
        return this.myCanPerformCommands;
    }

    private void initNativeSteppingInto(Runnable callSuperStartStepInto, boolean isSmartStep) {
        if (this.myPauseSourcePosition == null || this.myCurrentTidFuture == null) {
            return;
        }
        this.myCanPerformCommands = false;
        this.myCurrentTidFuture.addListener(() -> {
            try {
                if (!isSmartStep) {
                    int currentTid = (Integer)this.myCurrentTidFuture.get();
                    this.setupNativeBreakpoints(currentTid);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                try {
                    callSuperStartStepInto.run();
                }
                finally {
                    this.myCanPerformCommands = true;
                }
            }
        }, r -> ApplicationManager.getApplication().invokeLater(r));
    }

    private void removeAllStepIntoNativeMethodBreakpoints() {
        this.myNativeDebugProcess.removeAllStepIntoNativeBreakpoints();
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.prepareToResume();
        this.initNativeSteppingInto(() -> super.startStepInto(context), false);
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.prepareToResume();
        this.initNativeSteppingInto(() -> super.startForceStepInto(context), false);
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.prepareToResume();
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.startStepOver(context);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        this.prepareToResume();
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.runToPosition(position, context);
    }

    public void resume(@Nullable XSuspendContext context) {
        this.prepareToResume();
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.resume(context);
    }

    private void prepareToResume() {
        XVariablesView.InlineVariablesInfo.set((XDebugSession)this.getSession(), null);
    }

    public void stop() {
        super.stop();
        this.myNativeDebugProcess.getSession().stop();
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    @VisibleForTesting
    public class SmartStepIntoHandlerImpl
    extends XSmartStepIntoHandler<XSmartStepIntoVariantImpl> {
        @NotNull
        public List<XSmartStepIntoVariantImpl> computeSmartStepVariants(@NotNull XSourcePosition position) {
            MethodCollector methodCollector = new MethodCollector(AndroidJavaDebugProcess.this.myProject, position);
            List<JvmMethodInfo> methods = methodCollector.getMethods();
            List<PsiElement> highlightElements = methodCollector.getHighlightElements();
            ArrayList variants = Lists.newArrayListWithExpectedSize((int)methods.size());
            Range<Integer> lineRange = methodCollector.getLineRange();
            if (lineRange != null) {
                for (int i = 0; i < methods.size(); ++i) {
                    JvmMethodInfo method = methods.get(i);
                    PsiElement highlightElement = highlightElements.get(i);
                    variants.add(new XSmartStepIntoVariantImpl(method, highlightElement, lineRange));
                }
            }
            return variants;
        }

        @NotNull
        public Promise<List<XSmartStepIntoVariantImpl>> computeStepIntoVariants(@NotNull XSourcePosition position) {
            if (HybridDebuggerSettings.getInstance().ALWAYS_SMART_STEP_INTO) {
                return Promises.resolvedPromise(this.computeSmartStepVariants(position));
            }
            return super.computeStepIntoVariants(position);
        }

        public void startStepInto(@NotNull XSmartStepIntoVariantImpl variant) {
            JvmMethodInfo method = variant.getMethod();
            if (!method.isNative()) {
                if (method.getPsiElement() instanceof PsiMethod) {
                    AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new BasicStepMethodFilter((PsiMethod)method.getPsiElement(), variant.getLineRange()));
                } else if (method.getPsiElement() instanceof KtFunction) {
                    PsiMethod psiMethod = LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)method.getPsiElement());
                    if (psiMethod != null) {
                        AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new BasicStepMethodFilter(psiMethod, variant.getLineRange()));
                    }
                } else {
                    AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, null);
                }
                return;
            }
            AndroidJavaDebugProcess.this.initNativeSteppingInto(() -> {
                List<String> functionNames = AndroidJavaDebugProcess.getCorrespondingJniFunctionNames(method);
                if (functionNames.isEmpty()) {
                    return;
                }
                if (functionNames.size() > 1) {
                    LOG.warn(String.format("Found multiple JNI functions %s corresponding to method '%s'. Using the first one.", functionNames, method.getMethodName()));
                }
                try {
                    XBreakpoint<StepIntoNativeBreakpointType.Properties> bp = AndroidJavaDebugProcess.this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(functionNames.get(0), ((Integer)AndroidJavaDebugProcess.this.myCurrentTidFuture.get()).intValue());
                    AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new NativeMethodFilter(bp, variant.getLineRange()));
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }, true);
        }

        public String getPopupTitle(@NotNull XSourcePosition position) {
            return "Method to Step Into";
        }
    }

    @VisibleForTesting
    public static class XSmartStepIntoVariantImpl
    extends XSmartStepIntoVariant {
        private final JvmMethodInfo myMethod;
        private final PsiElement myHighlightElement;
        private final Range<Integer> myLineRange;

        public XSmartStepIntoVariantImpl(@NotNull JvmMethodInfo method, @NotNull PsiElement highlightElement, @NotNull Range<Integer> lineRange) {
            this.myMethod = method;
            this.myLineRange = lineRange;
            this.myHighlightElement = highlightElement;
        }

        public String getText() {
            return this.myMethod.getPsiElement().getText();
        }

        @NotNull
        public Range<Integer> getLineRange() {
            return this.myLineRange;
        }

        @NotNull
        public JvmMethodInfo getMethod() {
            return this.myMethod;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return this.myHighlightElement.getTextRange();
        }
    }

    private static class NativeMethodFilter
    implements MethodFilter {
        private final XBreakpoint<StepIntoNativeBreakpointType.Properties> myBp;
        private final Range<Integer> myLineRange;

        public NativeMethodFilter(@NotNull XBreakpoint<StepIntoNativeBreakpointType.Properties> bp, @NotNull Range<Integer> lineRange) {
            this.myBp = bp;
            this.myLineRange = lineRange;
        }

        public boolean locationMatches(@NotNull DebugProcessImpl process, @NotNull Location location) {
            return ((StepIntoNativeBreakpointType.Properties)this.myBp.getProperties()).isCalled();
        }

        @Nullable
        public Range<Integer> getCallingExpressionLines() {
            return this.myLineRange;
        }
    }
}

