/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.gradle.model.IdeSourceProvider;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.NativeDebuggerAppContext;
import com.android.tools.ndk.run.SymbolDir;
import com.android.utils.FileUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNativeDebuggerAppContext
implements NativeDebuggerAppContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final String myApplicationId;

    public DefaultNativeDebuggerAppContext(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull String applicationId) {
        this.myProject = project;
        this.myFacet = facet;
        this.myApplicationId = applicationId;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    private ApkFacet getApkFacet() {
        if (this.myFacet == null) {
            return null;
        }
        return ApkFacet.getInstance((Module)this.myFacet.getModule());
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.myApplicationId;
    }

    @Override
    @NotNull
    public Collection<SymbolDir> getSymDirs(@NotNull List<Abi> abis) {
        if (this.myFacet == null) {
            return Collections.emptyList();
        }
        return DefaultNativeDebuggerAppContext.collectSymDirs(this.myFacet, abis);
    }

    @Override
    @NotNull
    public Map<String, String> getSourceMap() {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        ApkFacet apkFacet = this.getApkFacet();
        if (apkFacet != null) {
            for (Map.Entry entry : ((ApkFacetConfiguration)apkFacet.getConfiguration()).getSymbolFolderPathMappings().entrySet()) {
                if (((String)entry.getValue()).isEmpty() || ((String)entry.getKey()).equals(entry.getValue())) continue;
                sourceMap.put((String)entry.getKey(), (String)entry.getValue());
                if (FileUtil.isAbsolutePlatformIndependent((String)((String)entry.getKey()))) continue;
                String keyWithLeadingDot = FileUtil.toSystemDependentName((String)("./" + (String)entry.getKey()));
                sourceMap.put(keyWithLeadingDot, (String)entry.getValue());
            }
        }
        return sourceMap;
    }

    @Override
    @NotNull
    public Map<File, File> getExplicitModuleSymbolMap(@NotNull Abi abi) {
        ApkFacet apkFacet = this.getApkFacet();
        if (apkFacet == null) {
            return Collections.emptyMap();
        }
        return ((ApkFacetConfiguration)apkFacet.getConfiguration()).getExplicitModuleSymbolMap(abi);
    }

    @Override
    @NotNull
    public Collection<Module> getModulesToVerify() {
        if (this.myFacet == null) {
            return Collections.emptyList();
        }
        return DefaultNativeDebuggerAppContext.getModulesToVerify(this.myFacet);
    }

    @NotNull
    private static Collection<Module> getModulesToVerify(@NotNull AndroidFacet facet) {
        Module module = ModuleSystemUtil.getProductionAndroidModule((AndroidFacet)facet);
        HashSet<Module> depModules = new HashSet<Module>();
        ModuleUtilCore.getDependencies((Module)module, depModules);
        return depModules;
    }

    @NotNull
    private static List<SymbolDir> collectSymDirs(@NotNull AndroidFacet facet, @NotNull List<Abi> abis) {
        GradleAndroidModel androidModel;
        ArrayList<SymbolDir> symDirs = new ArrayList<SymbolDir>();
        Module mainModule = ModuleSystemUtil.getProductionAndroidModule((AndroidFacet)facet);
        ApkFacet apkFacet = ApkFacet.getInstance((Module)mainModule);
        if (apkFacet != null) {
            ((ApkFacetConfiguration)apkFacet.getConfiguration()).getDebugSymbolFolderPaths(abis).stream().map(it -> new SymbolDir.WithSubdirectories(new File(FileUtils.toSystemDependentPath((String)it)))).forEach(symDirs::add);
        }
        if ((androidModel = GradleAndroidModel.get((AndroidFacet)facet)) != null) {
            for (IdeSourceProvider sourceProvider : androidModel.getActiveSourceProviders()) {
                for (File jniLib : sourceProvider.getJniLibsDirectories()) {
                    if (!jniLib.exists()) continue;
                    for (Abi abi : abis) {
                        File abiJniLib = new File(jniLib, abi.toString());
                        if (!abiJniLib.exists()) continue;
                        symDirs.add(new SymbolDir.WithoutSubdirectories(abiJniLib));
                    }
                }
            }
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(mainModule);
        Module androidTestModule = LinkedAndroidModuleGroupUtilsKt.getAndroidTestModule((Module)mainModule);
        if (androidTestModule != null) {
            modules.add(androidTestModule);
        }
        for (Module module : modules) {
            HashSet depModules = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, depModules);
            Set<String> abiSet = AndroidNativeAppDebugProcess.getAbiNameSet(abis);
            for (Module depModule : depModules) {
                NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)depModule);
                NdkFacet ndkFacet = NdkFacet.getInstance((Module)depModule);
                if (ndkModuleModel == null || ndkFacet == null) continue;
                ndkModuleModel.getSymbolFolders().forEach((variantAbi, symbolFolders) -> {
                    VariantAbi selectedVariantAbi = ndkFacet.getSelectedVariantAbi();
                    if (selectedVariantAbi == null) {
                        return;
                    }
                    if (abiSet.contains(variantAbi.getAbi()) && variantAbi.getVariant().equals(selectedVariantAbi.getVariant())) {
                        symbolFolders.stream().map(SymbolDir.WithoutSubdirectories::new).forEach(symDirs::add);
                    }
                });
            }
        }
        return symDirs;
    }
}

