/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.service;

import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.service.GlobalNativeMethodIndex;
import com.android.tools.ndk.jni.service.GlobalNativeMethodIndexKt;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.service.SimpleNativeMethodId;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0019H\u0002J,\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u001c2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0019J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&H\u0002\u00a8\u0006'"}, d2={"Lcom/android/tools/ndk/jni/service/GlobalNativeMethodIndex;", "Lcom/intellij/util/indexing/ScalarIndexExtension;", "Lcom/android/tools/ndk/jni/service/SimpleNativeMethodId;", "<init>", "()V", "getVersion", "", "getName", "Lcom/intellij/util/indexing/ID;", "Ljava/lang/Void;", "dependsOnFileContent", "", "indexDirectories", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getKeyDescriptor", "Lcom/android/tools/ndk/jni/service/SimpleNativeMethodId$Descriptor;", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "processJavaFile", "", "psiFile", "Lcom/intellij/psi/PsiJavaFile;", "results", "", "processKotlinFile", "fileContent", "Lorg/jetbrains/kotlin/psi/KtFile;", "hasDumbJvmStatic", "element", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "getDumbJvmName", "", "getDumbFileJvmName", "file", "extractStringLiteral", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nGlobalNativeMethodIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalNativeMethodIndex.kt\ncom/android/tools/ndk/jni/service/GlobalNativeMethodIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1761#2,3:416\n295#2,2:419\n295#2,2:422\n1#3:421\n*S KotlinDebug\n*F\n+ 1 GlobalNativeMethodIndex.kt\ncom/android/tools/ndk/jni/service/GlobalNativeMethodIndex\n*L\n299#1:416,3\n311#1:419,2\n328#1:422,2\n*E\n"})
public final class GlobalNativeMethodIndex
extends ScalarIndexExtension<SimpleNativeMethodId> {
    public int getVersion() {
        return 4;
    }

    @NotNull
    public ID<SimpleNativeMethodId, Void> getName() {
        return GlobalNativeMethodIndexKt.getGLOBAL_NATIVE_METHOD_INDEX_ID();
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public boolean indexDirectories() {
        return false;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return GlobalNativeMethodIndex::getInputFilter$lambda$0;
    }

    @NotNull
    public SimpleNativeMethodId.Descriptor getKeyDescriptor() {
        return SimpleNativeMethodId.Descriptor.INSTANCE;
    }

    @NotNull
    public DataIndexer<SimpleNativeMethodId, Void, FileContent> getIndexer() {
        return arg_0 -> GlobalNativeMethodIndex.getIndexer$lambda$0(this, arg_0);
    }

    private final void processJavaFile(PsiJavaFile psiFile, Map<SimpleNativeMethodId, Void> results) {
        List list;
        String string = psiFile.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        if (((CharSequence)packageName).length() == 0) {
            list = CollectionsKt.emptyList();
        } else {
            char[] cArray = new char[]{'.'};
            list = StringsKt.split$default((CharSequence)packageName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        List packageList = list;
        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(packageList, results){
            private final ArrayDeque<String> classFqnStack;
            final /* synthetic */ List<String> $packageList;
            final /* synthetic */ Map<SimpleNativeMethodId, Void> $results;
            {
                this.$packageList = $packageList;
                this.$results = $results;
                this.classFqnStack = new ArrayDeque<E>();
            }

            public final ArrayDeque<String> getClassFqnStack() {
                return this.classFqnStack;
            }

            public void visitClass(PsiClass aClass) {
                Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
                if (aClass.getName() == null) {
                    return;
                }
                String string = aClass.getName();
                Intrinsics.checkNotNull((Object)string);
                this.classFqnStack.push(string);
                super.visitClass(aClass);
                this.classFqnStack.pop();
            }

            public void visitMethod(PsiMethod method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                super.visitMethod(method);
                if (!method.getModifierList().hasModifierProperty("native") || this.classFqnStack.isEmpty()) {
                    return;
                }
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String methodName = string;
                SequencedCollection sequencedCollection = this.classFqnStack.reversed();
                Intrinsics.checkNotNullExpressionValue((Object)sequencedCollection, (String)"reversed(...)");
                List classList = CollectionsKt.toList((Iterable)sequencedCollection);
                FullyQualifiedClassName className = new FullyQualifiedClassName(this.$packageList, classList);
                this.$results.put(new SimpleNativeMethodId(className, methodName), null);
            }
        });
    }

    public final void processKotlinFile(@NotNull FileContent fileContent, @NotNull KtFile psiFile, @NotNull Map<SimpleNativeMethodId, Void> results) {
        List list;
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        String packageName = psiFile.getPackageFqName().asString();
        if (((CharSequence)packageName).length() == 0) {
            list = CollectionsKt.emptyList();
        } else {
            char[] cArray = new char[]{'.'};
            list = StringsKt.split$default((CharSequence)packageName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        List packageList = list;
        psiFile.accept((PsiElementVisitor)new KtTreeVisitorVoid(this, psiFile, packageList, results, fileContent){
            private final ArrayDeque<String> classFqnStack;
            final /* synthetic */ GlobalNativeMethodIndex this$0;
            final /* synthetic */ KtFile $psiFile;
            final /* synthetic */ List<String> $packageList;
            final /* synthetic */ Map<SimpleNativeMethodId, Void> $results;
            final /* synthetic */ FileContent $fileContent;
            {
                this.this$0 = $receiver;
                this.$psiFile = $psiFile;
                this.$packageList = $packageList;
                this.$results = $results;
                this.$fileContent = $fileContent;
                this.classFqnStack = new ArrayDeque<E>();
            }

            public final ArrayDeque<String> getClassFqnStack() {
                return this.classFqnStack;
            }

            public void visitClassOrObject(KtClassOrObject classOrObject) {
                Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
                String className = classOrObject.getName();
                if (classOrObject instanceof KtObjectDeclaration && className == null) {
                    return;
                }
                if (classOrObject.isLocal()) {
                    return;
                }
                if (className == null) {
                    super.visitClassOrObject(classOrObject);
                    return;
                }
                this.classFqnStack.push(className);
                super.visitClassOrObject(classOrObject);
                this.classFqnStack.pop();
            }

            /*
             * WARNING - void declaration
             */
            public void visitNamedFunction(KtNamedFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                super.visitNamedFunction(function);
                if (!function.hasModifier(KtTokens.EXTERNAL_KEYWORD)) {
                    return;
                }
                String string = GlobalNativeMethodIndex.access$getDumbJvmName(this.this$0, (KtAnnotated)function);
                if (string == null && (string = function.getName()) == null) {
                    return;
                }
                String methodName = string;
                boolean isCompanion = false;
                List classList = null;
                SequencedCollection sequencedCollection = this.classFqnStack.reversed();
                Intrinsics.checkNotNullExpressionValue((Object)sequencedCollection, (String)"reversed(...)");
                List classFqnParts = CollectionsKt.toList((Iterable)sequencedCollection);
                if (classFqnParts.isEmpty()) {
                    isCompanion = false;
                    Object object = GlobalNativeMethodIndex.access$getDumbFileJvmName(this.this$0, this.$psiFile);
                    if (object == null) {
                        String string2;
                        String fileName;
                        processKotlinFile.1 var8_6 = this;
                        FileContent fileContent = this.$fileContent;
                        processKotlinFile.1 $this$visitNamedFunction_u24lambda_u240 = var8_6;
                        boolean bl = false;
                        String string3 = FileUtil.getNameWithoutExtension((String)fileContent.getFileName());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(...)");
                        String string4 = fileName = string3;
                        if (((CharSequence)string4).length() > 0) {
                            void it;
                            char c = string4.charAt(0);
                            StringBuilder stringBuilder = new StringBuilder();
                            boolean bl2 = false;
                            StringBuilder stringBuilder2 = stringBuilder.append((Object)(Character.isLowerCase((char)it) ? CharsKt.titlecase((char)it) : String.valueOf((char)it)));
                            String string5 = string4;
                            int n = 1;
                            String string6 = string5.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                            string2 = stringBuilder2.append(string6).toString();
                        } else {
                            string2 = string4;
                        }
                        object = string2 + "Kt";
                    }
                    String fileJvmName = object;
                    classList = CollectionsKt.listOf((Object)fileJvmName);
                } else {
                    KtObjectDeclaration parentObject;
                    PsiElement psiElement = function.getParent();
                    KtClassBody ktClassBody = psiElement instanceof KtClassBody ? (KtClassBody)psiElement : null;
                    PsiElement psiElement2 = ktClassBody != null ? ktClassBody.getParent() : null;
                    KtObjectDeclaration ktObjectDeclaration = parentObject = psiElement2 instanceof KtObjectDeclaration ? (KtObjectDeclaration)psiElement2 : null;
                    isCompanion = ktObjectDeclaration != null ? ktObjectDeclaration.isCompanion() : false;
                    classList = classFqnParts;
                }
                FullyQualifiedClassName className = new FullyQualifiedClassName(this.$packageList, classList);
                this.$results.put(new SimpleNativeMethodId(className, methodName), null);
                if (isCompanion && GlobalNativeMethodIndex.access$hasDumbJvmStatic(this.this$0, (KtAnnotated)function) && classFqnParts.size() >= 2) {
                    List outerClassList = CollectionsKt.dropLast((List)classFqnParts, (int)1);
                    FullyQualifiedClassName outerClassName = new FullyQualifiedClassName(this.$packageList, outerClassList);
                    this.$results.put(new SimpleNativeMethodId(outerClassName, methodName), null);
                }
            }
        });
    }

    private final boolean hasDumbJvmStatic(KtAnnotated element) {
        boolean bl;
        block3: {
            List list = element.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    Name name = it.getShortName();
                    if (!Intrinsics.areEqual((Object)(name != null ? name.asString() : null), (Object)"JvmStatic")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getDumbJvmName(KtAnnotated element) {
        String string;
        ValueArgument valueArgument;
        List list;
        Object v2;
        KtAnnotationEntry it;
        KtExpression ktExpression;
        block3: {
            List list2 = element.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            ktExpression = $this$firstOrNull$iv.iterator();
            while (ktExpression.hasNext()) {
                Object element$iv = ktExpression.next();
                it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                Name name = it.getShortName();
                if (!Intrinsics.areEqual((Object)(name != null ? name.asString() : null), (Object)"JvmName")) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v2;
        if (ktAnnotationEntry != null && (list = ktAnnotationEntry.getValueArguments()) != null && (valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list)) != null && (ktExpression = valueArgument.getArgumentExpression()) != null) {
            it = ktExpression;
            boolean bl = false;
            string = this.extractStringLiteral((KtExpression)it);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getDumbFileJvmName(KtFile file) {
        Object v1;
        KtAnnotationEntry it;
        Iterable iterable;
        block1: {
            void $this$firstOrNull$iv;
            KtFileAnnotationList ktFileAnnotationList = file.getFileAnnotationList();
            if (ktFileAnnotationList == null) return null;
            List list = ktFileAnnotationList.getAnnotationEntries();
            if (list == null) return null;
            iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                Name name = it.getShortName();
                if (!Intrinsics.areEqual((Object)(name != null ? name.asString() : null), (Object)"JvmName")) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v1;
        if (ktAnnotationEntry == null) return null;
        iterable = ktAnnotationEntry.getValueArguments();
        if (iterable == null) return null;
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)iterable);
        if (valueArgument == null) return null;
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) return null;
        it = ktExpression;
        boolean bl = false;
        String string = this.extractStringLiteral((KtExpression)it);
        return string;
    }

    private final String extractStringLiteral(KtExpression expr) {
        String string;
        KtStringTemplateEntry ktStringTemplateEntry;
        Object[] objectArray;
        KtStringTemplateExpression ktStringTemplateExpression;
        KtStringTemplateExpression ktStringTemplateExpression2 = ktStringTemplateExpression = expr instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)expr : null;
        if (ktStringTemplateExpression != null && (objectArray = ktStringTemplateExpression.getEntries()) != null && (ktStringTemplateEntry = (KtStringTemplateEntry)ArraysKt.firstOrNull((Object[])objectArray)) != null) {
            KtStringTemplateEntry it = ktStringTemplateEntry;
            boolean bl = false;
            KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = it instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)it : null;
            string = ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean getInputFilter$lambda$0(VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Object[] objectArray = new LanguageFileType[]{JavaFileType.INSTANCE, KotlinFileType.INSTANCE};
        return CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)virtualFile.getFileType()) && GlobalNativeMethodIndexKt.access$isProjectFile(virtualFile);
    }

    private static final Map getIndexer$lambda$0(GlobalNativeMethodIndex this$0, FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        FileContentImpl fileContentImpl = fileContent instanceof FileContentImpl ? (FileContentImpl)fileContent : null;
        if (fileContentImpl == null || (fileContentImpl = fileContentImpl.getPsiFile()) == null) {
            return MapsKt.emptyMap();
        }
        FileContentImpl psiFile = fileContentImpl;
        Map results = new LinkedHashMap();
        FileContentImpl fileContentImpl2 = psiFile;
        if (fileContentImpl2 instanceof PsiJavaFile) {
            this$0.processJavaFile((PsiJavaFile)psiFile, results);
        } else if (fileContentImpl2 instanceof KtFile) {
            this$0.processKotlinFile(fileContent, (KtFile)psiFile, results);
        }
        Project project = ((FileContentImpl)fileContent).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JniMethodResolver.Companion.getInstance(project).invalidate(results.keySet());
        return results;
    }

    public static final /* synthetic */ String access$getDumbJvmName(GlobalNativeMethodIndex $this, KtAnnotated element) {
        return $this.getDumbJvmName(element);
    }

    public static final /* synthetic */ String access$getDumbFileJvmName(GlobalNativeMethodIndex $this, KtFile file) {
        return $this.getDumbFileJvmName(file);
    }

    public static final /* synthetic */ boolean access$hasDumbJvmStatic(GlobalNativeMethodIndex $this, KtAnnotated element) {
        return $this.hasDumbJvmStatic(element);
    }
}

