/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.model;

import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JvmType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/ndk/jni/model/JvmObjectType;", "Lcom/android/tools/ndk/jni/model/JvmType;", "name", "Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "<init>", "(Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;)V", "isThrowable", "", "isDerivedFromGenericType", "(Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;ZZ)V", "getName", "()Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "()Z", "setDerivedFromGenericType", "(Z)V", "toJniType", "", "toShortJavaType", "toJvmType", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "android-ndk"})
public final class JvmObjectType
extends JvmType {
    @NotNull
    private final FullyQualifiedClassName name;
    private boolean isThrowable;
    private boolean isDerivedFromGenericType;

    public JvmObjectType(@NotNull FullyQualifiedClassName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(null);
        this.name = name;
    }

    @NotNull
    public final FullyQualifiedClassName getName() {
        return this.name;
    }

    @Override
    public boolean isDerivedFromGenericType() {
        return this.isDerivedFromGenericType;
    }

    public void setDerivedFromGenericType(boolean bl) {
        this.isDerivedFromGenericType = bl;
    }

    public JvmObjectType(@NotNull FullyQualifiedClassName name, boolean isThrowable, boolean isDerivedFromGenericType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name);
        this.isThrowable = isThrowable;
        this.setDerivedFromGenericType(isDerivedFromGenericType);
    }

    @Override
    @NotNull
    public String toJniType() {
        return switch (this.name.getJava()) {
            case "java.lang.Class" -> "jclass";
            case "java.lang.String" -> "jstring";
            case "java.lang.Throwable" -> "jthrowable";
            default -> this.isThrowable ? "jthrowable" : "jobject";
        };
    }

    @Override
    @NotNull
    public String toShortJavaType() {
        return this.name.getShortName();
    }

    @Override
    @NotNull
    public String toJvmType() {
        return "L" + this.name.getJvm() + ";";
    }

    @NotNull
    public final FullyQualifiedClassName component1() {
        return this.name;
    }

    @NotNull
    public final JvmObjectType copy(@NotNull FullyQualifiedClassName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JvmObjectType(name);
    }

    public static /* synthetic */ JvmObjectType copy$default(JvmObjectType jvmObjectType, FullyQualifiedClassName fullyQualifiedClassName, int n, Object object) {
        if ((n & 1) != 0) {
            fullyQualifiedClassName = jvmObjectType.name;
        }
        return jvmObjectType.copy(fullyQualifiedClassName);
    }

    @NotNull
    public String toString() {
        return "JvmObjectType(name=" + this.name + ")";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmObjectType)) {
            return false;
        }
        JvmObjectType jvmObjectType = (JvmObjectType)other;
        return Intrinsics.areEqual((Object)this.name, (Object)jvmObjectType.name);
    }
}

