/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniFunctionExternInspection;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniFunctionExternInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "prevNonWhitespaceSibling", "Lcom/intellij/psi/PsiElement;", "getPrevNonWhitespaceSibling", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "android-ndk"})
public final class JniFunctionExternInspection
extends JniInspectionTool {
    public JniFunctionExternInspection() {
        super(JniInspectionEvent.JniInspectionType.EXTERN_C_INSPECTION_EVENT);
    }

    private final PsiElement getPrevNonWhitespaceSibling(PsiElement $this$prevNonWhitespaceSibling) {
        PsiElement current = $this$prevNonWhitespaceSibling.getPrevSibling();
        while (current != null) {
            if (!(current instanceof PsiWhiteSpace)) {
                return current;
            }
            current = ((PsiWhiteSpace)current).getPrevSibling();
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiElementVisitor(){};
        }
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ JniFunctionExternInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                void psiElement$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                MethodInfo methodInfo = MethodInfo.Companion.fromPsiElement(element, false);
                NativeMethodInfo nativeMethodInfo = methodInfo instanceof NativeMethodInfo ? (NativeMethodInfo)methodInfo : null;
                if (nativeMethodInfo == null) {
                    return;
                }
                NativeMethodInfo nativeMethodInfo2 = nativeMethodInfo;
                if (!(nativeMethodInfo2.getNativeMethodId() instanceof JniNativeMethodId)) {
                    return;
                }
                if (!nativeMethodInfo2.isCpp()) {
                    return;
                }
                if (Intrinsics.areEqual((Object)nativeMethodInfo2.getPsiElement().getNode().getTreeParent().getElementType(), (Object)OCElementTypes.CPP_LINKAGE_SPECIFICATION)) {
                    return;
                }
                PsiElement psiElement = JniFunctionExternInspection.access$getPrevNonWhitespaceSibling(this.this$0, (PsiElement)nativeMethodInfo2.getPsiElement());
                if (Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)OCElementTypes.CPP_LINKAGE_SPECIFICATION)) {
                    return;
                }
                JniInspectionTool jniInspectionTool = this.this$0;
                methodInfo = element;
                ProblemsHolder problemsHolder = this.$holder;
                JniFunctionExternInspection jniFunctionExternInspection = this.this$0;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = psiElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement psiElement2 = nativeMethodInfo2.getPsiElement().getNameIdentifier();
                    if (psiElement2 == null) {
                        psiElement2 = (PsiElement)nativeMethodInfo2.getPsiElement();
                    }
                    JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{JniInspectionTool.quickFix$default(jniFunctionExternInspection, "Add extern \"C\"", null, buildVisitor.2::visitElement$lambda$0$0, 2, null)};
                    InspectionUtilsKt.registerOcProblem(problemsHolder, psiElement2, "This JNI function call may be using an incorrect linkage.", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, jniLocalQuickFixArray);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }

            private static final boolean visitElement$lambda$0$0(Project project, ProblemDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                ActionsKt.runWriteAction(() -> buildVisitor.2.visitElement$lambda$0$0$0(descriptor, project));
                return true;
            }

            private static final boolean visitElement$lambda$0$0$0(ProblemDescriptor $descriptor, Project $project) {
                OCFunctionDeclaration oCFunctionDeclaration = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$descriptor.getPsiElement(), OCFunctionDeclaration.class);
                if (oCFunctionDeclaration == null) {
                    return false;
                }
                PsiElement elementToFix = (PsiElement)oCFunctionDeclaration;
                if (elementToFix.getPrevSibling() instanceof OCMacroCall) {
                    PsiElement psiElement = elementToFix.getPrevSibling();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPrevSibling(...)");
                    elementToFix = psiElement;
                }
                return OCChangeUtil.changeText((Project)$project, (PsiFile)elementToFix.getContainingFile(), (int)elementToFix.getTextRange().getStartOffset(), (int)0, (String)" extern \"C\" ", (boolean)true);
            }
        };
    }

    public static final /* synthetic */ PsiElement access$getPrevNonWhitespaceSibling(JniFunctionExternInspection $this, PsiElement $receiver) {
        return $this.getPrevNonWhitespaceSibling($receiver);
    }
}

