/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.CallNonvirtualMethodCall;
import com.android.tools.ndk.jni.model.ClassTypeInfo;
import com.android.tools.ndk.jni.model.ConcreteTypeInfo;
import com.android.tools.ndk.jni.model.IllegalTypeInfo;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodCall;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeInfo;
import com.android.tools.ndk.jni.model.SimpleTypeInfo;
import com.android.tools.ndk.jni.model.WildcardTypeInfo;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.service.JvmTypeChecker;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u0010\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniCallNonvirtualMethodInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectReceiver", "", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "call", "Lcom/android/tools/ndk/jni/model/CallNonvirtualMethodCall;", "inspectClass", "inspectTypeVariation", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniCallNonvirtualMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniCallNonvirtualMethodInspection.kt\ncom/android/tools/ndk/jni/inspections/JniCallNonvirtualMethodInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n*L\n1#1,109:1\n51#2,9:110\n*S KotlinDebug\n*F\n+ 1 JniCallNonvirtualMethodInspection.kt\ncom/android/tools/ndk/jni/inspections/JniCallNonvirtualMethodInspection\n*L\n48#1:110,9\n*E\n"})
public final class JniCallNonvirtualMethodInspection
extends JniInspectionTool {
    public JniCallNonvirtualMethodInspection() {
        super(JniInspectionEvent.JniInspectionType.CALL_METHOD_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiElementVisitor(){};
        }
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return (PsiElementVisitor)new OCVisitor(this_$iv, this, holder){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ JniCallNonvirtualMethodInspection this$0;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.this$0 = jniCallNonvirtualMethodInspection;
                this.$holder$inlined = problemsHolder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof CallNonvirtualMethodCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (CallNonvirtualMethodCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call = jniCall2;
                JniInspectionTool jniInspectionTool = this.this$0$inline_fun;
                PsiElement psiElement$iv = (PsiElement)expression;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = psiElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call2;
                    JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project project3 = expression.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    JniInfoInferencer inferencer = JniInfoInferencer.Companion.getInstance(project3);
                    CallNonvirtualMethodCall callNonvirtualMethodCall = (CallNonvirtualMethodCall)call;
                    JniInfoInferencer $this$buildVisitor_u24lambda_u240 = inferencer;
                    boolean bl3 = false;
                    JniCallNonvirtualMethodInspection.access$inspectReceiver(this.this$0, $this$buildVisitor_u24lambda_u240, (CallNonvirtualMethodCall)call2, this.$holder$inlined);
                    JniCallNonvirtualMethodInspection.access$inspectClass(this.this$0, $this$buildVisitor_u24lambda_u240, (CallNonvirtualMethodCall)call2, this.$holder$inlined);
                    InspectionUtilsKt.inspectMethodIdBelongsToClass($this$buildVisitor_u24lambda_u240, call2.getClassExpression(), this.$holder$inlined, call2.getMethodIdExpression());
                    InspectionUtilsKt.inspectCallArgs($this$buildVisitor_u24lambda_u240, (JvmMethodCall)call2, this.$holder$inlined);
                    JniCallNonvirtualMethodInspection.access$inspectTypeVariation(this.this$0, $this$buildVisitor_u24lambda_u240, (CallNonvirtualMethodCall)call2, this.$holder$inlined);
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspectReceiver(JniInfoInferencer $this$inspectReceiver, CallNonvirtualMethodCall call, ProblemsHolder holder) {
        JvmType jvmType;
        JvmTypeInfo jvmTypeInfo = $this$inspectReceiver.inferTypeInfo(call.getObjectExpression());
        if (jvmTypeInfo == null) {
            return;
        }
        JvmTypeInfo receiverType = jvmTypeInfo;
        if (receiverType instanceof WildcardTypeInfo) {
            jvmType = ((WildcardTypeInfo)receiverType).getBound();
        } else if (receiverType instanceof ConcreteTypeInfo) {
            jvmType = ((ConcreteTypeInfo)receiverType).getType();
        } else {
            if (Intrinsics.areEqual((Object)receiverType, (Object)IllegalTypeInfo.INSTANCE)) {
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call.getObjectExpression(), "Not a valid JVM object.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        JvmType receiverType2 = jvmType;
        if (receiverType2 instanceof JvmPrimitiveType) {
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call.getObjectExpression(), "Expected a JVM object but got a primitive value of type '" + ((JvmPrimitiveType)receiverType2).toShortJavaType() + "'.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
        }
    }

    private final void inspectClass(JniInfoInferencer $this$inspectClass, CallNonvirtualMethodCall call, ProblemsHolder holder) {
        JvmTypeInfo jvmTypeInfo = $this$inspectClass.inferTypeInfo(call.getObjectExpression());
        Object object = jvmTypeInfo instanceof SimpleTypeInfo ? (SimpleTypeInfo)jvmTypeInfo : null;
        if (object == null || (object = ((SimpleTypeInfo)object).getType()) == null) {
            return;
        }
        Object receiverType = object;
        if (receiverType instanceof JvmPrimitiveType) {
            return;
        }
        JvmTypeInfo jvmTypeInfo2 = $this$inspectClass.inferTypeInfo(call.getClassExpression());
        Object object2 = jvmTypeInfo2 instanceof ClassTypeInfo ? (ClassTypeInfo)jvmTypeInfo2 : null;
        if (object2 == null || (object2 = ((ClassTypeInfo)object2).getClassType()) == null) {
            return;
        }
        Object classType = object2;
        Project project = call.getCallExpression().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JvmTypeChecker $this$inspectClass_u24lambda_u240 = JvmTypeChecker.Companion.getInstance(project);
        boolean bl = false;
        if (!JvmTypeChecker.isAssignableFrom$default($this$inspectClass_u24lambda_u240, (JvmType)classType, (JvmType)receiverType, false, 4, null)) {
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call.getClassExpression(), "'" + ((JvmType)classType).toShortJavaType() + "' is not a super class of '" + ((JvmType)receiverType).toShortJavaType() + "'.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
        }
    }

    private final void inspectTypeVariation(JniInfoInferencer $this$inspectTypeVariation, CallNonvirtualMethodCall call, ProblemsHolder holder) {
        JvmPrimitiveType expectedType;
        JvmMethodInfo jvmMethodInfo = $this$inspectTypeVariation.inferMethodInfo(call.getMethodIdExpression());
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo methodInfo = jvmMethodInfo;
        JvmType jvmType = methodInfo.getReturnType();
        JvmPrimitiveType jvmPrimitiveType = expectedType = jvmType instanceof JvmPrimitiveType ? (JvmPrimitiveType)jvmType : null;
        if (!Intrinsics.areEqual((Object)expectedType, (Object)call.getType())) {
            CallNonvirtualMethodCall fixedCall = call.alterType(expectedType);
            JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{this.quickFix("Fix Non-virtual method call.", "Replace with '" + fixedCall.getFunctionName() + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniCallNonvirtualMethodInspection.inspectTypeVariation$lambda$0(fixedCall, arg_0, arg_1)))};
            InspectionUtilsKt.registerOcProblem(holder, call.getFunctionIdentifier(), "Expected to be " + fixedCall.getFunctionName() + " for " + methodInfo.getDescription() + ".", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
        }
    }

    private static final boolean inspectTypeVariation$lambda$0(CallNonvirtualMethodCall $fixedCall, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniCallNonvirtualMethodInspection.inspectTypeVariation$lambda$0$0(descriptor, $fixedCall));
    }

    private static final boolean inspectTypeVariation$lambda$0$0(ProblemDescriptor $descriptor, CallNonvirtualMethodCall $fixedCall) {
        String[] stringArray = new String[]{$fixedCall.getFunctionName()};
        return InspectionUtilsKt.replaceAtHighlighted($descriptor, stringArray);
    }

    public static final /* synthetic */ void access$inspectReceiver(JniCallNonvirtualMethodInspection $this, JniInfoInferencer $receiver, CallNonvirtualMethodCall call, ProblemsHolder holder) {
        $this.inspectReceiver($receiver, call, holder);
    }

    public static final /* synthetic */ void access$inspectClass(JniCallNonvirtualMethodInspection $this, JniInfoInferencer $receiver, CallNonvirtualMethodCall call, ProblemsHolder holder) {
        $this.inspectClass($receiver, call, holder);
    }

    public static final /* synthetic */ void access$inspectTypeVariation(JniCallNonvirtualMethodInspection $this, JniInfoInferencer $receiver, CallNonvirtualMethodCall call, ProblemsHolder holder) {
        $this.inspectTypeVariation($receiver, call, holder);
    }
}

