/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.project;

import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ProjectSdkSetup {
    private final Disposable myParentDisposable;

    public ProjectSdkSetup() {
        this.myParentDisposable = null;
    }

    @TestOnly
    public ProjectSdkSetup(@NotNull Disposable parentDisposable) {
        this.myParentDisposable = parentDisposable;
    }

    public void setUpProject(@NotNull Project project) {
        ApkDebugging.markAsApkDebuggingProject((Project)project);
        this.tryToSetProjectJdk(project, LanguageLevel.JDK_1_8, LanguageLevel.JDK_1_7, LanguageLevel.JDK_1_6);
    }

    private void tryToSetProjectJdk(@NotNull Project project, LanguageLevel ... languageLevels) {
        for (LanguageLevel languageLevel : languageLevels) {
            Sdk jdk = ProjectSdkSetup.tryToSetProjectJdk(project, languageLevel);
            if (jdk == null) continue;
            this.registerJdkForDisposalIfNeeded(jdk);
            return;
        }
    }

    @Nullable
    private static Sdk tryToSetProjectJdk(@NotNull Project project, @NotNull LanguageLevel languageLevel) {
        Sdk jdk = IdeSdks.getInstance().getJdk();
        if (jdk != null) {
            return (Sdk)ApplicationManager.getApplication().runWriteAction(() -> {
                ProjectRootManager.getInstance((Project)project).setProjectSdk(jdk);
                LanguageLevelProjectExtension.getInstance((Project)project).setLanguageLevel(languageLevel);
                return jdk;
            });
        }
        return null;
    }

    private void registerJdkForDisposalIfNeeded(@NotNull Sdk jdk) {
        if (this.myParentDisposable != null) {
            Disposer.register((Disposable)this.myParentDisposable, () -> ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(jdk)));
        }
    }
}

