/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.issues;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReportStrategy;
import com.android.tools.idea.apk.sdk.AndroidSdkSetup;
import com.android.tools.idea.apk.sdk.InstallPlatformQuickFix;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class SdkNotFoundReporter
extends SetupIssueReportStrategy {
    @NotNull
    private final IdeSdks myIdeSdks;

    SdkNotFoundReporter(@NotNull IdeSdks ideSdks) {
        this.myIdeSdks = ideSdks;
    }

    @Override
    @NotNull
    IssueCategory getSupportedCategory() {
        return IssueCategory.SDK_NOT_FOUND;
    }

    @Override
    protected void report(@NotNull Project project, @NotNull SetupIssue issue, @NotNull ApkFacet facet) {
        String sdkVersion = issue.extraInfo;
        String text = "Failed to find Android target '" + sdkVersion + "'";
        AndroidNotification.getInstance((Project)project).showBalloon("SDK not found", text, this.getSeverity(issue.severity), this.getNotificationGroup(issue.severity), new NotificationHyperlink[]{new InstallPlatformQuickFix(new AndroidSdkSetup(), facet, this.getSdkPath(), sdkVersion)});
    }

    @NotNull
    private File getSdkPath() {
        File sdkPath = this.myIdeSdks.getAndroidSdkPath();
        assert (sdkPath != null);
        return sdkPath;
    }
}

