/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor.notification;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.OpenLibraryInEditorAction;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.notification.AddSymbolsForAllLibrariesAction;
import com.android.tools.idea.apk.editor.notification.DropDownAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingDebugSymbolsNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (!"apk".equals(file.getExtension())) {
            return null;
        }
        ApkFacet facet = this.findLibrariesWithoutSymbols(project);
        if (facet == null) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        List libraries = ((ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols();
        return editor -> {
            MyEditorNotificationPanel panel = new MyEditorNotificationPanel();
            if (libraries.size() == 1) {
                NativeLibrary library = (NativeLibrary)libraries.get(0);
                panel.setText(library.name + " is missing debug symbols");
                OpenLibraryInEditorAction action = new OpenLibraryInEditorAction(library, fileEditorManager);
                panel.addToLinksPanel((Component)((Object)new OpenLibraryInEditorHyperlinkLabel(action, panel.getBackground())));
            } else {
                panel.setText("Libraries (*.so) in the APK are missing debug symbols");
                DropDownAction dropDown = new DropDownAction("Select library to add debug symbols ");
                dropDown.addAction(new AddSymbolsForAllLibrariesAction(facet, file, libraries));
                for (NativeLibrary library : libraries) {
                    dropDown.addAction(new OpenLibraryInEditorAction(library.name, library, fileEditorManager));
                }
                panel.addToLinksPanel((Component)((Object)dropDown));
            }
            return panel;
        };
    }

    @Nullable
    private ApkFacet findLibrariesWithoutSymbols(Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ApkFacetConfiguration configuration;
            List libraries;
            ApkFacet facet = ApkFacet.getInstance((Module)module);
            if (facet == null || (libraries = (configuration = (ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols()).isEmpty()) continue;
            return facet;
        }
        return null;
    }

    @VisibleForTesting
    static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final List<Component> myLinkComponents = new ArrayList<Component>();

        MyEditorNotificationPanel() {
        }

        void addToLinksPanel(@NotNull Component component) {
            this.myLinksPanel.add(component);
            this.myLinkComponents.add(component);
        }

        @VisibleForTesting
        @NotNull
        List<Component> getLinkComponents() {
            return this.myLinkComponents;
        }
    }

    @VisibleForTesting
    static class OpenLibraryInEditorHyperlinkLabel
    extends HyperlinkLabel {
        @NotNull
        private final NativeLibrary myLibrary;

        OpenLibraryInEditorHyperlinkLabel(@NotNull OpenLibraryInEditorAction action, @NotNull Color background) {
            super("Add debug symbols", background);
            this.addHyperlinkListener(action);
            this.myLibrary = action.getLibrary();
        }

        @VisibleForTesting
        protected void fireHyperlinkEvent(@Nullable InputEvent inputEvent) {
            super.fireHyperlinkEvent(inputEvent);
        }

        @NotNull
        NativeLibrary getLibrary() {
            return this.myLibrary;
        }
    }
}

