/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.LibraryEditor;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        AndroidProjectInfo projectInfo = AndroidProjectInfo.getInstance((Project)project);
        if (projectInfo.isApkProject() && "so".equals(file.getExtension())) {
            VirtualFile libFolder = LibraryEditorProvider.findParentWithName(file, LibraryFolder.getName());
            return libFolder != null && VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)libFolder, (boolean)true);
        }
        return false;
    }

    @Nullable
    private static VirtualFile findParentWithName(@NotNull VirtualFile file, @NotNull String name) {
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!name.equals(current.getName())) continue;
            return current;
        }
        return null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Pair<ApkFacet, NativeLibrary> facetAndLibrary = LibraryEditorProvider.findFacetAndLibraryContainingFile(file, project);
        assert (facetAndLibrary != null);
        return new LibraryEditor(file, (ApkFacet)facetAndLibrary.getFirst(), (NativeLibrary)facetAndLibrary.getSecond());
    }

    @Nullable
    private static Pair<ApkFacet, NativeLibrary> findFacetAndLibraryContainingFile(@NotNull VirtualFile file, @NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ApkFacet facet = ApkFacet.getInstance((Module)module);
            if (facet == null) continue;
            for (NativeLibrary library : ((ApkFacetConfiguration)facet.getConfiguration()).NATIVE_LIBRARIES) {
                if (!library.sharedObjectFilesByAbi.containsValue(file)) continue;
                return Pair.create((Object)facet, (Object)library);
            }
        }
        return null;
    }

    @NotNull
    public String getEditorTypeId() {
        return "apk-native-library";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }
}

