/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.editor.SharedObjectFileChooserDescriptor;
import com.android.tools.idea.util.FileOrFolderChooser;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FolderOrSharedObjectFileChooserFactory {
    static final String LAST_APK_SYMBOLS_LOCATION = "last.apk.symbols.location";
    PropertiesComponent myPropertiesComponent;
    VirtualFileSystem myVirtualFileSystem;

    @VisibleForTesting
    FolderOrSharedObjectFileChooserFactory(PropertiesComponent propertiesComponent, VirtualFileSystem virtualFileSystem) {
        this.myPropertiesComponent = propertiesComponent;
        this.myVirtualFileSystem = virtualFileSystem;
    }

    public FolderOrSharedObjectFileChooserFactory() {
        this(PropertiesComponent.getInstance(), (VirtualFileSystem)LocalFileSystem.getInstance());
    }

    @NotNull
    public FileOrFolderChooser create(@NotNull ApkFacet facet) {
        return project -> {
            SharedObjectFileChooserDescriptor descriptor = new SharedObjectFileChooserDescriptor(facet);
            FileChooserDialogImpl chooser = new FileChooserDialogImpl((FileChooserDescriptor)descriptor, project);
            VirtualFile lastSelectedFile = this.getLastApkSymbolsLocation();
            VirtualFile[] selectedFiles = chooser.choose(project, new VirtualFile[]{lastSelectedFile});
            this.setLastApkSymbolsLocation(selectedFiles);
            return selectedFiles;
        };
    }

    @VisibleForTesting
    @Nullable
    VirtualFile getLastApkSymbolsLocation() {
        String path = this.myPropertiesComponent.getValue(LAST_APK_SYMBOLS_LOCATION);
        if (path == null) {
            return null;
        }
        return this.myVirtualFileSystem.findFileByPath(path);
    }

    @VisibleForTesting
    void setLastApkSymbolsLocation(VirtualFile[] selectedFiles) {
        if (selectedFiles.length == 0) {
            return;
        }
        this.myPropertiesComponent.setValue(LAST_APK_SYMBOLS_LOCATION, selectedFiles[0].getPath());
    }
}

