/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.TextFileSelection;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0000\"\u0016\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000e"}, d2={"EMPTY_CARET_STATE", "Lcom/intellij/openapi/editor/CaretState;", "getEMPTY_CARET_STATE", "()Lcom/intellij/openapi/editor/CaretState;", "openEditor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "setSelection", "", "reference", "Lcom/google/urlassistant/util/TextFileSelection;", "url-assistant"})
public final class CaretUtilsKt {
    @VisibleForTesting
    @NotNull
    private static final CaretState EMPTY_CARET_STATE = new CaretState(new LogicalPosition(0, 0), new LogicalPosition(0, 0), new LogicalPosition(0, 0));

    @NotNull
    public static final CaretState getEMPTY_CARET_STATE() {
        return EMPTY_CARET_STATE;
    }

    private static final Editor openEditor(Project project, String filePath) {
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(filePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        fileEditorManager.openFile(file, true);
        return fileEditorManager.getSelectedTextEditor();
    }

    public static final void setSelection(@NotNull Project project, @NotNull TextFileSelection reference) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Editor editor = CaretUtilsKt.openEditor(project, reference.getFilePath());
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        editor2.getCaretModel().setCaretsAndSelections(CollectionsKt.listOf((Object)EMPTY_CARET_STATE));
        editor2.getCaretModel().getPrimaryCaret().moveToOffset(reference.getStartOffset());
        editor2.getCaretModel().getPrimaryCaret().setSelection(reference.getStartOffset(), reference.getEndOffset());
        editor2.getScrollingModel().runActionOnScrollingFinished(() -> CaretUtilsKt.setSelection$lambda$0(editor2, reference));
    }

    private static final void setSelection$lambda$0(Editor $editor, TextFileSelection $reference) {
        $editor.getScrollingModel().scrollTo($editor.offsetToLogicalPosition($reference.getStartOffset()), ScrollType.CENTER_UP);
    }
}

