/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.google.urlassistant.datalayer.CallSiteId;
import com.google.urlassistant.datalayer.DataLayerAccessor;
import com.google.urlassistant.datalayer.db.DalApisConsentStore;
import com.google.urlassistant.datalayer.feature.LinkInfoUtilsKt;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.DataTagCheckName;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.DataTagCheckResult;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.DataTagCheckSummary;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.IntentFilterCheckName;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.IntentFilterCheckResult;
import com.google.urlassistant.datalayer.model.validation.singlelinkdatatagconfig.PathType;
import com.google.urlassistant.datalayer.model.validation.webchecksummary.webassociationcheck.WebAssociationCheckResult;
import com.google.urlassistant.datalayer.model.validation.webchecksummary.webassociationcheck.WebCheckSummary;
import com.google.urlassistant.proto.AssetLinksCheckName;
import com.google.urlassistant.ui.UiUtils;
import com.google.urlassistant.ui.models.AppLinkDetailModel;
import com.google.urlassistant.ui.models.digitalassetlink.FixAllWebIssuesModel;
import com.google.urlassistant.util.IntentFilterFixOutcome;
import com.google.urlassistant.util.IntentFilterUtils;
import com.google.urlassistant.util.TimeUtilsKt;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import icons.StudioIcons;
import java.awt.Color;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmDebuggerBasePsiUtils;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 B2\u00020\u0001:\u0001BB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010=\u001a\u00020>H\u0086@\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020AH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0014\u0010$\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0014\u0010&\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001dR\u0014\u0010(\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u0014\u0010*\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001dR\u0014\u0010,\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001dR\u0014\u0010.\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001dR\u0011\u00100\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001dR\u0011\u00102\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001dR\u0011\u00104\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u001dR\u0011\u00106\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u000eR\u0011\u00108\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001dR\u0016\u0010:\u001a\n <*\u0004\u0018\u00010;0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkDetailModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "link", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;)V", "getLink", "()Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "canGetDalResults", "", "getCanGetDalResults", "()Z", "numFailedChecks", "", "getNumFailedChecks", "()I", "webChecksMissing", "getWebChecksMissing", "isPassing", "checksIcon", "Ljavax/swing/Icon;", "getChecksIcon", "()Ljavax/swing/Icon;", "checksMessage", "", "getChecksMessage", "()Ljava/lang/String;", "checksColor", "Ljava/awt/Color;", "getChecksColor", "()Ljava/awt/Color;", "displayedPort", "getDisplayedPort", "displayedHost", "getDisplayedHost", "displayedPath", "getDisplayedPath", "displayedPathType", "getDisplayedPathType", "displayedActivity", "getDisplayedActivity", "displayedOrder", "getDisplayedOrder", "displayedPriority", "getDisplayedPriority", "basicInformation", "getBasicInformation", "extraInformation", "getExtraInformation", "lastLinkCheckRuntime", "getLastLinkCheckRuntime", "showFixWebChecksButton", "getShowFixWebChecksButton", "fixWebChecksTooltip", "getFixWebChecksTooltip", "dataAccessor", "Lcom/google/urlassistant/datalayer/DataLayerAccessor;", "kotlin.jvm.PlatformType", "autoFix", "Lcom/google/urlassistant/util/IntentFilterFixOutcome;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "", "Companion", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkDetailModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkDetailModel.kt\ncom/google/urlassistant/ui/models/AppLinkDetailModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n1#2:343\n*E\n"})
public final class AppLinkDetailModel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LinkInfo link;
    private final boolean showFixWebChecksButton;
    private final DataLayerAccessor dataAccessor;
    @VisibleForTesting
    @NotNull
    public static final String DEEPLINKING_REFERENCE = "https://developer.android.com/training/app-links/deep-linking";
    @VisibleForTesting
    @NotNull
    public static final String INTENT_FILTER_REFERENCE = "https://developer.android.com/guide/topics/manifest/intent-filter-element";
    @VisibleForTesting
    @NotNull
    public static final String VERIFY_REFERENCE = "https://developer.android.com/training/app-links/verify-android-applinks";
    @VisibleForTesting
    @NotNull
    public static final String REDIRECT_REFERENCE = "https://support.google.com/google-ads/answer/10023042?hl=en#:~:text=Note%3A%20Google%20Ads%20doesn't,users%20directly%20to%20the%20app.";
    @VisibleForTesting
    @NotNull
    public static final String DAL_FILE_CONTENT_REFERENCE = "https://developer.android.com/training/app-links/verify-android-applinks#web-assoc";
    @VisibleForTesting
    @NotNull
    public static final String DAL_HOSTING_REFERENCE = "https://developer.android.com/training/app-links/verify-android-applinks#publish-json";

    public AppLinkDetailModel(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull LinkInfo link) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.project = project;
        this.link = link;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.showFixWebChecksButton = this.getCanGetDalResults() && LinkInfoUtilsKt.isWebScheme(this.link.getSingleLinkDataTagConfig().getScheme());
        this.dataAccessor = (DataLayerAccessor)this.project.getService(DataLayerAccessor.class);
    }

    @NotNull
    public final LinkInfo getLink() {
        return this.link;
    }

    private final boolean getCanGetDalResults() {
        return DalApisConsentStore.Companion.getInstance(this.project).getCanGetResults();
    }

    private final int getNumFailedChecks() {
        Object object;
        return this.link.getAppCheckSummary().getTotalFailedIntentFilterChecks() + ((object = this.link.getWebCheckSummary()) != null && (object = ((WebCheckSummary)object).getTotalFailedWebAssociationChecks()) != null ? (Integer)object : 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getWebChecksMissing() {
        if (!this.getCanGetDalResults()) return false;
        if (!LinkInfoUtilsKt.isWebScheme(this.link.getSingleLinkDataTagConfig().getScheme())) return false;
        WebCheckSummary webCheckSummary = this.link.getWebCheckSummary();
        Object object = webCheckSummary;
        if (webCheckSummary == null) return true;
        List<WebAssociationCheckResult> list = ((WebCheckSummary)object).getWebAssociationCheckResults();
        object = list;
        if (list == null) return true;
        if (((Collection)object).isEmpty()) return true;
        return false;
    }

    private final boolean isPassing() {
        return this.getNumFailedChecks() == 0 && !this.getWebChecksMissing();
    }

    @NotNull
    public final Icon getChecksIcon() {
        Icon icon;
        if (this.isPassing()) {
            Icon icon2 = AllIcons.RunConfigurations.TestPassed;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"TestPassed");
        } else {
            Icon icon3 = StudioIcons.Common.ERROR;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ERROR");
        }
        return icon;
    }

    @NotNull
    public final String getChecksMessage() {
        String string;
        switch (this.getNumFailedChecks()) {
            case 0: {
                String string2 = UrlAssistantBundle.message(this.getWebChecksMissing() ? "web.check.results.not.run" : "link.passed.all.checks", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                break;
            }
            case 1: {
                String string3 = UrlAssistantBundle.message("link.failed.one.check", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break;
            }
            default: {
                Object[] objectArray = new Object[]{this.getNumFailedChecks()};
                String string4 = UrlAssistantBundle.message("link.failed.number.checks", objectArray);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            }
        }
        return string;
    }

    @NotNull
    public final Color getChecksColor() {
        Color color;
        if (this.isPassing()) {
            Color color2 = UIManager.getColor("Label.foreground");
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getColor(...)");
        } else {
            color = (Color)UiUtils.INSTANCE.getRED_TEXT_COLOR();
        }
        return color;
    }

    private final String getDisplayedPort() {
        Object object;
        block3: {
            block2: {
                object = this.link.getSingleLinkDataTagConfig().getPort();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = ":" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String getDisplayedHost() {
        String string;
        String string2 = this.link.getSingleLinkDataTagConfig().getScheme();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.link.getSingleLinkDataTagConfig().getRawHost()) == null) {
            string = "";
        }
        return string2 + "://" + string + this.getDisplayedPort();
    }

    private final String getDisplayedPath() {
        String string = this.link.getSingleLinkDataTagConfig().getRawPath();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getDisplayedPathType() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.link.getSingleLinkDataTagConfig().getPathType().ordinal()]) {
            case 1 -> "android:path";
            case 2 -> "android:pathPrefix";
            case 3 -> "android:pathPattern";
            case 4 -> "android:pathAdvancedPattern";
            case 5 -> "android:pathSuffix";
            default -> "android:path";
        };
    }

    private final String getDisplayedActivity() {
        return this.link.getActivityConfig().getActivityName();
    }

    private final String getDisplayedOrder() {
        String string = this.link.getIntentFilterConfig().getOrder();
        if (string == null) {
            string = "0";
        }
        return string;
    }

    private final String getDisplayedPriority() {
        String string = this.link.getIntentFilterConfig().getPriority();
        if (string == null) {
            string = "0";
        }
        return string;
    }

    @NotNull
    public final String getBasicInformation() {
        Object[] objectArray = new Object[]{this.getDisplayedHost(), this.getDisplayedPath()};
        String string = UrlAssistantBundle.message("app.link.details.always.visible", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public final String getExtraInformation() {
        Object[] objectArray = new Object[]{this.getDisplayedPathType(), this.getDisplayedActivity(), this.getDisplayedOrder(), this.getDisplayedPriority()};
        String string = UrlAssistantBundle.message("app.link.extra.details", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public final String getLastLinkCheckRuntime() {
        Object[] objectArray = new Object[]{TimeUtilsKt.toLocalDateTimeString$default(this.link.getAppCheckSummary().getCheckExecutionEpochTimeMillis(), null, null, 6, null)};
        String string = UrlAssistantBundle.message("this.link.last.checked.time", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public final boolean getShowFixWebChecksButton() {
        return this.showFixWebChecksButton;
    }

    @NotNull
    public final String getFixWebChecksTooltip() {
        String string;
        WebCheckSummary webCheckSummary = this.link.getWebCheckSummary();
        if (webCheckSummary == null) {
            return "";
        }
        WebCheckSummary webCheckSummary2 = webCheckSummary;
        if (FixAllWebIssuesModel.Companion.needsJsonGeneration(webCheckSummary2)) {
            string = "";
        } else {
            String string2 = UrlAssistantBundle.message("tooltip.json.generation.not.helpful", new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object autoFix(@NotNull Continuation<? super IntentFilterFixOutcome> $completion) {
        if (!($completion instanceof autoFix.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AppLinkDetailModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.autoFix((Continuation<? super IntentFilterFixOutcome>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                intentFilterFixOutcome = new Ref.ObjectRef();
                intentFilterFixOutcome.element = IntentFilterFixOutcome.NOT_A_DEEPLINK;
                v0 = UrlAssistantBundle.message("overview.autofix.links", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message(...)");
                job = this.dataAccessor.scheduleJob(CallSiteId.APP_LINK_DETAIL_FIX, v0, CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null), (Function3<? super CoroutineScope, ? super ProgressIndicator, ? super Continuation<? super Unit>, ? extends Object>)((Function3)new Function3<CoroutineScope, ProgressIndicator, Continuation<? super Unit>, Object>(this, (Ref.ObjectRef<IntentFilterFixOutcome>)intentFilterFixOutcome, null){
                    int label;
                    final /* synthetic */ AppLinkDetailModel this$0;
                    final /* synthetic */ Ref.ObjectRef<IntentFilterFixOutcome> $intentFilterFixOutcome;
                    {
                        this.this$0 = $receiver;
                        this.$intentFilterFixOutcome = $intentFilterFixOutcome;
                        super(3, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                XmlTag xmlTag = (XmlTag)ActionsKt.runReadAction(() -> autoFix.job.1.invokeSuspend$lambda$0(this.this$0));
                                if (xmlTag == null) {
                                    return Unit.INSTANCE;
                                }
                                XmlTag intentFilterPsiXmlTag = xmlTag;
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$intentFilterFixOutcome, intentFilterPsiXmlTag, null){
                                    int label;
                                    final /* synthetic */ AppLinkDetailModel this$0;
                                    final /* synthetic */ Ref.ObjectRef<IntentFilterFixOutcome> $intentFilterFixOutcome;
                                    final /* synthetic */ XmlTag $intentFilterPsiXmlTag;
                                    {
                                        this.this$0 = $receiver;
                                        this.$intentFilterFixOutcome = $intentFilterFixOutcome;
                                        this.$intentFilterPsiXmlTag = $intentFilterPsiXmlTag;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                WriteCommandAction.runWriteCommandAction((Project)AppLinkDetailModel.access$getProject$p(this.this$0), () -> autoFix.job.1.invokeSuspend$lambda$0(this.$intentFilterFixOutcome, this.$intentFilterPsiXmlTag));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }

                                    private static final void invokeSuspend$lambda$0(Ref.ObjectRef $intentFilterFixOutcome, XmlTag $intentFilterPsiXmlTag) {
                                        $intentFilterFixOutcome.element = IntentFilterUtils.INSTANCE.fixSingleDeepLinkIntentFilter($intentFilterPsiXmlTag, AppLinksAssistantEvent.EventSource.DETAILS_FIX_ONE_LINK_APP_CHECKS_BUTTON);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Object invoke(CoroutineScope p1, ProgressIndicator p2, Continuation<? super Unit> p3) {
                        return new /* invalid duplicate definition of identical inner class */.invokeSuspend(Unit.INSTANCE);
                    }

                    private static final XmlTag invokeSuspend$lambda$0(AppLinkDetailModel this$0) {
                        VirtualFile virtualFile = VfsUtil.findFile((Path)Path.of(this$0.getLink().getManifestFileLocation(), new String[0]), (boolean)true);
                        if (virtualFile != null) {
                            VirtualFile it = virtualFile;
                            boolean bl = false;
                            PsiFile psiFile = PsiManager.getInstance((Project)AppLinkDetailModel.access$getProject$p(this$0)).findFile(it);
                            if (!(psiFile instanceof XmlFile)) {
                                return null;
                            }
                            Class[] classArray = new Class[]{XmlTag.class};
                            XmlTag xmlTag = (XmlTag)CollectionsKt.firstOrNull((List)JvmDebuggerBasePsiUtils.findElementsOfTypeInRange((PsiFile)psiFile, (TextRange)new TextRange(this$0.getLink().getIntentFilterStartOffset(), this$0.getLink().getIntentFilterEndOffset()), (Class[])classArray));
                            if (xmlTag == null) {
                                return null;
                            }
                            XmlTag intentFilterElement = xmlTag;
                            if (PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)intentFilterElement)) != this$0.getLink().getIntentFilterEndOffset()) {
                                return null;
                            }
                            return intentFilterElement;
                        }
                        return null;
                    }
                }));
                $continuation.L$0 = intentFilterFixOutcome;
                $continuation.label = 1;
                v1 = job.join((Continuation)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                intentFilterFixOutcome = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                return intentFilterFixOutcome.element;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void dispose() {
    }

    public static final /* synthetic */ Project access$getProject$p(AppLinkDetailModel $this) {
        return $this.project;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkDetailModel$Companion;", "", "<init>", "()V", "DEEPLINKING_REFERENCE", "", "INTENT_FILTER_REFERENCE", "VERIFY_REFERENCE", "REDIRECT_REFERENCE", "DAL_FILE_CONTENT_REFERENCE", "DAL_HOSTING_REFERENCE", "checkResultToExplanation", "intentFilterCheckResult", "Lcom/google/urlassistant/datalayer/model/validation/appchecksummary/intentfiltercheck/IntentFilterCheckResult;", "checkNameToReferenceLink", "intentFilterCheckName", "Lcom/google/urlassistant/datalayer/model/validation/appchecksummary/intentfiltercheck/IntentFilterCheckName;", "webCheckResult", "Lcom/google/urlassistant/datalayer/model/validation/webchecksummary/webassociationcheck/WebAssociationCheckResult;", "webCheckSummary", "Lcom/google/urlassistant/datalayer/model/validation/webchecksummary/webassociationcheck/WebCheckSummary;", "assetLinksCheckName", "Lcom/google/urlassistant/proto/AssetLinksCheckName;", "url-assistant"})
    @SourceDebugExtension(value={"SMAP\nAppLinkDetailModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkDetailModel.kt\ncom/google/urlassistant/ui/models/AppLinkDetailModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,342:1\n774#2:343\n865#2,2:344\n774#2:346\n865#2,2:347\n*S KotlinDebug\n*F\n+ 1 AppLinkDetailModel.kt\ncom/google/urlassistant/ui/models/AppLinkDetailModel$Companion\n*L\n97#1:343\n97#1:344,2\n125#1:346\n125#1:347,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final String checkResultToExplanation(@NotNull IntentFilterCheckResult intentFilterCheckResult) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)intentFilterCheckResult, (String)"intentFilterCheckResult");
            if (intentFilterCheckResult.isCheckPassed()) {
                switch (WhenMappings.$EnumSwitchMapping$1[intentFilterCheckResult.getCheckName().ordinal()]) {
                    case 1: {
                        void $this$filterTo$iv$iv;
                        DataTagCheckSummary dataTagCheckSummary = intentFilterCheckResult.getSubCheckSummary();
                        object = dataTagCheckSummary;
                        if (dataTagCheckSummary == null) return "";
                        List<DataTagCheckResult> list = ((DataTagCheckSummary)object).getDataTagCheckResults();
                        object = list;
                        if (list == null) return "";
                        Iterable $this$filter$iv = (Iterable)object;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            DataTagCheckResult it = (DataTagCheckResult)element$iv$iv;
                            boolean bl = false;
                            if (!it.isCheckPassed()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n\n", null, null, (int)0, null, Companion::checkResultToExplanation$lambda$1, (int)30, null);
                        object = string;
                        if (string != null) return object;
                        return "";
                    }
                    case 2: {
                        String string = UrlAssistantBundle.message("accordion.content.action.view.passed", new Object[0]);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return object;
                    }
                    case 3: {
                        String string = UrlAssistantBundle.message("accordion.content.default.category.passed", new Object[0]);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return object;
                    }
                    case 4: {
                        String string = UrlAssistantBundle.message("accordion.content.browsable.category.passed", new Object[0]);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return object;
                    }
                    case 5: {
                        String string = UrlAssistantBundle.message("accordion.content.auto.verify.passed", new Object[0]);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return object;
                    }
                    case 6: {
                        String string = UrlAssistantBundle.message("accordion.content.order.passed", new Object[0]);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return object;
                    }
                    case 7: {
                        String string = UrlAssistantBundle.message("accordion.content.priority.passed", new Object[0]);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return object;
                    }
                    case 8: {
                        String string = UrlAssistantBundle.message("accordion.content.redirect.passed", new Object[0]);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return object;
                    }
                    case 9: {
                        throw new AssertionError((Object)"Link validation type should be specified.");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$1[intentFilterCheckResult.getCheckName().ordinal()]) {
                case 1: {
                    DataTagCheckSummary dataTagCheckSummary = intentFilterCheckResult.getSubCheckSummary();
                    object = dataTagCheckSummary;
                    if (dataTagCheckSummary == null) return "";
                    List<DataTagCheckResult> list = ((DataTagCheckSummary)object).getDataTagCheckResults();
                    object = list;
                    if (list == null) return "";
                    Iterable $this$filter$iv = (Iterable)object;
                    boolean $i$f$filter = false;
                    Iterable $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        DataTagCheckResult it = (DataTagCheckResult)element$iv$iv;
                        boolean bl = false;
                        if (!(!it.isCheckPassed())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n\n", null, null, (int)0, null, Companion::checkResultToExplanation$lambda$3, (int)30, null);
                    object = string;
                    if (string != null) return object;
                    return "";
                }
                case 2: {
                    String string = UrlAssistantBundle.message("accordion.content.action.view.failed", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return object;
                }
                case 3: {
                    String string = UrlAssistantBundle.message("accordion.content.default.category.failed", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return object;
                }
                case 4: {
                    String string = UrlAssistantBundle.message("accordion.content.browsable.category.failed", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return object;
                }
                case 5: {
                    String string = UrlAssistantBundle.message("accordion.content.auto.verify.failed", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return object;
                }
                case 6: {
                    String string = UrlAssistantBundle.message("accordion.content.order.failed", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return object;
                }
                case 7: {
                    String string = UrlAssistantBundle.message("accordion.content.priority.failed", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return object;
                }
                case 8: {
                    String string = UrlAssistantBundle.message("accordion.content.redirect.failed", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return object;
                }
                case 9: {
                    throw new AssertionError((Object)"Link validation type should be specified.");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @NotNull
        public final String checkNameToReferenceLink(@NotNull IntentFilterCheckName intentFilterCheckName) {
            Intrinsics.checkNotNullParameter((Object)((Object)intentFilterCheckName), (String)"intentFilterCheckName");
            return switch (WhenMappings.$EnumSwitchMapping$1[intentFilterCheckName.ordinal()]) {
                case 1, 2, 3, 4 -> AppLinkDetailModel.DEEPLINKING_REFERENCE;
                case 6, 7 -> AppLinkDetailModel.INTENT_FILTER_REFERENCE;
                case 5 -> AppLinkDetailModel.VERIFY_REFERENCE;
                case 8 -> AppLinkDetailModel.REDIRECT_REFERENCE;
                case 9 -> throw new AssertionError((Object)"Link validation type should be specified.");
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final String checkResultToExplanation(@NotNull WebAssociationCheckResult webCheckResult, @NotNull WebCheckSummary webCheckSummary) {
            String string;
            block24: {
                block25: {
                    block23: {
                        Intrinsics.checkNotNullParameter((Object)webCheckResult, (String)"webCheckResult");
                        Intrinsics.checkNotNullParameter((Object)webCheckSummary, (String)"webCheckSummary");
                        if (!webCheckResult.isIgnored()) break block23;
                        if (WhenMappings.$EnumSwitchMapping$2[webCheckResult.getCheckName().ordinal()] != 1) {
                            throw new AssertionError((Object)("Unsupported ignored check name: " + webCheckResult.getCheckName()));
                        }
                        String string2 = UrlAssistantBundle.message("web.check.fingerprint.ignored", new Object[0]);
                        Intrinsics.checkNotNull((Object)string2);
                        string = string2;
                        break block24;
                    }
                    if (!webCheckResult.isCheckPassed()) break block25;
                    switch (WhenMappings.$EnumSwitchMapping$2[webCheckResult.getCheckName().ordinal()]) {
                        case 2: {
                            String string3 = UrlAssistantBundle.message("web.check.existence.passed", new Object[0]);
                            string = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                            break block24;
                        }
                        case 3: {
                            String string4 = UrlAssistantBundle.message("web.check.app.identifier.passed", new Object[0]);
                            string = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                            break block24;
                        }
                        case 1: {
                            String string5 = UrlAssistantBundle.message("web.check.fingerprint.passed", new Object[0]);
                            string = string5;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                            break block24;
                        }
                        case 4: {
                            String string6 = UrlAssistantBundle.message("web.check.content.type.passed", new Object[0]);
                            string = string6;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                            break block24;
                        }
                        case 5: {
                            String string7 = UrlAssistantBundle.message("web.check.https.accessibility.passed", new Object[0]);
                            string = string7;
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
                            break block24;
                        }
                        case 6: {
                            String string8 = UrlAssistantBundle.message("web.check.non.redirect.passed", new Object[0]);
                            string = string8;
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
                            break block24;
                        }
                        case 7: {
                            String string9 = UrlAssistantBundle.message("web.check.host.formed.properly.passed", new Object[0]);
                            string = string9;
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
                            break block24;
                        }
                        case 8: {
                            string = webCheckSummary.getDebugMessage();
                            break block24;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            throw new AssertionError((Object)("Unsupported passed check name: " + webCheckResult.getCheckName()));
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                switch (WhenMappings.$EnumSwitchMapping$2[webCheckResult.getCheckName().ordinal()]) {
                    case 2: {
                        String string10 = UrlAssistantBundle.message("web.check.existence.failed", new Object[0]);
                        string = string10;
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
                        break;
                    }
                    case 3: {
                        String string11 = UrlAssistantBundle.message("web.check.app.identifier.failed", new Object[0]);
                        string = string11;
                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(...)");
                        break;
                    }
                    case 1: {
                        String string12 = UrlAssistantBundle.message("web.check.fingerprint.failed", new Object[0]);
                        string = string12;
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"message(...)");
                        break;
                    }
                    case 4: {
                        String string13 = UrlAssistantBundle.message("web.check.content.type.failed", new Object[0]);
                        string = string13;
                        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"message(...)");
                        break;
                    }
                    case 5: {
                        String string14 = UrlAssistantBundle.message("web.check.https.accessibility.failed", new Object[0]);
                        string = string14;
                        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"message(...)");
                        break;
                    }
                    case 6: {
                        String string15 = UrlAssistantBundle.message("web.check.non.redirect.failed", new Object[0]);
                        string = string15;
                        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"message(...)");
                        break;
                    }
                    case 7: {
                        String string16 = UrlAssistantBundle.message("web.check.host.formed.properly.failed", new Object[0]);
                        string = string16;
                        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"message(...)");
                        break;
                    }
                    case 8: {
                        string = webCheckSummary.getDebugMessage();
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new AssertionError((Object)("Unsupported failed check name: " + webCheckResult.getCheckName()));
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return string;
        }

        @NotNull
        public final String checkNameToReferenceLink(@NotNull AssetLinksCheckName assetLinksCheckName) {
            Intrinsics.checkNotNullParameter((Object)assetLinksCheckName, (String)"assetLinksCheckName");
            return switch (WhenMappings.$EnumSwitchMapping$2[assetLinksCheckName.ordinal()]) {
                case 2, 4, 5, 6, 7 -> AppLinkDetailModel.DAL_HOSTING_REFERENCE;
                case 1, 3, 8 -> AppLinkDetailModel.DAL_FILE_CONTENT_REFERENCE;
                case 9, 10, 11 -> throw new AssertionError((Object)"Check name should not be unspecified or unrecognized");
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private static final CharSequence checkResultToExplanation$lambda$1(DataTagCheckResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return switch (WhenMappings.$EnumSwitchMapping$0[it.getCheckName().ordinal()]) {
                case 1 -> {
                    String v0 = UrlAssistantBundle.message("accordion.content.data.scheme.passed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message(...)");
                    yield v0;
                }
                case 2 -> {
                    String v2 = UrlAssistantBundle.message("accordion.content.data.host.passed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(...)");
                    yield v2;
                }
                case 3 -> {
                    String v3 = UrlAssistantBundle.message("accordion.content.data.scheme.webschemehashost.passed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"message(...)");
                    yield v3;
                }
                case 4 -> {
                    String v4 = UrlAssistantBundle.message("accordion.content.data.path.hashost.passed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"message(...)");
                    yield v4;
                }
                case 5 -> {
                    String v5 = UrlAssistantBundle.message("accordion.content.data.path.passed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"message(...)");
                    yield v5;
                }
                case 6 -> {
                    String v6 = UrlAssistantBundle.message("accordion.content.data.path.prefix.passed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"message(...)");
                    yield v6;
                }
                case 7 -> {
                    String v7 = UrlAssistantBundle.message("accordion.content.data.path.pattern.passed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"message(...)");
                    yield v7;
                }
                case 8 -> {
                    String v8 = UrlAssistantBundle.message("accordion.content.data.port.passed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"message(...)");
                    yield v8;
                }
                default -> "";
            };
        }

        private static final CharSequence checkResultToExplanation$lambda$3(DataTagCheckResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return switch (WhenMappings.$EnumSwitchMapping$0[it.getCheckName().ordinal()]) {
                case 1 -> {
                    String v0 = UrlAssistantBundle.message("accordion.content.data.scheme.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message(...)");
                    yield v0;
                }
                case 2 -> {
                    String v2 = UrlAssistantBundle.message("accordion.content.data.host.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(...)");
                    yield v2;
                }
                case 3 -> {
                    String v3 = UrlAssistantBundle.message("accordion.content.data.scheme.webschemehashost.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"message(...)");
                    yield v3;
                }
                case 4 -> {
                    String v4 = UrlAssistantBundle.message("accordion.content.data.path.hashost.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"message(...)");
                    yield v4;
                }
                case 5 -> {
                    String v5 = UrlAssistantBundle.message("accordion.content.data.path.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"message(...)");
                    yield v5;
                }
                case 6 -> {
                    String v6 = UrlAssistantBundle.message("accordion.content.data.path.prefix.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"message(...)");
                    yield v6;
                }
                case 7 -> {
                    String v7 = UrlAssistantBundle.message("accordion.content.data.path.pattern.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"message(...)");
                    yield v7;
                }
                case 8 -> {
                    String v8 = UrlAssistantBundle.message("accordion.content.data.port.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"message(...)");
                    yield v8;
                }
                default -> "";
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;

            static {
                int[] nArray = new int[DataTagCheckName.values().length];
                try {
                    nArray[DataTagCheckName.SCHEME_EXISTENCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataTagCheckName.HOST_EXISTENCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataTagCheckName.WEB_SCHEME_HAS_HOST.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataTagCheckName.PATH_HAS_HOST.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataTagCheckName.PROPERLY_FORMED_PATH.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataTagCheckName.PROPERLY_FORMED_PATH_PREFIX.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataTagCheckName.PROPERLY_FORMED_PATH_PATTERN.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataTagCheckName.PORT.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[IntentFilterCheckName.values().length];
                try {
                    nArray[IntentFilterCheckName.DATA_TAG.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.ACTION_VIEW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.DEFAULT_CATEGORY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.BROWSABLE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.AUTO_VERIFY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.ORDER.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.PRIORITY.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.NON_REDIRECT_LINK.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.LINK_VALIDATION_TYPE_UNSPECIFIED.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[AssetLinksCheckName.values().length];
                try {
                    nArray[AssetLinksCheckName.FINGERPRINT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.EXISTENCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.APP_IDENTIFIER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.CONTENT_TYPE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.HTTPS_ACCESSIBILITY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.NON_REDIRECT.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.HOST_FORMED_PROPERLY.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.OTHER_CHECKS.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.PLAY_SIGNING_KEY.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.ASSET_LINKS_CHECK_NAME_UNSPECIFIED.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AssetLinksCheckName.UNRECOGNIZED.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathType.values().length];
            try {
                nArray[PathType.EXACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PREFIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PATTERN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.ADVANCED_PATTERN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.SUFFIX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

