/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.ui.UiUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0011\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020!H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010%\u001a\u00020&H\u0016J\"\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0016J\"\u0010,\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0016J\b\u0010-\u001a\u00020\u001fH\u0016J\b\u0010.\u001a\u00020\u001fH\u0016R\u001a\u0010\r\u001a\u00020\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/google/urlassistant/ui/UrlAssistantWindowWithHeader;", "Ljavax/swing/JPanel;", "Lcom/google/urlassistant/editor/UrlAssistantWindowBase;", "Ljavax/swing/Scrollable;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "description", "stepNumber", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;I)V", "rootPanel", "getRootPanel", "()Ljavax/swing/JPanel;", "setRootPanel", "(Ljavax/swing/JPanel;)V", "contentPanel", "getContentPanel", "setContentPanel", "defaultSpaceAmount", "verticalInsets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "grayTextColor", "Lcom/intellij/ui/JBColor;", "stepToIcon", "", "Ljavax/swing/ImageIcon;", "isDisposed", "", "selectNotify", "", "asPanel", "Ljavax/swing/JComponent;", "dispose", "getPreferredScrollableViewportSize", "Ljava/awt/Dimension;", "getScrollableUnitIncrement", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableBlockIncrement", "getScrollableTracksViewportWidth", "getScrollableTracksViewportHeight", "url-assistant"})
public class UrlAssistantWindowWithHeader
extends JPanel
implements UrlAssistantWindowBase,
Scrollable {
    @NotNull
    private JPanel rootPanel;
    @NotNull
    private JPanel contentPanel;
    private final int defaultSpaceAmount;
    @NotNull
    private final JBInsets verticalInsets;
    @NotNull
    private final JBColor grayTextColor;
    @NotNull
    private final Map<Integer, ImageIcon> stepToIcon;
    private boolean isDisposed;

    public UrlAssistantWindowWithHeader(@NotNull Project project, @NotNull String title, @NotNull String description, int stepNumber) {
        GridBagConstraints gridBagConstraints;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        super(new BorderLayout());
        this.rootPanel = new JPanel(new GridBagLayout());
        this.contentPanel = new JPanel(new GridBagLayout());
        this.defaultSpaceAmount = 10;
        JBInsets jBInsets = JBUI.insets((int)this.defaultSpaceAmount, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        this.verticalInsets = jBInsets;
        this.grayTextColor = new JBColor((Color)Gray._80, (Color)Gray._156);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)new ImageIcon(this.getClass().getResource("/url_assistant/step_one.png"))), TuplesKt.to((Object)3, (Object)new ImageIcon(this.getClass().getResource("/url_assistant/step_three.png"))), TuplesKt.to((Object)4, (Object)new ImageIcon(this.getClass().getResource("/url_assistant/step_four.png")))};
        this.stepToIcon = MapsKt.mapOf((Pair[])pairArray);
        this.rootPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.rootPanel.setFocusCycleRoot(true);
        JPanel headerPanel = new JPanel(new GridBagLayout());
        JBLabel titleLabel = new JBLabel(title);
        titleLabel.setFont(titleLabel.getFont().deriveFont(22.0f));
        UiUtils.MultilineText descriptionTextArea = new UiUtils.MultilineText(description);
        JBLabel smallTitleLabel = new JBLabel(UrlAssistantBundle.message("url.assistant.toolwindow.smalltitle", new Object[0]));
        smallTitleLabel.setFont(smallTitleLabel.getFont().deriveFont(12.0f));
        smallTitleLabel.setForeground((Color)this.grayTextColor);
        JBLabel stepIcon = new JBLabel("");
        stepIcon.setIcon((Icon)this.stepToIcon.get(stepNumber));
        stepIcon.setIconTextGap(6);
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(20, 30, 30, 30));
        this.add(this.rootPanel);
        GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
        Component component = headerPanel;
        JPanel jPanel = this.rootPanel;
        boolean bl = false;
        $this$_init__u24lambda_u240.gridy = 0;
        $this$_init__u24lambda_u240.gridx = 0;
        $this$_init__u24lambda_u240.anchor = 11;
        $this$_init__u24lambda_u240.fill = 2;
        $this$_init__u24lambda_u240.weightx = 1.0;
        Unit unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u240 = gridBagConstraints = new GridBagConstraints();
        component = (Component)stepIcon;
        jPanel = headerPanel;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.gridy = 0;
        $this$_init__u24lambda_u241.gridx = 0;
        $this$_init__u24lambda_u241.gridheight = 2;
        $this$_init__u24lambda_u241.insets = (Insets)JBUI.insetsRight((int)this.defaultSpaceAmount);
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u241 = gridBagConstraints = new GridBagConstraints();
        component = (Component)smallTitleLabel;
        jPanel = headerPanel;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.gridy = 0;
        $this$_init__u24lambda_u242.gridx = 1;
        $this$_init__u24lambda_u242.anchor = 17;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u242 = gridBagConstraints = new GridBagConstraints();
        component = (Component)titleLabel;
        jPanel = headerPanel;
        boolean bl4 = false;
        $this$_init__u24lambda_u243.gridy = 1;
        $this$_init__u24lambda_u243.gridx = 1;
        $this$_init__u24lambda_u243.anchor = 17;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u243 = gridBagConstraints = new GridBagConstraints();
        component = (Component)new Spacer();
        jPanel = headerPanel;
        boolean bl5 = false;
        $this$_init__u24lambda_u244.gridy = 0;
        $this$_init__u24lambda_u244.gridx = 2;
        $this$_init__u24lambda_u244.gridheight = 2;
        $this$_init__u24lambda_u244.fill = 2;
        $this$_init__u24lambda_u244.weightx = 1.0;
        $this$_init__u24lambda_u244.weighty = 1.0;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u244 = gridBagConstraints = new GridBagConstraints();
        component = (Component)((Object)descriptionTextArea);
        jPanel = headerPanel;
        boolean bl6 = false;
        $this$_init__u24lambda_u245.gridy = 3;
        $this$_init__u24lambda_u245.gridx = 0;
        $this$_init__u24lambda_u245.gridwidth = 3;
        $this$_init__u24lambda_u245.anchor = 17;
        $this$_init__u24lambda_u245.fill = 2;
        $this$_init__u24lambda_u245.weightx = 1.0;
        $this$_init__u24lambda_u245.weighty = 0.5;
        $this$_init__u24lambda_u245.insets = (Insets)this.verticalInsets;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$_init__u24lambda_u245 = gridBagConstraints = new GridBagConstraints();
        component = new JSeparator();
        jPanel = headerPanel;
        boolean bl7 = false;
        $this$_init__u24lambda_u246.gridy = 5;
        $this$_init__u24lambda_u246.gridx = 0;
        $this$_init__u24lambda_u246.gridwidth = 3;
        $this$_init__u24lambda_u246.fill = 2;
        $this$_init__u24lambda_u246.weightx = 0.5;
        $this$_init__u24lambda_u246.weighty = 0.5;
        $this$_init__u24lambda_u246.insets = (Insets)this.verticalInsets;
        unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        this.rootPanel.add((Component)this.contentPanel, UiUtils.INSTANCE.createConstraintsForExpander(1, 0));
    }

    @NotNull
    protected final JPanel getRootPanel() {
        return this.rootPanel;
    }

    protected final void setRootPanel(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.rootPanel = jPanel;
    }

    @NotNull
    protected final JPanel getContentPanel() {
        return this.contentPanel;
    }

    protected final void setContentPanel(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.contentPanel = jPanel;
    }

    @Override
    public void selectNotify() {
    }

    @Override
    @NotNull
    public JComponent asPanel() {
        return this;
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.rootPanel.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(@Nullable Rectangle visibleRect, int orientation, int direction) {
        return JBUIScale.scale((int)10);
    }

    @Override
    public int getScrollableBlockIncrement(@Nullable Rectangle visibleRect, int orientation, int direction) {
        return JBUIScale.scale((int)10);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

