/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.agent.tools;

import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.urlassistant.agent.tools.LaunchAppViaUrlArgs;
import com.google.urlassistant.agent.tools.LaunchAppViaUrlHandlerImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Launch app on device or emulator via app links.", description="This tool launches an Android app on a connected device or emulator using a specified URL. It requires the package name of the app, the activity to launch, and the URL to be opened.", examples={})
@ToolResult(description="Returns an immediate confirmation that the command was sent and a message you should present to the user for them to check the launched screen.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/google/urlassistant/agent/tools/LaunchAppViaUrlTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/urlassistant/agent/tools/LaunchAppViaUrlArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "url-assistant"})
public final class LaunchAppViaUrlTool
implements Tool<LaunchAppViaUrlArgs> {
    @NotNull
    private final String name;

    public LaunchAppViaUrlTool() {
        this.name = "launch_app_via_url";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getRunningDisplayText(@NotNull LaunchAppViaUrlArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Launching " + args.getPackageName() + "/" + args.getActivityName() + " via URL: " + args.getUrl() + " on connected emulator or device.";
    }

    @NotNull
    public String getCompletedDisplayText(@NotNull LaunchAppViaUrlArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Launched " + args.getPackageName() + "/" + args.getActivityName() + " via URL: " + args.getUrl() + " on connected emulator or device.";
    }

    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context, @NotNull LaunchAppViaUrlArgs args) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new LaunchAppViaUrlHandlerImpl(context, args);
    }
}

